/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalAnnotationModel
extends AbstractSimpleLocalModel<PsiClass> {
    @NotNull
    private final PsiClass myClass;
    @NotNull
    protected final Module myModule;
    @NotNull
    protected final Set<String> myActiveProfiles;
    @NotNull
    private final CachedValue<Collection<ContextJavaBean>> myLocalContextBeansCachedValue;

    public LocalAnnotationModel(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            LocalAnnotationModel.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            LocalAnnotationModel.$$$reportNull$$$0(2);
        }
        this.myClass = aClass;
        this.myModule = module;
        this.myActiveProfiles = Collections.unmodifiableSet(activeProfiles);
        this.myLocalContextBeansCachedValue = CachedValuesManager.getManager((Project)this.myClass.getProject()).createCachedValue(() -> {
            List beans = JamService.getJamService((Project)this.myClass.getProject()).getAnnotatedMembersList(this.myClass, ContextJavaBean.BEAN_JAM_KEY, 10);
            HashSet dependencies = ContainerUtil.newHashSet((Object[])new PsiFile[]{this.myClass.getContainingFile()});
            for (ContextJavaBean bean : beans) {
                if (!bean.isValid()) continue;
                ContainerUtil.addIfNotNull((Collection)dependencies, (Object)bean.getContainingFile());
            }
            return CachedValueProvider.Result.create((Object)beans, (Collection)dependencies);
        });
    }

    @Override
    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @Override
    public final Collection<SpringBeanPointer> getLocalBeans() {
        SmartList allBeans = new SmartList();
        ContainerUtil.addIfNotNull((Collection)allBeans, (Object)LocalAnnotationModel.getBeanForClass(this.myClass));
        ContainerUtil.addAllNotNull((Collection)allBeans, SpringProfileUtils.filterBeansInActiveProfiles((Collection)this.myLocalContextBeansCachedValue.getValue(), this.getActiveProfiles()));
        return BeanService.getInstance().mapSpringBeans((Collection<? extends CommonSpringBean>)allBeans);
    }

    @Nullable
    private static CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(4);
        }
        return (CommonSpringBean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            CommonSpringBean commonSpringBean = (CommonSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass);
            if (commonSpringBean == null && !aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass(aClass)) {
                commonSpringBean = new CustomSpringComponent(aClass);
            }
            return CachedValueProvider.Result.createSingleDependency((Object)commonSpringBean, (Object)aClass);
        });
    }

    @Override
    public Set<CommonSpringModel> getRelatedModels() {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        ContainerUtil.addAllNotNull(models, this.getRelatedLocalModels());
        ContainerUtil.addAllNotNull(models, this.getCachedPackageScanModel());
        ContainerUtil.addAllNotNull(models, this.getCachedInnerStaticClassConfigurations());
        ContainerUtil.addAllNotNull(models, (Object[])new CommonSpringModel[]{this.getCustomDiscoveredBeansModel()});
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getCachedPackageScanModel() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getPackageScanModels(this), (Object[])LocalAnnotationModel.getOutsideModelDependencies(this)));
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull LocalAnnotationModel localModel) {
        if (localModel == null) {
            LocalAnnotationModel.$$$reportNull$$$0(6);
        }
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        Module module = localModel.getModule();
        for (SpringBeansPackagesScan scan : localModel.getPackagesScans()) {
            models.add(new SpringComponentScanModel<SpringBeansPackagesScan>(module, scan, localModel.getActiveProfiles()));
        }
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            LocalAnnotationModel.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<CommonSpringModel> getCachedInnerStaticClassConfigurations() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.getInnerStaticClassConfigurations(this.getConfig()), (Object[])LocalAnnotationModel.getOutsideModelDependencies(this)));
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(8);
        }
        return set;
    }

    private Set<CommonSpringModel> getInnerStaticClassConfigurations(@NotNull PsiClass config) {
        if (config == null) {
            LocalAnnotationModel.$$$reportNull$$$0(9);
        }
        return LocalAnnotationModel.getInnerStaticClassModels(config, aClass -> this.getLocalAnnotationModel((PsiClass)aClass));
    }

    public static Set<CommonSpringModel> getInnerStaticClassModels(@NotNull PsiClass config, Function<? super PsiClass, ? extends CommonSpringModel> mapper) {
        if (config == null) {
            LocalAnnotationModel.$$$reportNull$$$0(10);
        }
        return Arrays.stream(config.getAllInnerClasses()).filter(psiClass -> psiClass.hasModifierProperty("static") && JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null).map(mapper).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalAnnotationModel.$$$reportNull$$$0(11);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<String> getProfiles() {
        LinkedHashSet<String> allProfiles = new LinkedHashSet<String>();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            allProfiles.addAll(configuration.getProfile().getNames());
            for (SpringJavaBean springJavaBean : configuration.getBeans()) {
                allProfiles.addAll(springJavaBean.getProfile().getNames());
            }
        }
        LinkedHashSet<String> linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            LocalAnnotationModel.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @Nullable
    private SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        SmartList packageScans = new SmartList();
        packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(this.myClass));
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(superClass));
        }
        SmartList smartList = packageScans;
        if (smartList == null) {
            LocalAnnotationModel.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> {
            Module module = this.getModule();
            HashSet models = new HashSet();
            if (!module.isDisposed()) {
                SpringJamUtils.getInstance().processImportedResources(this.myClass, (Processor<Pair<List<XmlFile>, ? extends PsiElement>>)((Processor)pair -> {
                    for (XmlFile xmlFile : (List)pair.first) {
                        LocalAnnotationModel.addNotNullModel(models, SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(xmlFile, module, this.getActiveProfiles()), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
                    }
                    return true;
                }), this.myModule);
                SpringJamUtils.getInstance().processImportedClasses(this.myClass, (Processor<Pair<PsiClass, ? extends PsiElement>>)((Processor)pair -> {
                    LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)pair.first), LocalModelDependency.create(LocalModelDependencyType.IMPORT, (PsiElement)pair.second));
                    return true;
                }));
                this.processScannedConfigurations(this.myClass, (Processor<Pair<PsiPackage, ? extends PsiElement>>)((Processor)pair -> {
                    if (module.isDisposed()) {
                        return false;
                    }
                    GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                    GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)((PsiPackage)pair.first), (boolean)true));
                    List<SpringConfiguration> configurations = SpringJamModel.getModel(module).getConfigurations(searchScope);
                    for (SpringConfiguration configuration : configurations) {
                        if (!SpringCommonUtils.isSpringBeanCandidateClass(configuration.getPsiElement()) || !SpringProfileUtils.isInActiveProfiles(configuration, this.getActiveProfiles())) continue;
                        PsiElement identifyingElementForDependency = (PsiElement)pair.second;
                        LocalModelDependency dependency = LocalModelDependency.create(LocalModelDependencyType.COMPONENT_SCAN, identifyingElementForDependency == null ? (PsiElement)pair.first : identifyingElementForDependency);
                        LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel(configuration), dependency);
                    }
                    return true;
                }));
                SpringJamUtils.getInstance().processCustomAnnotations(this.myClass, (Processor<Pair<PsiClass, LocalModelDependency>>)((Processor)enableAnnotation -> {
                    LocalAnnotationModel.addNotNullModel(models, this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)enableAnnotation.getSecond());
                    return true;
                }));
                SpringJamUtils.getInstance().processCustomDependentLocalModels(this, (PairProcessor<? super LocalModel, ? super LocalModelDependency>)((PairProcessor)(model, dependency) -> {
                    LocalAnnotationModel.addNotNullModel(models, model, dependency);
                    return true;
                }));
            }
            LinkedHashSet dependencies = new LinkedHashSet();
            ContainerUtil.addAll(dependencies, (Object[])LocalAnnotationModel.getOutsideModelDependencies(this));
            dependencies.addAll(models.stream().map(pair -> ((LocalModel)pair.first).getConfig()).collect(Collectors.toSet()));
            return CachedValueProvider.Result.create(models, (Object[])ArrayUtil.toObjectArray(dependencies));
        });
        if (set == null) {
            LocalAnnotationModel.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            LocalAnnotationModel.$$$reportNull$$$0(16);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    @Nullable
    private LocalAnnotationModel getLocalAnnotationModel(@NotNull SpringConfiguration configuration) {
        if (configuration == null) {
            LocalAnnotationModel.$$$reportNull$$$0(17);
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration.getPsiElement(), this.getModule(), this.getActiveProfiles());
    }

    protected boolean processScannedConfigurations(@NotNull PsiClass classToProcess, @NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor2) {
        if (classToProcess == null) {
            LocalAnnotationModel.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            LocalAnnotationModel.$$$reportNull$$$0(19);
        }
        List<? extends SpringBeansPackagesScan> scans = SpringJamUtils.getInstance().getBeansPackagesScan(classToProcess);
        for (SpringBeansPackagesScan springBeansPackagesScan : scans) {
            if (this.processPackagesScan(processor2, springBeansPackagesScan)) continue;
            return false;
        }
        return true;
    }

    protected boolean processPackagesScan(@NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor2, SpringBeansPackagesScan packagesScan) {
        if (processor2 == null) {
            LocalAnnotationModel.$$$reportNull$$$0(20);
        }
        if (packagesScan instanceof SpringComponentScan) {
            SpringComponentScan componentScan = (SpringComponentScan)packagesScan;
            if (!componentScan.processPsiPackages(processor2)) {
                return false;
            }
        } else {
            for (PsiPackage aPackage : packagesScan.getPsiPackages()) {
                if (processor2.process((Object)Pair.create((Object)aPackage, (Object)packagesScan.getIdentifyingPsiElement()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAnnotationModel)) {
            return false;
        }
        LocalAnnotationModel model = (LocalAnnotationModel)o;
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    @Override
    protected Collection<Object> getCachingProcessorsDependencies() {
        HashSet<Object> dependencies = new HashSet<Object>();
        Collections.addAll(dependencies, SpringModificationTrackersManager.getInstance(this.myClass.getProject()).getOuterModelsDependencies());
        Collections.addAll(dependencies, Arrays.stream(this.myClass.getSupers()).map(aClass -> aClass.getContainingFile()).filter(psiFile -> psiFile != null && !(psiFile instanceof ClsFileImpl)).toArray());
        return dependencies;
    }

    @Override
    @NotNull
    public final List<SpringBeanPointer> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            LocalAnnotationModel.$$$reportNull$$$0(21);
        }
        List<SpringBeanPointer> list = LocalAnnotationModel.findLocalBeansByQualifier(this, qualifier);
        if (list == null) {
            LocalAnnotationModel.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalAnnotationModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToProcess";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalAnnotationModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPackageScanModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScanModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInnerStaticClassConfigurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBeanForClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScanModels";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassConfigurations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassModels";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processScannedConfigurations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processPackagesScan";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

