/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.AbstractProcessableModel;
import com.intellij.spring.contexts.model.SpringCachingProcessor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheableCommonSpringModel
extends AbstractProcessableModel
implements CommonSpringModel {
    private CachedValue<LocalBeansByNameCachingProcessor> myBeanNameCachingProcessor = null;

    public Collection<SpringBeanPointer> getLocalBeans() {
        return Collections.emptyList();
    }

    @NotNull
    public Set<String> getProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor2) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(3);
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.processLocalBeansByClass(params, processor2)) {
            return false;
        }
        return super.processByClass(params, processor2);
    }

    public boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor2) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(5);
        }
        if (!params.canSearch()) {
            return true;
        }
        PsiType searchType = params.getSearchType();
        if (params.isEffectiveBeanTypes()) {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                for (PsiType effectiveBeanType : beanPointer.getEffectiveBeanTypes()) {
                    if (CacheableCommonSpringModel.processLocalBeanClass(processor2, searchType, beanPointer, effectiveBeanType)) continue;
                    return false;
                }
            }
        } else {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                if (CacheableCommonSpringModel.processLocalBeanClass(processor2, searchType, beanPointer, beanPointer.getSpringBean().getBeanType())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processLocalBeanClass(@NotNull Processor<? super SpringBeanPointer> processor2, @NotNull PsiType searchType, SpringBeanPointer beanPointer, @Nullable PsiType beanType) {
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(6);
        }
        if (searchType == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(7);
        }
        if (beanType != null && searchType.isAssignableFrom(beanType)) {
            return processor2.process((Object)beanPointer);
        }
        return true;
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor2) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(9);
        }
        if (!params.canSearch()) {
            return true;
        }
        if (!this.processLocalBeansByName(params, processor2)) {
            return false;
        }
        return super.processByName(params, processor2);
    }

    public boolean processLocalBeansByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor2) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(11);
        }
        if (!params.canSearch()) {
            return true;
        }
        CachedValue<LocalBeansByNameCachingProcessor> cachingProcessor = this.getBeanNameCachingProcessor();
        return cachingProcessor == null || ((LocalBeansByNameCachingProcessor)cachingProcessor.getValue()).process(params, processor2, this.getActiveProfiles());
    }

    protected void doProcessLocalBeans(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer> processor2) {
        if (params == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(13);
        }
        for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
            if (!CacheableCommonSpringModel.matchesName(params, beanPointer) || processor2.process((Object)beanPointer)) continue;
            return;
        }
    }

    @Override
    public final boolean processAllBeans(@NotNull Processor<SpringBeanPointer> processor2) {
        if (processor2 == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(14);
        }
        for (SpringBeanPointer pointer : this.getLocalBeans()) {
            if (processor2.process((Object)pointer)) continue;
            return false;
        }
        return super.processAllBeans(processor2);
    }

    private static boolean matchesName(SpringModelSearchParameters.BeanName params, SpringBeanPointer pointer) {
        String paramsBeanName = params.getBeanName();
        if (paramsBeanName.equals(pointer.getName())) {
            return true;
        }
        for (String aliasName : pointer.getAliases()) {
            if (!paramsBeanName.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull SpringBeanPointer beanPointer) {
        String beanName;
        if (beanPointer == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmptyOrSpaces((String)(beanName = beanPointer.getName()))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CacheableCommonSpringModel.$$$reportNull$$$0(16);
            }
            return set;
        }
        HashSet names = ContainerUtil.newHashSet((Object[])new String[]{beanName});
        for (String aliasName : beanPointer.getAliases()) {
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            names.add(aliasName);
        }
        HashSet hashSet = names;
        if (hashSet == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @Nullable
    private CachedValue<LocalBeansByNameCachingProcessor> getBeanNameCachingProcessor() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        if (this.myBeanNameCachingProcessor == null) {
            this.myBeanNameCachingProcessor = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new LocalBeansByNameCachingProcessor(), this.getCachingProcessorsDependencies()));
        }
        return this.myBeanNameCachingProcessor;
    }

    protected Collection<Object> getCachingProcessorsDependencies() {
        return Collections.singleton(ModificationTracker.EVER_CHANGED);
    }

    protected Object @NotNull [] getDependencies(@NotNull Set<PsiFile> containingFiles) {
        if (containingFiles == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(18);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        ContainerUtil.addAllNotNull(dependencies, containingFiles);
        ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance(this.getModule().getProject()).getOuterModelsDependencies());
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(19);
        }
        return objectArray;
    }

    @NotNull
    public List<SpringBeanPointer> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(20);
        }
        List<SpringBeanPointer> list = CacheableCommonSpringModel.findLocalBeansByQualifier(this, qualifier);
        if (list == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(21);
        }
        return list;
    }

    protected static List<SpringBeanPointer> findLocalBeansByQualifier(@NotNull CacheableCommonSpringModel model, SpringQualifier springQualifier) {
        if (model == null) {
            CacheableCommonSpringModel.$$$reportNull$$$0(22);
        }
        SmartList beans = new SmartList();
        for (SpringBeanPointer beanPointer : model.getLocalBeans()) {
            if (!beanPointer.isValid()) continue;
            Object bean = beanPointer.getSpringBean();
            for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                if (!qualifier.compareQualifiers(springQualifier, model.getModule())) continue;
                beans.add(beanPointer);
            }
        }
        return beans.isEmpty() ? Collections.emptyList() : beans;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processByClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeanClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doProcessLocalBeans";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAllBeans";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBeansByQualifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LocalBeansByNameCachingProcessor
    extends LocalBeansCachingProcessor<SpringModelSearchParameters.BeanName> {
        private LocalBeansByNameCachingProcessor() {
        }

        @Override
        protected void doProcessBeans(@NotNull SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer> processor2) {
            if (params == null) {
                LocalBeansByNameCachingProcessor.$$$reportNull$$$0(0);
            }
            CacheableCommonSpringModel.this.doProcessLocalBeans(params, processor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansByNameCachingProcessor", "doProcessBeans"));
        }
    }

    private static abstract class LocalBeansCachingProcessor<InParams extends SpringModelSearchParameters>
    extends SpringCachingProcessor<InParams> {
        private LocalBeansCachingProcessor() {
        }

        @Override
        @NotNull
        protected Collection<SpringBeanPointer> findPointers(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(0);
            }
            SmartList results = new SmartList();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)collectProcessor);
            SmartList smartList = results.isEmpty() ? Collections.emptyList() : results;
            if (smartList == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        @Override
        @Nullable
        protected SpringBeanPointer findFirstPointer(@NotNull InParams parameters) {
            if (parameters == null) {
                LocalBeansCachingProcessor.$$$reportNull$$$0(2);
            }
            CommonProcessors.FindFirstProcessor firstProcessor = new CommonProcessors.FindFirstProcessor();
            this.doProcessBeans(parameters, (Processor<SpringBeanPointer>)firstProcessor);
            return (SpringBeanPointer)firstProcessor.getFoundValue();
        }

        protected abstract void doProcessBeans(@NotNull InParams var1, Processor<SpringBeanPointer> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansCachingProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/contexts/model/CacheableCommonSpringModel$LocalBeansCachingProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findPointers";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findFirstPointer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

