/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeansSpringModel
extends CacheableCommonSpringModel {
    private final NotNullLazyValue<Collection<? extends SpringBeanPointer>> myPointers;
    private final Module myModule;

    public BeansSpringModel(@Nullable Module module, final @NotNull Set<? extends PsiClass> classes) {
        if (classes == null) {
            BeansSpringModel.$$$reportNull$$$0(0);
        }
        this(module, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

            @NotNull
            protected Collection<? extends SpringBeanPointer> compute() {
                BeanService beanService = BeanService.getInstance();
                LinkedHashSet pointers = new LinkedHashSet(classes.size());
                for (PsiClass psiClass : classes) {
                    if (!psiClass.isValid()) continue;
                    pointers.add(beanService.createSpringBeanPointer(new CustomSpringComponent(psiClass)));
                }
                LinkedHashSet linkedHashSet = pointers;
                if (linkedHashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return linkedHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/BeansSpringModel$1", "compute"));
            }
        });
    }

    public BeansSpringModel(@Nullable Module module, @NotNull NotNullLazyValue<Collection<? extends SpringBeanPointer>> pointers) {
        if (pointers == null) {
            BeansSpringModel.$$$reportNull$$$0(1);
        }
        assert (!(pointers instanceof AtomicNotNullLazyValue));
        this.myModule = module;
        this.myPointers = pointers;
    }

    @Override
    public Collection<SpringBeanPointer> getLocalBeans() {
        return (Collection)this.myPointers.getValue();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "classes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pointers";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/contexts/model/BeansSpringModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

