/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanNamesMapper {
    private final Map<String, SpringBeanPointer> myBeansMap;
    private final Map<String, Pair<String, PsiElementPointer>> myAliasesMap = new THashMap();
    private final MultiMap<String, String> myAllBeanNames;

    BeanNamesMapper(LocalXmlModel model) {
        HashSet<SpringBeanPointer> ownBeans = new HashSet<SpringBeanPointer>(model.getLocalBeans());
        this.myBeansMap = new THashMap(ownBeans.size());
        this.myAllBeanNames = MultiMap.createSet();
        for (SpringBeanPointer bean : ownBeans) {
            String beanName = bean.getName();
            if (!StringUtil.isNotEmpty((String)beanName)) continue;
            this.myBeansMap.put(beanName, bean);
            this.myAllBeanNames.putValue((Object)beanName, (Object)beanName);
            for (String alias : bean.getAliases()) {
                this.registerAlias(beanName, alias, bean, null);
            }
        }
        PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        List<Alias> aliases = BeanNamesMapper.getAliases(model.getRoot());
        for (Alias anAlias : aliases) {
            String aliasedBean = anAlias.getAliasedBean().getRawText();
            String alias = anAlias.getAlias().getRawText();
            if (placeholderUtils.isDefaultPlaceholder(aliasedBean) || placeholderUtils.isDefaultPlaceholder(alias)) continue;
            this.registerAlias(aliasedBean, alias, null, anAlias);
        }
    }

    @Nullable
    SpringBeanPointer getBean(@NotNull String beanName) {
        if (beanName == null) {
            BeanNamesMapper.$$$reportNull$$$0(0);
        }
        String curName = beanName;
        Set visited = null;
        SpringBeanPointer bean;
        while ((bean = this.myBeansMap.get(curName)) == null) {
            Pair<String, PsiElementPointer> newName = this.myAliasesMap.get(curName);
            if (newName == null || visited != null && visited.contains(curName)) {
                return null;
            }
            if (visited == null) {
                visited = new THashSet();
            }
            visited.add(curName);
            curName = (String)newName.getFirst();
        }
        return bean.derive(beanName);
    }

    Set<String> getAllBeanNames(String beanName) {
        return (Set)this.myAllBeanNames.get((Object)beanName);
    }

    private void registerAlias(String beanName, String alias, @Nullable SpringBeanPointer bean, @Nullable Alias anAlias) {
        if (!StringUtil.isNotEmpty((String)alias) || !StringUtil.isNotEmpty((String)beanName) || Objects.equals(beanName, alias)) {
            return;
        }
        SpringBeanPointer elementPointer = bean == null ? DomService.getInstance().createAnchor((DomElement)anAlias) : bean;
        this.myAliasesMap.put(alias, (Pair<String, PsiElementPointer>)Pair.create((Object)beanName, (Object)elementPointer));
        this.myBeansMap.get(alias);
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(alias);
        while (!this.myBeansMap.containsKey(beanName)) {
            Pair<String, PsiElementPointer> pair = this.myAliasesMap.get(beanName);
            if (pair == null) {
                return;
            }
            beanName = (String)pair.getFirst();
            aliases.add(beanName);
        }
        this.myAllBeanNames.putValues((Object)beanName, aliases);
    }

    private static List<Alias> getAliases(@Nullable DomFileElement<Beans> fileElement) {
        if (fileElement == null) {
            return Collections.emptyList();
        }
        List<Alias> list = ((Beans)fileElement.getRootElement()).getAliases();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return new SmartList(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/BeanNamesMapper", "getBean"));
    }
}

