/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleLocalModel<T extends PsiElement>
extends CacheableCommonSpringModel
implements LocalModel<T> {
    private final NotNullLazyValue<CustomDiscoveredBeansModel> myCustomDiscoveredBeansModel = new VolatileNotNullLazyValue<CustomDiscoveredBeansModel>(){

        @NotNull
        protected CustomDiscoveredBeansModel compute() {
            return new CustomDiscoveredBeansModel(AbstractSimpleLocalModel.this);
        }
    };

    @NotNull
    protected CustomDiscoveredBeansModel getCustomDiscoveredBeansModel() {
        CustomDiscoveredBeansModel customDiscoveredBeansModel = (CustomDiscoveredBeansModel)this.myCustomDiscoveredBeansModel.getValue();
        if (customDiscoveredBeansModel == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(0);
        }
        return customDiscoveredBeansModel;
    }

    protected static void addNotNullModel(@NotNull Set<? super Pair<LocalModel, LocalModelDependency>> models, @Nullable LocalModel model, @NotNull LocalModelDependency dependency) {
        if (models == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(2);
        }
        if (model != null) {
            models.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)model, (Object)dependency));
        }
    }

    @Override
    @NotNull
    public Set<LocalModel> getRelatedLocalModels() {
        Set<LocalModel> set = this.getDependentLocalModels().stream().map(pair -> (LocalModel)pair.first).filter(model -> !this.equals(model)).collect(Collectors.toSet());
        if (set == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConfig() + "]";
    }

    protected static Object @NotNull [] getOutsideModelDependencies(@NotNull LocalModel model) {
        if (model == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(4);
        }
        Project project = model.getConfig().getProject();
        Object[] objectArray = ArrayUtil.append((Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies(), model.getConfig());
        if (objectArray == null) {
            AbstractSimpleLocalModel.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomDiscoveredBeansModel";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AbstractSimpleLocalModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedLocalModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutsideModelDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOutsideModelDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class CustomDiscoveredBeansModel
    extends CacheableCommonSpringModel {
        @NotNull
        private final LocalModel<? extends PsiElement> myHostingLocalModel;
        private volatile CachedValue<Collection<SpringBeanPointer>> myCustomDiscoveredBeans;

        CustomDiscoveredBeansModel(@NotNull LocalModel<? extends PsiElement> hostingLocalModel) {
            if (hostingLocalModel == null) {
                CustomDiscoveredBeansModel.$$$reportNull$$$0(0);
            }
            this.myHostingLocalModel = hostingLocalModel;
        }

        @Override
        public final Collection<SpringBeanPointer> getLocalBeans() {
            Module module = this.getModule();
            if (module == null) {
                return Collections.emptyList();
            }
            if (this.myCustomDiscoveredBeans == null) {
                this.myCustomDiscoveredBeans = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                    Collection<SpringBeanPointer> pointers = this.computeCustomBeans();
                    return CachedValueProvider.Result.create(pointers, (Object[])this.getDependencies(pointers.stream().map(pointer -> pointer.getContainingFile()).collect(Collectors.toSet())));
                }, false);
            }
            return (Collection)this.myCustomDiscoveredBeans.getValue();
        }

        private Collection<SpringBeanPointer> computeCustomBeans() {
            LinkedHashSet<CommonSpringBean> customSpringComponents = new LinkedHashSet<CommonSpringBean>();
            for (CustomLocalComponentsDiscoverer discoverer : CustomLocalComponentsDiscoverer.EP_NAME.getExtensionList()) {
                customSpringComponents.addAll(discoverer.getCustomComponents(this.myHostingLocalModel));
            }
            return BeanService.getInstance().mapSpringBeans(customSpringComponents);
        }

        @Override
        @Nullable
        public Module getModule() {
            return this.myHostingLocalModel.getModule();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostingLocalModel", "com/intellij/spring/contexts/model/AbstractSimpleLocalModel$CustomDiscoveredBeansModel", "<init>"));
        }
    }
}

