/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.microservices.mq.MQDestinationAnchor;
import com.intellij.microservices.utils.UsagesNavigationGutterIconBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.messaging.SpringMessagingBundle;
import com.intellij.spring.messaging.SpringMessagingConstants;
import com.intellij.spring.messaging.jam.mq.SpringMQListener;
import com.intellij.spring.messaging.providers.SpringMQLineMarkerProvider;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import icons.MicroservicesIcons;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0014J2\u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "()V", "collectNavigationMarkers", "", "element", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "elements", "", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getName", "Companion", "intellij.spring.messaging"})
public final class SpringMQLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<MQDestinationAnchor, Collection<PsiElement>> MQ_CONVERTER;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "SpringMQLineMarkerProvider";
    }

    @Nullable
    public Icon getIcon() {
        return MicroservicesIcons.Gutter.MessageQueueReceiver;
    }

    @Nullable
    public String getName() {
        return SpringMessagingBundle.message("spring.mq.line.markers.name", new Object[0]);
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        if (!SpringCommonUtils.hasSpringFacets((Project)project2) || !SpringLibraryUtil.hasSpringLibrary((Project)project2)) {
            return;
        }
        if (!(SpringMQUtils.INSTANCE.hasSpringAmqpLibrary(project2) || SpringMQUtils.INSTANCE.hasSpringJmsLibrary(project2) || SpringMQUtils.INSTANCE.hasSpringKafkaLibrary(project2))) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UMethod uMethod = (UMethod)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UMethod.class});
        if (uMethod == null) {
            return;
        }
        UMethod uMethod2 = uMethod;
        PsiMethod psiMethod = uMethod2.getJavaPsi();
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
            return;
        }
        UElement uElement = uMethod2.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return;
        }
        UElement anchor = uElement;
        SemService semService = SemService.getSemService((Project)psiMethod.getProject());
        SmartList relatedMqIds = new SmartList();
        List list = semService.getSemElements(SpringMQListener.SPRING_MQ_LISTENER_KEY, (PsiElement)psiMethod);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"semService.getSemElement\u2026_LISTENER_KEY, psiMethod)");
        List containerJams = list;
        Iterator iterator = containerJams.iterator();
        while (iterator.hasNext()) {
            SpringMQListener containerJam;
            SpringMQListener springMQListener = containerJam = (SpringMQListener)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)springMQListener, (String)"containerJam");
            relatedMqIds.addAll((Collection)springMQListener.getMQDestinations());
        }
        Object[] annotations = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)SpringMessagingConstants.SPRING_MQ_ANNOTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)annotations, (String)"annotations");
        Object $this$forEach$iv = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])annotations), (Function1)((Function1)new Function1<PsiAnnotation, SpringMQListener>(semService){
            final /* synthetic */ SemService $semService;

            @Nullable
            public final SpringMQListener invoke(PsiAnnotation it) {
                return (SpringMQListener)this.$semService.getSemElement(SpringMQListener.SPRING_MQ_LISTENER_KEY, (PsiElement)it);
            }
            {
                this.$semService = semService;
                super(1);
            }
        })), (Function1)collectNavigationMarkers.2.INSTANCE);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            MQDestinationAnchor it = (MQDestinationAnchor)element$iv;
            boolean bl = false;
            relatedMqIds.add((Object)it);
        }
        $this$forEach$iv = (Collection)relatedMqIds;
        boolean bl = false;
        if (!$this$forEach$iv.isEmpty()) {
            Icon icon = MicroservicesIcons.Gutter.MessageQueueReceiver;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicroservicesIcons.Gutter.MessageQueueReceiver");
            NavigationGutterIconBuilder navigationGutterIconBuilder = UsagesNavigationGutterIconBuilder.Companion.create(icon, MQ_CONVERTER).setTargets((Collection)relatedMqIds);
            Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"UsagesNavigationGutterIc\u2026.setTargets(relatedMqIds)");
            NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
            if (relatedMqIds.size() == 1) {
                builder.setTooltipText(SpringMessagingBundle.message("spring.mq.line.markers.tooltip.single", ((MQDestinationAnchor)CollectionsKt.first((List)((List)relatedMqIds))).getDestination().getName()));
            } else {
                builder.setTooltipText(SpringMessagingBundle.message("spring.mq.line.markers.tooltip", new Object[0])).setPopupTitle(SpringMessagingBundle.message("spring.mq.line.markers.popupTitle", new Object[0]));
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo((PsiElement)anchor);
            Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarkerInfo(anchor)");
            result.add(relatedItemLineMarkerInfo);
        }
    }

    static {
        Companion = new Companion(null);
        MQ_CONVERTER = Companion.MQ_CONVERTER.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQLineMarkerProvider$Companion;", "", "()V", "MQ_CONVERTER", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/microservices/mq/MQDestinationAnchor;", "", "Lcom/intellij/psi/PsiElement;", "intellij.spring.messaging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

