/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.support;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypes;
import com.intellij.plugins.drools.lang.psi.DroolsBlock;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsQueryStatement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleName;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringId;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.DroolsTypeName;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DroolsFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        PsiElement element;
        if (node == null) {
            DroolsFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DroolsFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((element = node.getPsi()) instanceof DroolsFile) {
            DroolsFile file = (DroolsFile)element;
            ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
            for (DroolsRuleStatement droolsRuleStatement : file.getRules()) {
                DroolsFoldingBuilder.addRuleFoldingDescriptors(descriptors, droolsRuleStatement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getDeclarations()) {
                DroolsFoldingBuilder.addDeclareFoldingDescriptors(descriptors, (DroolsDeclareStatement)droolsPsiCompositeElement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getQueries()) {
                DroolsFoldingBuilder.addQueryFoldingDescriptors(descriptors, (DroolsQueryStatement)droolsPsiCompositeElement);
            }
            for (DroolsPsiCompositeElement droolsPsiCompositeElement : file.getFunctions()) {
                int end;
                int start;
                DroolsBlock block = droolsPsiCompositeElement.getBlock();
                if (block == null || (start = block.getTextRange().getStartOffset() + 1) + 1 >= (end = block.getTextRange().getEndOffset() - 1)) continue;
                descriptors.add(new FoldingDescriptor(droolsPsiCompositeElement.getNode(), new TextRange(start, end)));
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                DroolsFoldingBuilder.$$$reportNull$$$0(2);
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            DroolsFoldingBuilder.$$$reportNull$$$0(3);
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addRuleFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsRuleStatement rule) {
        int end;
        if (!rule.textContains('\n')) {
            return;
        }
        DroolsRuleName nameElement = rule.getRuleName();
        int start = nameElement.getTextRange().getEndOffset();
        if (start + 1 < (end = rule.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(rule.getNode(), new TextRange(start, end)));
        }
    }

    private static void addDeclareFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsDeclareStatement statement) {
        int end;
        DroolsTypeName nameElement;
        int start;
        if (!statement.textContains('\n')) {
            return;
        }
        DroolsTypeDeclaration declaration = statement.getTypeDeclaration();
        if (declaration != null && (start = (nameElement = declaration.getTypeName()).getTextRange().getEndOffset()) + 1 < (end = statement.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(statement.getNode(), new TextRange(start, end)));
        }
    }

    private static void addQueryFoldingDescriptors(List<FoldingDescriptor> descriptors, DroolsQueryStatement statement) {
        int end;
        if (!statement.textContains('\n')) {
            return;
        }
        DroolsStringId nameElement = statement.getStringId();
        int start = nameElement.getTextRange().getEndOffset();
        if (start + 1 < (end = statement.getTextRange().getEndOffset())) {
            descriptors.add(new FoldingDescriptor(statement.getNode(), new TextRange(start, end)));
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            DroolsFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (node.getElementType() == DroolsTokenTypes.RULE_STATEMENT) {
            return "<~>";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            DroolsFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/drools/lang/support/DroolsFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

