/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsLhsPatternBind;
import com.intellij.plugins.drools.lang.psi.DroolsNameId;
import com.intellij.plugins.drools.lang.psi.DroolsParentRule;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringId;
import com.intellij.plugins.drools.lang.psi.DroolsUnaryAssignExpr;
import com.intellij.plugins.drools.lang.psi.DroolsVisitor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DroolsLhsBindVariablesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsLhsBindVariablesProcessor myInstance;

    private DroolsLhsBindVariablesProcessor() {
    }

    public static DroolsLhsBindVariablesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsLhsBindVariablesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(2);
        }
        if (droolsFile == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(3);
        }
        Set<PsiVariable> binds = DroolsLhsBindVariablesProcessor.getPatternBinds(place);
        for (PsiVariable bind : binds) {
            if (processor.execute((PsiElement)bind, state)) continue;
            return false;
        }
        return true;
    }

    public static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement) {
        PsiFile file;
        if (psiElement == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(4);
        }
        return (file = psiElement.getContainingFile()) instanceof DroolsFile ? DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, (DroolsFile)file, (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsRuleStatement.class)) : Collections.emptySet();
    }

    private static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement, @NotNull DroolsFile droolsFile, @Nullable DroolsRuleStatement droolsRule) {
        if (psiElement == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(5);
        }
        if (droolsFile == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(6);
        }
        return DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, droolsFile, droolsRule, new HashSet<DroolsRuleStatement>());
    }

    private static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement, @NotNull DroolsFile droolsFile, @Nullable DroolsRuleStatement droolsRule, Set<DroolsRuleStatement> visited) {
        DroolsRuleStatement parentRule;
        if (psiElement == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(7);
        }
        if (droolsFile == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(8);
        }
        if (droolsRule == null) {
            return Collections.emptySet();
        }
        visited.add(droolsRule);
        Set<PsiVariable> binds = DroolsLhsBindVariablesProcessor.getVariables(psiElement, droolsRule);
        DroolsParentRule parentRuleRef = droolsRule.getParentRule();
        if (parentRuleRef != null && (parentRule = DroolsLhsBindVariablesProcessor.findRuleById(parentRuleRef.getStringId(), droolsFile)) != null && !visited.contains(parentRule)) {
            binds.addAll(DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, droolsFile, parentRule, visited));
        }
        return binds;
    }

    private static Set<PsiVariable> getVariables(final PsiElement psiElement, DroolsRuleStatement droolsRule) {
        final HashSet<PsiVariable> binds = new HashSet<PsiVariable>();
        droolsRule.acceptChildren(new DroolsVisitor(){

            @Override
            public void visitLhsPatternBind(@NotNull DroolsLhsPatternBind patternBind) {
                String id;
                DroolsNameId bindIdentifier;
                if (patternBind == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((bindIdentifier = patternBind.getNameId()) != null && (id = bindIdentifier.getText()) != null) {
                    binds.add(patternBind);
                }
                patternBind.acceptChildren(this);
            }

            @Override
            public void visitUnaryAssignExpr(@NotNull DroolsUnaryAssignExpr unaryAssignExpr) {
                DroolsUnaryAssignExpr parentUnaryAssignExpr;
                DroolsNameId identifier;
                String id;
                if (unaryAssignExpr == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((id = (identifier = unaryAssignExpr.getNameId()).getText()) != null && !unaryAssignExpr.equals(parentUnaryAssignExpr = (DroolsUnaryAssignExpr)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsUnaryAssignExpr.class))) {
                    binds.add(unaryAssignExpr);
                }
            }

            @Override
            public void visitPsiCompositeElement(@NotNull DroolsPsiCompositeElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                o.acceptChildren(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "patternBind";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unaryAssignExpr";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLhsPatternBind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUnaryAssignExpr";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPsiCompositeElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return binds;
    }

    @Nullable
    private static DroolsRuleStatement findRuleById(@Nullable DroolsStringId id, @NotNull DroolsFile droolsFile) {
        String ruleIdText;
        if (droolsFile == null) {
            DroolsLhsBindVariablesProcessor.$$$reportNull$$$0(9);
        }
        if (id != null && !StringUtil.isEmpty((String)(ruleIdText = id.getText()))) {
            for (DroolsRuleStatement ruleStatement : droolsFile.getRules()) {
                if (!ruleIdText.equals(ruleStatement.getRuleName().getStringId().getText())) continue;
                return ruleStatement;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "droolsFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPatternBinds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findRuleById";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

