/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightVariable;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DroolsImplicitVariablesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsImplicitVariablesProcessor myInstance;
    private static final Map<String, String> vars;

    private DroolsImplicitVariablesProcessor() {
    }

    public static DroolsImplicitVariablesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsImplicitVariablesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            DroolsImplicitVariablesProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            DroolsImplicitVariablesProcessor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            DroolsImplicitVariablesProcessor.$$$reportNull$$$0(2);
        }
        if (droolsFile == null) {
            DroolsImplicitVariablesProcessor.$$$reportNull$$$0(3);
        }
        Set implicitVars = (Set)CachedValuesManager.getCachedValue((PsiElement)droolsFile, () -> {
            HashSet<DroolsLightVariable> lightVariables = new HashSet<DroolsLightVariable>();
            for (Map.Entry<String, String> entry : vars.entrySet()) {
                String className = entry.getValue();
                Project project = droolsFile.getProject();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
                if (aClass == null) continue;
                String varName = entry.getKey();
                lightVariables.add(new DroolsLightVariable(varName, (PsiType)JavaPsiFacade.getInstance((Project)project).getElementFactory().createType((PsiClass)new DroolsLightClass(aClass)), (PsiElement)droolsFile));
            }
            return CachedValueProvider.Result.createSingleDependency(lightVariables, (Object)((Object)droolsFile));
        });
        for (DroolsLightVariable lightVariable : implicitVars) {
            PsiClass psiClass;
            if (!processor.execute((PsiElement)lightVariable, state)) {
                return false;
            }
            if (!lightVariable.getName().equals("drools") || (psiClass = ((PsiClassType)lightVariable.getType()).resolve()) == null || psiClass.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    static {
        vars = new HashMap<String, String>();
        vars.put("kcontext", "org.kie.api.runtime.rule.RuleContext");
        vars.put("drools", "org.drools.core.spi.KnowledgeHelper");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "place";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "droolsFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImplicitVariablesProcessor";
        objectArray[2] = "processElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

