/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsAttribute;
import com.intellij.plugins.drools.lang.psi.DroolsExpression;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsRuleAttributes;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DroolsCommonUtil {
    public static boolean isMvelDialect(@NotNull PsiElement place) {
        DroolsRuleAttributes droolsRuleAttributes;
        DroolsAttribute attribute;
        if (place == null) {
            DroolsCommonUtil.$$$reportNull$$$0(0);
        }
        PsiFile file = place.getContainingFile();
        String dialect = "dialect";
        if (file instanceof DroolsFile && (attribute = ((DroolsFile)file).findAttributeByName("dialect")) != null) {
            return DroolsCommonUtil.isMvelExpression(attribute);
        }
        DroolsRuleStatement ruleStatement = (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)place, DroolsRuleStatement.class, (boolean)false);
        if (ruleStatement != null && (droolsRuleAttributes = ruleStatement.getRuleAttributes()) != null) {
            for (DroolsAttribute attribute2 : droolsRuleAttributes.getAttributeList()) {
                if (!"dialect".equals(attribute2.getAttributeName())) continue;
                return DroolsCommonUtil.isMvelExpression(attribute2);
            }
        }
        return false;
    }

    private static boolean isMvelExpression(DroolsAttribute attribute) {
        DroolsExpression expression = attribute.getExpression();
        return expression instanceof DroolsStringLiteral && "mvel".equals(DroolsCommonUtil.getInnerText((DroolsStringLiteral)expression));
    }

    @Nullable
    private static String getInnerText(@NotNull DroolsStringLiteral stringExpression) {
        if (stringExpression == null) {
            DroolsCommonUtil.$$$reportNull$$$0(1);
        }
        String text = stringExpression.getText();
        int textLength = text.length();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
            if (textLength == 1) {
                return null;
            }
            text = text.substring(1, textLength - 1);
        } else if (text.startsWith("&quot;") && text.endsWith("&quot;") && textLength > "&quot;".length()) {
            text = text.substring("&quot;".length(), textLength - "&quot;".length());
        } else {
            return null;
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/drools/lang/psi/util/DroolsCommonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMvelDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInnerText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

