/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.searchers;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.plugins.drools.DroolsFileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class DroolsMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public DroolsMethodUsageSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (queryParameters == null) {
            DroolsMethodUsageSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            DroolsMethodUsageSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = queryParameters.getMethod();
        PsiFile containingFile = method.getContainingFile();
        PsiClass psiClass = method.getContainingClass();
        if (containingFile == null || psiClass == null) {
            return;
        }
        if (!PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
            return;
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (scope instanceof GlobalSearchScope) {
            scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{DroolsFileType.DROOLS_FILE_TYPE});
        }
        String propName = PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method);
        queryParameters.getOptimizer().searchWord(propName, scope, (short)255, true, (PsiElement)method, (RequestResultProcessor)new MethodRequestResultProcessor(method));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/drools/lang/psi/searchers/DroolsMethodUsageSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MethodRequestResultProcessor
    extends RequestResultProcessor {
        private final PsiMethod myMethod;

        MethodRequestResultProcessor(PsiMethod method) {
            super(new Object[0]);
            this.myMethod = method;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                MethodRequestResultProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MethodRequestResultProcessor.$$$reportNull$$$0(1);
            }
            for (PsiReference ref : PsiReferenceService.getService().getReferences(element, new PsiReferenceService.Hints(element, Integer.valueOf(offsetInElement)))) {
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || MethodRequestResultProcessor.processReference(consumer, ref, this.myMethod)) continue;
                return false;
            }
            return true;
        }

        private static boolean processReference(Processor<? super PsiReference> consumer, PsiReference ref, PsiMethod method) {
            if (!method.isValid()) {
                return true;
            }
            if (ref instanceof ResolvingHint && !((ResolvingHint)ref).canResolveTo(PsiMethod.class)) {
                return true;
            }
            if (ref.isReferenceTo((PsiElement)method)) {
                return consumer.process((Object)ref);
            }
            PsiElement refElement = ref.resolve();
            if (refElement instanceof LightVariableBuilder && method.equals(refElement.getNavigationElement())) {
                return consumer.process((Object)ref);
            }
            if (refElement instanceof BeanPropertyElement && method.equals(((BeanPropertyElement)refElement).getMethod())) {
                return consumer.process((Object)ref);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/plugins/drools/lang/psi/searchers/DroolsMethodUsageSearcher$MethodRequestResultProcessor";
            objectArray[2] = "processTextOccurrence";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

