/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.searchers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.indexes.DroolsDeclareStatementScalarIndex;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsClassFinder
extends PsiElementFinder {
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DroolsClassFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DroolsClassFinder.$$$reportNull$$$0(1);
        }
        if (scope.getProject() == null) {
            return null;
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        Collection filesByExt = FileBasedIndex.getInstance().getContainingFiles(DroolsDeclareStatementScalarIndex.Companion.getId(), (Object)packageName, scope);
        if (filesByExt.isEmpty()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)scope.getProject());
        for (VirtualFile file : filesByExt) {
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof DroolsFile)) continue;
            for (DroolsDeclareStatement declareStatement : ((DroolsFile)psiFile).getDeclarations()) {
                DroolsTypeDeclaration typeDeclaration = declareStatement.getTypeDeclaration();
                if (typeDeclaration == null || !qualifiedName.equals(typeDeclaration.getQualifiedName())) continue;
                return new DroolsLightClass(typeDeclaration);
            }
        }
        return null;
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        PsiClass aClass;
        if (qualifiedName == null) {
            DroolsClassFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DroolsClassFinder.$$$reportNull$$$0(3);
        }
        if ((aClass = this.findClass(qualifiedName, scope)) == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = aClass;
        }
        if (psiClassArray == null) {
            DroolsClassFinder.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

