/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.Language;
import com.intellij.plugins.drools.DroolsLanguage;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsLightParameter;
import com.intellij.plugins.drools.lang.psi.DroolsParameter;
import com.intellij.plugins.drools.lang.psi.DroolsParameters;
import com.intellij.plugins.drools.lang.psi.DroolsType;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import org.jetbrains.annotations.NotNull;

@Presentation(typeName="Function", icon="AllIcons.Nodes.Method")
public class DroolsFunctionLightMethodBuilder
extends LightMethodBuilder {
    private final DroolsFunctionStatement myFunction;

    public DroolsFunctionLightMethodBuilder(@NotNull DroolsFunctionStatement function) {
        if (function == null) {
            DroolsFunctionLightMethodBuilder.$$$reportNull$$$0(0);
        }
        super(function.getManager(), (Language)DroolsLanguage.INSTANCE, function.getFunctionName());
        this.myFunction = function;
        this.init(this.myFunction);
    }

    private void init(DroolsFunctionStatement function) {
        DroolsParameters parameters;
        DroolsType type = function.getType();
        if (type != null) {
            this.setMethodReturnType(type.getText());
        }
        if ((parameters = function.getFunctionParameters()) != null) {
            for (DroolsParameter droolsParameter : parameters.getParameterList()) {
                this.addParameter(this.createParameter(droolsParameter));
            }
        }
    }

    @NotNull
    private PsiParameter createParameter(@NotNull DroolsParameter droolsParameter) {
        if (droolsParameter == null) {
            DroolsFunctionLightMethodBuilder.$$$reportNull$$$0(1);
        }
        String paramName = droolsParameter.getNameId().getText();
        PsiType psiType = DroolsResolveUtil.resolveType(droolsParameter.getType());
        DroolsLightParameter parameter = psiType == null ? new DroolsLightParameter(droolsParameter, paramName, (PsiType)PsiType.NULL, (PsiElement)this) : new DroolsLightParameter(droolsParameter, paramName, psiType, (PsiElement)this);
        parameter.setNavigationElement((PsiElement)droolsParameter);
        DroolsLightParameter droolsLightParameter = parameter;
        if (droolsLightParameter == null) {
            DroolsFunctionLightMethodBuilder.$$$reportNull$$$0(2);
        }
        return droolsLightParameter;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        DroolsFunctionStatement droolsFunctionStatement = this.myFunction;
        if (droolsFunctionStatement == null) {
            DroolsFunctionLightMethodBuilder.$$$reportNull$$$0(3);
        }
        return droolsFunctionStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DroolsFunctionLightMethodBuilder builder = (DroolsFunctionLightMethodBuilder)((Object)o);
        return this.myFunction.equals(builder.myFunction);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myFunction.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "droolsParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

