/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.DroolsFileType;
import com.intellij.plugins.drools.DroolsLanguage;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypeSets;
import com.intellij.plugins.drools.lang.psi.DroolsAttribute;
import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsGlobalStatement;
import com.intellij.plugins.drools.lang.psi.DroolsImport;
import com.intellij.plugins.drools.lang.psi.DroolsPackageStatement;
import com.intellij.plugins.drools.lang.psi.DroolsQueryStatement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportHolder;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsFile
extends PsiFileBase
implements PsiImportHolder {
    public DroolsFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            DroolsFile.$$$reportNull$$$0(0);
        }
        super(viewProvider, (Language)DroolsLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        DroolsFileType droolsFileType = DroolsFileType.DROOLS_FILE_TYPE;
        if (droolsFileType == null) {
            DroolsFile.$$$reportNull$$$0(1);
        }
        return droolsFileType;
    }

    public String toString() {
        return "Drools File";
    }

    public Icon getIcon(int flags) {
        return super.getIcon(flags);
    }

    public DroolsDeclareStatement @NotNull [] getDeclarations() {
        DroolsDeclareStatement[] droolsDeclareStatementArray = (DroolsDeclareStatement[])this.findChildrenByClass(DroolsDeclareStatement.class);
        if (droolsDeclareStatementArray == null) {
            DroolsFile.$$$reportNull$$$0(2);
        }
        return droolsDeclareStatementArray;
    }

    public DroolsRuleStatement @NotNull [] getRules() {
        DroolsRuleStatement[] droolsRuleStatementArray = (DroolsRuleStatement[])this.findChildrenByClass(DroolsRuleStatement.class);
        if (droolsRuleStatementArray == null) {
            DroolsFile.$$$reportNull$$$0(3);
        }
        return droolsRuleStatementArray;
    }

    public DroolsFunctionStatement @NotNull [] getFunctions() {
        DroolsFunctionStatement[] droolsFunctionStatementArray = (DroolsFunctionStatement[])this.findChildrenByClass(DroolsFunctionStatement.class);
        if (droolsFunctionStatementArray == null) {
            DroolsFile.$$$reportNull$$$0(4);
        }
        return droolsFunctionStatementArray;
    }

    public DroolsQueryStatement @NotNull [] getQueries() {
        DroolsQueryStatement[] droolsQueryStatementArray = (DroolsQueryStatement[])this.findChildrenByClass(DroolsQueryStatement.class);
        if (droolsQueryStatementArray == null) {
            DroolsFile.$$$reportNull$$$0(5);
        }
        return droolsQueryStatementArray;
    }

    public DroolsImport[] getImports() {
        return (DroolsImport[])this.findChildrenByClass(DroolsImport.class);
    }

    public DroolsGlobalStatement[] getGlobalVariables() {
        return (DroolsGlobalStatement[])this.findChildrenByClass(DroolsGlobalStatement.class);
    }

    @Nullable
    public DroolsPackageStatement getPackage() {
        return (DroolsPackageStatement)this.findChildByClass(DroolsPackageStatement.class);
    }

    public DroolsAttribute @NotNull [] getAttributes() {
        DroolsAttribute[] droolsAttributeArray = (DroolsAttribute[])this.findChildrenByClass(DroolsAttribute.class);
        if (droolsAttributeArray == null) {
            DroolsFile.$$$reportNull$$$0(6);
        }
        return droolsAttributeArray;
    }

    @Nullable
    public DroolsAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            DroolsFile.$$$reportNull$$$0(7);
        }
        for (DroolsAttribute attribute : this.getAttributes()) {
            if (!name.equals(attribute.getAttributeName())) continue;
            return attribute;
        }
        return null;
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        String qName;
        if (aClass == null) {
            DroolsFile.$$$reportNull$$$0(8);
        }
        if ((qName = aClass.getQualifiedName()) == null) {
            return false;
        }
        for (DroolsImport anImport : this.getImports()) {
            if (!qName.equals(anImport.getImportedClassName())) continue;
            return true;
        }
        try {
            DroolsImport importStatement = DroolsElementsFactory.createDroolsImport(qName, this.getProject());
            if (importStatement != null) {
                return this.addImport(importStatement) != null;
            }
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return false;
    }

    public DroolsImport addImport(@NotNull DroolsImport droolsImport) throws IncorrectOperationException {
        if (droolsImport == null) {
            DroolsFile.$$$reportNull$$$0(9);
        }
        PsiElement anchor = this.getAnchorToInsertImportAfter(droolsImport);
        FileASTNode node = this.getNode();
        PsiElement result = null;
        if (anchor == null) {
            PsiElement sibling;
            PsiElement psiElement = this.getFirstChild();
            if (psiElement != null && (sibling = (result = this.addBefore((PsiElement)droolsImport, psiElement)).getNextSibling()) != null) {
                node.addLeaf(DroolsTokenTypeSets.NEW_LINE, (CharSequence)StringUtil.repeat((String)"\n", (int)1), sibling.getNode());
            }
        } else {
            result = this.addAfter((PsiElement)droolsImport, anchor);
            node.addLeaf(DroolsTokenTypeSets.NEW_LINE, (CharSequence)StringUtil.repeat((String)"\n", (int)1), result.getNode());
        }
        return (DroolsImport)result;
    }

    @Nullable
    private PsiElement getAnchorToInsertImportAfter(@NotNull DroolsImport droolsImport) {
        DroolsImport[] importStatements;
        if (droolsImport == null) {
            DroolsFile.$$$reportNull$$$0(10);
        }
        if ((importStatements = this.getImports()).length == 0) {
            DroolsPackageStatement aPackage = this.getPackage();
            if (aPackage != null) {
                return aPackage;
            }
        } else {
            return importStatements[importStatements.length - 1];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/drools/lang/psi/DroolsFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "droolsImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/drools/lang/psi/DroolsFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorToInsertImportAfter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

