/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlDataKeys;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;

public class MavenUmlNodeHighlighter
implements UmlNodeHighlighter<MavenElement> {
    public List<DiagramNode<MavenElement>> onNodeSelected(List<DiagramNode<MavenElement>> selectedNodes, DiagramDataModel<MavenElement> dataModel) {
        ArrayList<DiagramNode<MavenElement>> result = new ArrayList<DiagramNode<MavenElement>>();
        for (DiagramNode<MavenElement> sel : selectedNodes) {
            result.addAll(MavenUmlNodeHighlighter.getConflictedWith(dataModel, sel));
        }
        return result;
    }

    @NotNull
    public static List<DiagramNode<MavenElement>> getConflictedWith(@NotNull DiagramDataModel<MavenElement> dataModel, @NotNull DiagramNode<MavenElement> sourceNode) {
        MavenElement element;
        MavenArtifactNode artifactNode;
        if (dataModel == null) {
            MavenUmlNodeHighlighter.$$$reportNull$$$0(0);
        }
        if (sourceNode == null) {
            MavenUmlNodeHighlighter.$$$reportNull$$$0(1);
        }
        ArrayList<DiagramNode<MavenElement>> result = new ArrayList<DiagramNode<MavenElement>>();
        DiagramNode<MavenElement> selected = (DiagramNode<MavenElement>)sourceNode.getUserData(MavenUmlDataKeys.CONFLICTED_WITH);
        if (selected == null && (selected = (DiagramNode)sourceNode.getUserData(MavenUmlDataKeys.DUPLICATED_WITH)) == null) {
            selected = sourceNode;
        }
        if ((artifactNode = (element = (MavenElement)selected.getIdentifyingElement()).getArtifact()) != null && (element.getState() == MavenArtifactState.CONFLICT || element.getState() == MavenArtifactState.DUPLICATE)) {
            MavenArtifact relatedArtifact = artifactNode.getRelatedArtifact();
            Collection nodes = dataModel.getNodes();
            result.add(selected);
            for (DiagramNode node : nodes) {
                MavenArtifactNode artifact;
                if (node == selected || (artifact = ((MavenElement)node.getIdentifyingElement()).getArtifact()) == null || artifact.getArtifact() != relatedArtifact) continue;
                result.add((DiagramNode<MavenElement>)node);
            }
        }
        ArrayList<DiagramNode<MavenElement>> arrayList = result;
        if (arrayList == null) {
            MavenUmlNodeHighlighter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void selectionChanged(DiagramBuilder builder) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/ext/uml/MavenUmlNodeHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/MavenUmlNodeHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictedWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConflictedWith";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

