/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import java.awt.Shape;
import org.jetbrains.idea.maven.ext.uml.MavenDependencyRelationship;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;

public class MavenUmlEdge
extends DiagramEdgeBase<MavenElement> {
    public static final DiagramRelationshipInfoAdapter INFO = new DiagramRelationshipInfoAdapter("MAVEN_DEPENDENCY"){

        public Shape getStartArrow() {
            return DELTA_SMALL;
        }
    };
    public static final DiagramRelationshipInfoAdapter DUPLICATE = new DiagramRelationshipInfoAdapter("MAVEN_DUPLICATE", DiagramLineType.DOTTED){

        public Shape getStartArrow() {
            return DELTA_SMALL;
        }

        public Shape getEndArrow() {
            return DELTA_SMALL;
        }
    };

    public MavenUmlEdge(MavenUmlNode from, MavenUmlNode to) {
        this(from, to, null);
    }

    public MavenUmlEdge(MavenUmlNode from, MavenUmlNode to, MavenArtifactState state) {
        super((DiagramNode)from, (DiagramNode)to, (DiagramRelationshipInfo)(state == MavenArtifactState.CONFLICT ? new ConflictDependencyRelationship(from, to) : (state == MavenArtifactState.DUPLICATE ? DUPLICATE : INFO)));
    }

    private static class ConflictDependencyRelationship
    extends MavenDependencyRelationship {
        public ConflictDependencyRelationship(MavenUmlNode from, MavenUmlNode to) {
            super(from, to);
        }

        @Override
        public Shape getStartArrow() {
            return DELTA_SMALL;
        }

        public Shape getEndArrow() {
            return DELTA_SMALL;
        }
    }
}

