/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.uml.MavenDependencyRelationship;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlEdge;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

public class MavenUmlColorManager
extends DiagramColorManagerBase {
    public static final Color PROJECT_HEADER_COLOR = new JBColor(new Color(158, 188, 195), new Color(13, 41, 62));
    public static final Color TEST_HEADER_COLOR = new JBColor(new Color(190, 238, 217), new Color(49, 59, 50));

    @NotNull
    public Color getEdgeColor(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        if (builder == null) {
            MavenUmlColorManager.$$$reportNull$$$0(0);
        }
        if (edge == null) {
            MavenUmlColorManager.$$$reportNull$$$0(1);
        }
        if (edge.getRelationship() instanceof MavenDependencyRelationship) {
            JBColor jBColor = JBColor.RED;
            if (jBColor == null) {
                MavenUmlColorManager.$$$reportNull$$$0(2);
            }
            return jBColor;
        }
        if (edge.getRelationship() == MavenUmlEdge.DUPLICATE) {
            JBColor jBColor = JBColor.RED;
            if (jBColor == null) {
                MavenUmlColorManager.$$$reportNull$$$0(3);
            }
            return jBColor;
        }
        MavenElement trg = (MavenElement)edge.getTarget().getIdentifyingElement();
        MavenArtifactState state = trg.getState();
        Color result = DiagramColors.GENERALIZATION_EDGE.getDefaultColor();
        if (state != null) {
            switch (state) {
                case ADDED: 
                case DUPLICATE: {
                    result = DiagramColors.GENERALIZATION_EDGE.getDefaultColor();
                    break;
                }
                case CYCLE: {
                    result = JBColor.RED;
                    break;
                }
                default: {
                    result = JBColor.foreground();
                }
            }
        }
        Color color = result;
        if (color == null) {
            MavenUmlColorManager.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    public Color getNodeHeaderBackground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element) {
        if (builder == null) {
            MavenUmlColorManager.$$$reportNull$$$0(5);
        }
        if (node == null) {
            MavenUmlColorManager.$$$reportNull$$$0(6);
        }
        if (element instanceof MavenElement) {
            if (((MavenElement)element).isProject()) {
                Color color = PROJECT_HEADER_COLOR;
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(7);
                }
                return color;
            }
            if (((MavenElement)element).isTestArtifact()) {
                Color color = TEST_HEADER_COLOR;
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(8);
                }
                return color;
            }
            if (((MavenElement)element).getScope() == MavenArtifactScope.TEST) {
                Color color = Objects.requireNonNull(builder.getColorScheme().getColor(DiagramColors.REALIZATION_EDGE));
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(9);
                }
                return color;
            }
        }
        Color color = Objects.requireNonNull(builder.getColorScheme().getColor(DiagramColors.NODE_HEADER));
        if (color == null) {
            MavenUmlColorManager.$$$reportNull$$$0(10);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/ext/uml/MavenUmlColorManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/MavenUmlColorManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeColor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNodeHeaderBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

