/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;

public class MavenDiagramCategoryManager
extends AbstractDiagramNodeContentManager {
    public static final DiagramCategory DUPLICATES = new DiagramCategory("Show Conflicts/Duplicates", AllIcons.Diff.ApplyNotConflicts, false, true).fitContent(true);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{DUPLICATES, CommonDiagramExtras.PATH_TO_ROOT, CommonDiagramExtras.SELECTION_MODE, CommonDiagramExtras.BORDERS};

    public DiagramCategory[] getContentCategories() {
        return CATEGORIES;
    }

    public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
        return false;
    }

    public void onCategoryEnabled(DiagramCategory category, boolean enabled, DiagramState presentation) {
        if (enabled) {
            if (category == DUPLICATES) {
                MavenDiagramCategoryManager.deselectCategories(presentation, CommonDiagramExtras.SELECTION_MODE, CommonDiagramExtras.PATH_TO_ROOT);
            } else if (category == CommonDiagramExtras.PATH_TO_ROOT) {
                MavenDiagramCategoryManager.deselectCategories(presentation, CommonDiagramExtras.SELECTION_MODE, DUPLICATES);
            } else if (category == CommonDiagramExtras.SELECTION_MODE) {
                MavenDiagramCategoryManager.deselectCategories(presentation, DUPLICATES, CommonDiagramExtras.PATH_TO_ROOT);
            }
        }
    }

    private static void deselectCategories(DiagramState presentation, DiagramCategory ... categories) {
        for (DiagramCategory category : categories) {
            presentation.setCategoryEnabled(category, false);
        }
    }
}

