/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.profiler.ConfigPropertySetProfilerException;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "plugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getPlugin", "()Lorg/jetbrains/idea/maven/model/MavenPlugin;", "checkProjectCanBeProfiled", "", "patchJavaParametersByPomValues", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "Exec", "Test", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Test;", "intellij.maven.ext"})
public abstract class PluginAnalyzer {
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final MavenPlugin plugin;

    @NotNull
    public abstract String getDominatingPluginParameter();

    public final void checkProjectCanBeProfiled() {
        Element element = this.plugin.getConfigurationElement();
        if ((element != null ? element.getChild(this.getDominatingPluginParameter()) : null) != null) {
            throw (Throwable)((Object)new ConfigPropertySetProfilerException(this.getDominatingPluginParameter()));
        }
    }

    public void patchJavaParametersByPomValues(@NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @NotNull
    public final MavenPlugin getPlugin() {
        return this.plugin;
    }

    private PluginAnalyzer(MavenProject mavenProject, MavenPlugin plugin) {
        this.mavenProject = mavenProject;
        this.plugin = plugin;
    }

    public /* synthetic */ PluginAnalyzer(MavenProject mavenProject, MavenPlugin plugin, DefaultConstructorMarker $constructor_marker) {
        this(mavenProject, plugin);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "execPlugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "patchJavaParametersByPomValues", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "Companion", "intellij.maven.ext"})
    public static final class Exec
    extends PluginAnalyzer {
        @NotNull
        private final String dominatingPluginParameter;
        private static final String EXEC_ARGS_PROPERTY_NAME = "exec.args";
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getDominatingPluginParameter() {
            return this.dominatingPluginParameter;
        }

        @Override
        public void patchJavaParametersByPomValues(@NotNull JavaParameters params) {
            Element arguments;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            if (params.getProgramParametersList().hasProperty(EXEC_ARGS_PROPERTY_NAME)) {
                return;
            }
            String staticProperty = this.getMavenProject().getProperties().getProperty(EXEC_ARGS_PROPERTY_NAME);
            if (staticProperty != null) {
                ParametersList parametersList = params.getProgramParametersList();
                Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"params.programParametersList");
                MavenParametersPatcherKt.doUpdatePropertyValues$default(parametersList, EXEC_ARGS_PROPERTY_NAME, CollectionsKt.listOf((Object)staticProperty), false, 4, null);
            }
            Element element = this.getPlugin().getConfigurationElement();
            Object object = arguments = element != null ? element.getChild("arguments") : null;
            if (arguments != null) {
                MavenParametersPatcherKt.access$getLOG$p().warn("Existing <arguments> configuration parameter from " + this.getPlugin().getArtifactId() + " will be ignored");
            }
        }

        public Exec(@NotNull MavenProject mavenProject, @NotNull MavenPlugin execPlugin) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)execPlugin, (String)"execPlugin");
            super(mavenProject, execPlugin, null);
            this.dominatingPluginParameter = "commandlineArgs";
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Exec$Companion;", "", "()V", "EXEC_ARGS_PROPERTY_NAME", "", "intellij.maven.ext"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer$Test;", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "testPlugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/model/MavenPlugin;)V", "dominatingPluginParameter", "", "getDominatingPluginParameter", "()Ljava/lang/String;", "intellij.maven.ext"})
    public static final class Test
    extends PluginAnalyzer {
        @NotNull
        private final String dominatingPluginParameter;

        @Override
        @NotNull
        public String getDominatingPluginParameter() {
            return this.dominatingPluginParameter;
        }

        public Test(@NotNull MavenProject mavenProject, @NotNull MavenPlugin testPlugin) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter((Object)testPlugin, (String)"testPlugin");
            super(mavenProject, testPlugin, null);
            this.dominatingPluginParameter = "debugForkedProcess";
        }
    }
}

