/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.NewProcessStartedExternallyCommunicator;
import com.intellij.profiler.ultimate.NewProcessStartedWithProfilerCommunicator;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.ext.MavenExtBundle;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcher;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.ext.profiler.ParametersUpdateStrategy;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0000\u001aN\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132 \u0010\u0014\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0015H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doUpdateJavaParameters", "", "configuration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "agentParametersProvider", "Lkotlin/Function0;", "", "", "doAttachToMavenProcess", "T", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "profilerProcessFactory", "Lkotlin/Function2;", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "", "Lcom/intellij/profiler/api/ProfilerProcess;", "intellij.maven.ext"})
public final class MavenRunConfigurationExtensionKt {
    private static final Logger LOG;

    public static final void doUpdateJavaParameters(@NotNull MavenRunConfiguration configuration, @NotNull JavaParameters params, @NotNull Function0<? extends List<String>> agentParametersProvider) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(agentParametersProvider, (String)"agentParametersProvider");
        MavenRunnerParameters mavenRunnerParameters = configuration.getRunnerParameters();
        boolean bl = false;
        boolean bl2 = false;
        MavenRunnerParameters $this$with = mavenRunnerParameters;
        boolean bl3 = false;
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath($this$with.getWorkingDirFile().toPath().resolve($this$with.getPomFileName()));
        if (virtualFile == null) {
            throw (Throwable)new ExecutionException(MavenExtBundle.message("maven.profiler.file.not.found", $this$with.getPomFileName()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"with(configuration.runne\u2026found\", pomFileName))\n  }");
        VirtualFile pomVirtualFile = virtualFile;
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)configuration.getProject()).findProject(pomVirtualFile);
        if (mavenProject == null) {
            throw (Throwable)new ExecutionException(MavenExtBundle.message("maven.profiler.file.not.found", pomVirtualFile.getName()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"MavenProjectsManager.get\u2026d\", pomVirtualFile.name))");
        MavenProject mavenProject2 = mavenProject;
        MavenParametersPatcher patcher = new MavenParametersPatcher(configuration, mavenProject2);
        patcher.doPatch(params, agentParametersProvider);
    }

    public static final <T> void doAttachToMavenProcess(@NotNull JavaProfilerConfigurationExtension<T> $this$doAttachToMavenProcess, @NotNull ProcessHandler handler, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull Function2<? super ProfilerProcessCommunicator<?>, ? super Long, ? extends ProfilerProcess<?>> profilerProcessFactory) {
        ProfilerProcessCommunicator profilerProcessCommunicator;
        Intrinsics.checkNotNullParameter($this$doAttachToMavenProcess, (String)"$this$doAttachToMavenProcess");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(profilerProcessFactory, (String)"profilerProcessFactory");
        if (handler instanceof ExternalSystemProcessHandler) {
            return;
        }
        if (handler instanceof OSProcessHandler) {
            if (runConfiguration.getUserData(MavenParametersPatcherKt.getForkingStrategyKey()) instanceof ParametersUpdateStrategy.SingleFork) {
                String string = runConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runConfiguration.name");
                profilerProcessCommunicator = (ProfilerProcessCommunicator)new NewProcessStartedExternallyCommunicator(string, (BaseOSProcessHandler)handler);
            } else {
                String string = runConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runConfiguration.name");
                profilerProcessCommunicator = (ProfilerProcessCommunicator)new NewProcessStartedWithProfilerCommunicator(string, (BaseOSProcessHandler)handler);
            }
        } else {
            LOG.error("unexpected process handler: '" + handler + '\'');
            throw (Throwable)new ExecutionException(UltimateProfilerBundleKt.profilerMessage((String)"profiler.exception.cant.start", (Object[])new Object[0]));
        }
        ProfilerProcessCommunicator communicator = profilerProcessCommunicator;
        $this$doAttachToMavenProcess.openToolWindowAndReportStart((ProfilerProcess)profilerProcessFactory.invoke((Object)communicator, (Object)System.currentTimeMillis()), runConfiguration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JavaProfilerConfigurationExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

