/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.ext.profiler.MavenParametersPatcherKt;
import org.jetbrains.idea.maven.ext.profiler.MavenProfileableGoal;
import org.jetbrains.idea.maven.ext.profiler.NoProfileableGoalsException;
import org.jetbrains.idea.maven.ext.profiler.ParametersUpdateStrategy;
import org.jetbrains.idea.maven.ext.profiler.ProjectHasSubmodulesAndNotExecJavaGoalException;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u001b0\u001aJ.\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\r2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001dH\u0002J(\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\r2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001dH\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J(\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\r2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/MavenParametersPatcher;", "", "configuration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "(Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;Lorg/jetbrains/idea/maven/project/MavenProject;)V", "getConfiguration", "()Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "possiblyIgnoredCommandLineBasedValues", "", "", "determineUpdateStrategy", "Lorg/jetbrains/idea/maven/ext/profiler/ParametersUpdateStrategy;", "parametersList", "Lcom/intellij/execution/configurations/ParametersList;", "determineUpdateStrategyForTests", "goal", "Lorg/jetbrains/idea/maven/ext/profiler/MavenProfileableGoal;", "doPatch", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "agentParametersProvider", "Lkotlin/Function0;", "", "getDynamicConfigurationProperties", "Lkotlin/Function1;", "domModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "getEffectivePropertyValue", "propertyName", "configAttributeName", "runtimeProperties", "getImmediateReferencedValue", "property", "logPossiblyIgnoredCommandLineBasedValues", "resolveRuntimeProperty", "Companion", "intellij.maven.ext"})
public final class MavenParametersPatcher {
    private final Set<String> possiblyIgnoredCommandLineBasedValues;
    @NotNull
    private final MavenRunConfiguration configuration;
    @NotNull
    private final MavenProject mavenProject;
    private static final Regex PROPERTY_REGEX;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPatch(@NotNull JavaParameters params, @NotNull Function0<? extends List<String>> agentParametersProvider) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(agentParametersProvider, (String)"agentParametersProvider");
        ParametersList parametersList = params.getProgramParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"params.programParametersList");
        ParametersUpdateStrategy parametersUpdateStrategy = this.determineUpdateStrategy(parametersList);
        if (parametersUpdateStrategy == null) {
            throw (Throwable)((Object)new NoProfileableGoalsException());
        }
        ParametersUpdateStrategy updateStrategy = parametersUpdateStrategy;
        this.configuration.putUserData(MavenParametersPatcherKt.getForkingStrategyKey(), (Object)updateStrategy);
        try {
            updateStrategy.doUpdate(params, (List)agentParametersProvider.invoke());
        }
        finally {
            this.logPossiblyIgnoredCommandLineBasedValues();
        }
    }

    private final ParametersUpdateStrategy determineUpdateStrategy(ParametersList parametersList) {
        Object object;
        MavenRunnerParameters mavenRunnerParameters = this.configuration.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"configuration.runnerParameters");
        List list = mavenRunnerParameters.getGoals();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configuration.runnerParameters.goals");
        MavenProfileableGoal mavenProfileableGoal = MavenProfileableGoal.Companion.fromList(list);
        if (mavenProfileableGoal == null) {
            return null;
        }
        MavenProfileableGoal goal = mavenProfileableGoal;
        if (!(goal instanceof MavenProfileableGoal.ExecJava)) {
            Set set = this.mavenProject.getModulePaths();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"mavenProject.modulePaths");
            object = set;
            boolean bl = false;
            if (!object.isEmpty()) {
                throw (Throwable)((Object)new ProjectHasSubmodulesAndNotExecJavaGoalException());
            }
        }
        return Intrinsics.areEqual((Object)(object = goal), (Object)MavenProfileableGoal.ExecJava.INSTANCE) ? (ParametersUpdateStrategy)ParametersUpdateStrategy.SameVm.INSTANCE : (Intrinsics.areEqual((Object)object, (Object)MavenProfileableGoal.ExecExec.INSTANCE) ? (ParametersUpdateStrategy)new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), false, goal.getPluginAnalyzer(this.mavenProject)) : this.determineUpdateStrategyForTests(goal, parametersList));
    }

    private final ParametersUpdateStrategy determineUpdateStrategyForTests(MavenProfileableGoal goal, ParametersList parametersList) {
        ParametersUpdateStrategy parametersUpdateStrategy;
        String string;
        String forkCount;
        String string2;
        String forkMode;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel((Project)this.configuration.getProject(), (VirtualFile)this.mavenProject.getFile());
        Intrinsics.checkNotNull((Object)mavenDomProjectModel);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026ect, mavenProject.file)!!");
        MavenDomProjectModel projectModel = mavenDomProjectModel;
        Function1<String, String> runtimeProperties = this.getDynamicConfigurationProperties(this.mavenProject, projectModel, parametersList);
        Function1<String, String> $fun$getEffectiveValue$1 = new Function1<String, String>(this, goal, runtimeProperties){
            final /* synthetic */ MavenParametersPatcher this$0;
            final /* synthetic */ MavenProfileableGoal $goal;
            final /* synthetic */ Function1 $runtimeProperties;

            @Nullable
            public final String invoke(@NotNull String propertyName) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                return MavenParametersPatcher.access$getEffectivePropertyValue(this.this$0, this.$goal, propertyName, propertyName, this.$runtimeProperties);
            }
            {
                this.this$0 = mavenParametersPatcher;
                this.$goal = mavenProfileableGoal;
                this.$runtimeProperties = function1;
                super(1);
            }
        };
        String string3 = $fun$getEffectiveValue$1.invoke("forkMode");
        if (string3 == null) {
            string3 = forkMode = "once";
        }
        if ((string2 = $fun$getEffectiveValue$1.invoke("forkCount")) == null) {
            string2 = forkCount = "1";
        }
        if ((string = $fun$getEffectiveValue$1.invoke("reuseForks")) == null) {
            string = "true";
        }
        String reuseForks = string;
        switch (forkMode) {
            case "never": {
                parametersUpdateStrategy = ParametersUpdateStrategy.SameVm.INSTANCE;
                break;
            }
            case "always": {
                parametersUpdateStrategy = ParametersUpdateStrategy.ManyForks.INSTANCE;
                break;
            }
            case "perthread": {
                int threadCount;
                Object object = parametersList.getPropertyValue("threadCount");
                int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (threadCount = 0);
                if (threadCount == 1) {
                    parametersUpdateStrategy = new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), true, goal.getPluginAnalyzer(this.mavenProject));
                    break;
                }
                parametersUpdateStrategy = ParametersUpdateStrategy.ManyForks.INSTANCE;
                break;
            }
            default: {
                parametersUpdateStrategy = Intrinsics.areEqual((Object)forkCount, (Object)"0") ? (ParametersUpdateStrategy)ParametersUpdateStrategy.SameVm.INSTANCE : (Intrinsics.areEqual((Object)forkCount, (Object)"1") && Intrinsics.areEqual((Object)reuseForks, (Object)"true") ? (ParametersUpdateStrategy)new ParametersUpdateStrategy.SingleFork(goal.getPropertyName(), true, goal.getPluginAnalyzer(this.mavenProject)) : (ParametersUpdateStrategy)ParametersUpdateStrategy.ManyForks.INSTANCE);
            }
        }
        return parametersUpdateStrategy;
    }

    private final String getEffectivePropertyValue(MavenProfileableGoal goal, String propertyName, String configAttributeName, Function1<? super String, String> runtimeProperties) {
        Element config = goal.getPlugin(this.mavenProject).getConfigurationElement();
        String propertyValuePlaceholder = "${" + propertyName + '}';
        Object object = config;
        if (object == null || (object = object.getChild(configAttributeName)) == null || (object = object.getTextTrim()) == null) {
            object = propertyValuePlaceholder;
        }
        Object text = object;
        String resolvedPropertyValue = this.resolveRuntimeProperty((String)text, runtimeProperties);
        if (Intrinsics.areEqual((Object)resolvedPropertyValue, (Object)propertyValuePlaceholder) ^ true) {
            return resolvedPropertyValue;
        }
        return null;
    }

    static /* synthetic */ String getEffectivePropertyValue$default(MavenParametersPatcher mavenParametersPatcher, MavenProfileableGoal mavenProfileableGoal, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        return mavenParametersPatcher.getEffectivePropertyValue(mavenProfileableGoal, string, string2, (Function1<? super String, String>)function1);
    }

    private final Function1<String, String> getDynamicConfigurationProperties(MavenProject mavenProject, MavenDomProjectModel domModel, ParametersList parametersList) {
        Properties staticProperties = MavenPropertyResolver.collectPropertiesFromDOM((MavenProject)mavenProject, (MavenDomProjectModel)domModel);
        return (Function1)new Function1<String, String>(this, parametersList, staticProperties){
            final /* synthetic */ MavenParametersPatcher this$0;
            final /* synthetic */ ParametersList $parametersList;
            final /* synthetic */ Properties $staticProperties;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String invoke(@NotNull String name) {
                String string;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String commandLineBasedValue = this.$parametersList.getPropertyValue(name);
                String staticPropertiesBasedValue = this.$staticProperties.getProperty(name);
                if (commandLineBasedValue != null && staticPropertiesBasedValue != null) {
                    Collection collection = MavenParametersPatcher.access$getPossiblyIgnoredCommandLineBasedValues$p(this.this$0);
                    boolean bl = false;
                    collection.add(name);
                }
                if ((string = commandLineBasedValue) == null) {
                    void var3_3;
                    string = var3_3;
                }
                return string;
            }
            {
                this.this$0 = mavenParametersPatcher;
                this.$parametersList = parametersList;
                this.$staticProperties = properties;
                super(1);
            }
        };
    }

    private final String resolveRuntimeProperty(String property, Function1<? super String, String> runtimeProperties) {
        String previousValue = null;
        String currentValue = this.getImmediateReferencedValue(property, runtimeProperties);
        while (Intrinsics.areEqual((Object)previousValue, (Object)currentValue) ^ true) {
            previousValue = currentValue;
            if (currentValue == null) continue;
            currentValue = this.getImmediateReferencedValue(currentValue, runtimeProperties);
        }
        return currentValue;
    }

    private final String getImmediateReferencedValue(String property, Function1<? super String, String> runtimeProperties) {
        Object object = Regex.find$default((Regex)PROPERTY_REGEX, (CharSequence)property, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            return property;
        }
        Object referencedPropertyName = object;
        return (String)runtimeProperties.invoke(referencedPropertyName);
    }

    private final void logPossiblyIgnoredCommandLineBasedValues() {
        if (this.possiblyIgnoredCommandLineBasedValues.isEmpty()) {
            return;
        }
        MavenParametersPatcherKt.access$getLOG$p().warn("The following properties defined in command line may be ignored " + "if they are referenced from plugin configuration: " + CollectionsKt.joinToString$default((Iterable)this.possiblyIgnoredCommandLineBasedValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    @NotNull
    public final MavenRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MavenParametersPatcher(@NotNull MavenRunConfiguration configuration, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.configuration = configuration;
        this.mavenProject = mavenProject;
        boolean bl = false;
        this.possiblyIgnoredCommandLineBasedValues = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        PROPERTY_REGEX = new Regex("\\$\\{(.+?)}");
    }

    public static final /* synthetic */ String access$getEffectivePropertyValue(MavenParametersPatcher $this, MavenProfileableGoal goal, String propertyName, String configAttributeName, Function1 runtimeProperties) {
        return $this.getEffectivePropertyValue(goal, propertyName, configAttributeName, (Function1<? super String, String>)runtimeProperties);
    }

    public static final /* synthetic */ Set access$getPossiblyIgnoredCommandLineBasedValues$p(MavenParametersPatcher $this) {
        return $this.possiblyIgnoredCommandLineBasedValues;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/MavenParametersPatcher$Companion;", "", "()V", "PROPERTY_REGEX", "Lkotlin/text/Regex;", "intellij.maven.ext"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

