/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.build.MavenArtifactBuilder;
import org.jetbrains.idea.maven.execution.build.MavenProjectTaskRunner;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactProperties;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactPropertiesProvider;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class JavaeeArtifactBuilder
implements MavenArtifactBuilder {
    public boolean isApplicable(ProjectModelBuildTask task) {
        ProjectModelBuildableElement buildableElement = task.getBuildableElement();
        if (!(buildableElement instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)buildableElement;
        ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance());
        if (properties == null || !(properties.getState() instanceof JavaeeArtifactProperties)) {
            return false;
        }
        return ((JavaeeArtifactProperties)((Object)properties.getState())).getModuleName() != null;
    }

    public void build(@NotNull Project project, @NotNull ProjectModelBuildTask task, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback) {
        String outputFilePath;
        boolean clean;
        if (project == null) {
            JavaeeArtifactBuilder.$$$reportNull$$$0(0);
        }
        if (task == null) {
            JavaeeArtifactBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JavaeeArtifactBuilder.$$$reportNull$$$0(2);
        }
        Artifact artifact = (Artifact)task.getBuildableElement();
        ArtifactProperties artifactProperties = artifact.getProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance());
        JavaeeArtifactProperties properties = (JavaeeArtifactProperties)((Object)artifactProperties.getState());
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(properties.getModuleName());
        if (module == null) {
            return;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenProject mavenProject = mavenProjectsManager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        boolean bl = clean = !task.isIncrementalBuild();
        if (clean && (outputFilePath = artifact.getOutputFilePath()) != null) {
            FileUtil.delete((File)new File(FileUtil.toSystemDependentName((String)outputFilePath)));
        }
        MavenRunner mavenRunner = MavenRunner.getInstance((Project)project);
        ParametersList parameters = new ParametersList();
        parameters.add("compile");
        parameters.add(JavaeeArtifactBuilder.getClCommand(properties));
        VirtualFile pomFile = mavenProject.getFile();
        MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
        MavenRunnerParameters command = new MavenRunnerParameters(true, pomFile.getParent().getPath(), pomFile.getName(), parameters.getList(), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        MavenProjectTaskRunner.runBatch((Project)project, (MavenRunner)mavenRunner, (String)"Maven Artifact Build", Collections.singletonList(command), (ProjectTaskContext)context, (ProjectTaskNotification)callback);
    }

    private static String getClCommand(JavaeeArtifactProperties properties) {
        switch (properties.getPackaging()) {
            case "war": {
                return properties.getExploded() ? "war:exploded" : "war:war";
            }
            case "ear": {
                return "ear:ear";
            }
            case "ejb": {
                return "ejb:ejb";
            }
        }
        return "package";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/ext/jee/JavaeeArtifactBuilder";
        objectArray[2] = "build";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

