/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javahttp.okhttp;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javahttp/okhttp/OkHttpHolder;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "isValid", "", "()Z", "myElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "name", "", "getName", "()Ljava/lang/String;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "intellij.javaHttpClients"})
public final class OkHttpHolder {
    private final SmartPsiElementPointer<PsiElement> myElementPointer;

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myElementPointer.getElement();
        if (psiElement == null) {
            throw (Throwable)new PsiInvalidElementAccessException(null, "Pointer hasn't survive");
        }
        return psiElement;
    }

    public final boolean isValid() {
        return this.myElementPointer.getElement() != null;
    }

    @Nullable
    public final String getName() {
        String string;
        PsiElement element = this.myElementPointer.getElement();
        if (element instanceof PsiClass) {
            string = ((PsiClass)element).getName();
            if (string == null) {
                PsiFile psiFile = ((PsiClass)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
                string = psiFile.getName();
            }
        } else {
            string = element instanceof PsiFile ? ((PsiFile)element).getName() : null;
        }
        return string;
    }

    public OkHttpHolder(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        this.myElementPointer = PointersKt.createSmartPointer$default((PsiElement)psiElement, null, (int)1, null);
    }
}

