/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.AndroidPreDexBuilder;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidFileBasedBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidDexCompilerConfiguration;
import org.jetbrains.jps.android.model.JpsAndroidExtensionService;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidDexBuildTarget
extends AndroidBuildTarget {
    public AndroidDexBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            AndroidDexBuildTarget.$$$reportNull$$$0(0);
        }
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        super.writeConfiguration(pd, out);
        JpsAndroidDexCompilerConfiguration c = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(this.getModule().getProject());
        if (c != null) {
            out.println(c.getVmOptions());
            out.println(c.getMaxHeapSize());
            out.println(c.isOptimize());
            out.println(c.isForceJumbo());
            out.println(c.isCoreLibrary());
            out.println(c.getProguardVmOptions());
        }
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File testModuleClassesDir;
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isLibrary()) {
            List<BuildRootDescriptor> list = Collections.emptyList();
            if (list == null) {
                AndroidDexBuildTarget.$$$reportNull$$$0(1);
            }
            return list;
        }
        final Map libPackage2ModuleName = CollectionFactory.createFilePathMap();
        Set appClassesDirs = CollectionFactory.createFilePathSet();
        final Set javaClassesDirs = CollectionFactory.createFilePathSet();
        final Set libClassesDirs = CollectionFactory.createFilePathSet();
        File moduleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
        if (moduleClassesDir != null) {
            appClassesDirs.add(moduleClassesDir.getPath());
        }
        AndroidJpsUtil.processClasspath(dataPaths, this.myModule, new AndroidDependencyProcessor(){

            @Override
            public void processAndroidLibraryPackage(@NotNull File file, @NotNull JpsModule depModule) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (depModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                libPackage2ModuleName.put(file.getPath(), depModule.getName());
            }

            @Override
            public void processAndroidLibraryOutputDirectory(@NotNull File dir) {
                if (dir == null) {
                    1.$$$reportNull$$$0(2);
                }
                libClassesDirs.add(dir.getPath());
            }

            @Override
            public void processJavaModuleOutputDirectory(@NotNull File dir) {
                if (dir == null) {
                    1.$$$reportNull$$$0(3);
                }
                javaClassesDirs.add(dir.getPath());
            }

            @Override
            public boolean isToProcess(@NotNull AndroidDependencyType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                return type == AndroidDependencyType.ANDROID_LIBRARY_PACKAGE || type == AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY || type == AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "depModule";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dir";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processAndroidLibraryPackage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processAndroidLibraryOutputDirectory";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processJavaModuleOutputDirectory";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isToProcess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, false);
        if (extension.isPackTestCode() && (testModuleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.TEST).getOutputDir()) != null) {
            appClassesDirs.add(testModuleClassesDir.getPath());
        }
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (Object classesDir : appClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.ANDROID_APP));
        }
        for (Object classesDir : libClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.ANDROID_LIB));
        }
        for (Object classesDir : javaClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.JAVA));
        }
        File preDexOutputDir = AndroidPreDexBuildTarget.getOutputDir(dataPaths);
        for (Map.Entry entry : libPackage2ModuleName.entrySet()) {
            String libPackage = (String)entry.getKey();
            String moduleName = (String)entry.getValue();
            File libPackageJarFile = new File(libPackage);
            assert (AndroidPreDexBuilder.canBePreDexed(libPackageJarFile));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, libPackageJarFile, true, false));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, new File(new File(preDexOutputDir, moduleName), libPackageJarFile.getName()), true, true));
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, false, true)) {
                String preDexedFileName;
                File file;
                File preDexedFile = file = new File(jarOrLibDir);
                if (AndroidPreDexBuilder.canBePreDexed(file) && (preDexedFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(file)) != null) {
                    preDexedFile = new File(preDexOutputDir, preDexedFileName);
                }
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, file, false, false));
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, preDexedFile, false, true));
            }
        }
        for (String path : AndroidJpsUtil.getProvidedLibraries(dataPaths, this.myModule)) {
            result.add((BuildRootDescriptor)new MyProvidedJarBuildRootDescriptor(this, new File(path)));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            AndroidDexBuildTarget.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            AndroidDexBuildTarget.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        return AndroidDexBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
    }

    @NotNull
    public static File getOutputFile(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        if (dataPaths == null) {
            AndroidDexBuildTarget.$$$reportNull$$$0(4);
        }
        if (module == null) {
            AndroidDexBuildTarget.$$$reportNull$$$0(5);
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir, "classes.dex");
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry registry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList(super.computeDependencies(registry, outputIndex));
        result.add(new AndroidAarDepsBuildTarget(this.myModule));
        result.add(new AndroidPreDexBuildTarget(this.myModule.getProject()));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        private final boolean myLibPackage;
        private final boolean myPreDexed;

        public MyJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file, boolean libPackage, boolean preDexed) {
            if (target == null) {
                MyJarBuildRootDescriptor.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyJarBuildRootDescriptor.$$$reportNull$$$0(1);
            }
            super(target, file);
            this.myLibPackage = libPackage;
            this.myPreDexed = preDexed;
        }

        public boolean isLibPackage() {
            return this.myLibPackage;
        }

        public boolean isPreDexed() {
            return this.myPreDexed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyJarBuildRootDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyProvidedJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        public MyProvidedJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file) {
            if (target == null) {
                MyProvidedJarBuildRootDescriptor.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyProvidedJarBuildRootDescriptor.$$$reportNull$$$0(1);
            }
            super(target, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyProvidedJarBuildRootDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyClassesDirBuildRootDescriptor
    extends AndroidClassesDirBuildRootDescriptor {
        private final ClassesDirType myClassesDirType;

        public MyClassesDirBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File root, @NotNull ClassesDirType classesDirType) {
            if (target == null) {
                MyClassesDirBuildRootDescriptor.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MyClassesDirBuildRootDescriptor.$$$reportNull$$$0(1);
            }
            if (classesDirType == null) {
                MyClassesDirBuildRootDescriptor.$$$reportNull$$$0(2);
            }
            super(target, root);
            this.myClassesDirType = classesDirType;
        }

        @NotNull
        public ClassesDirType getClassesDirType() {
            ClassesDirType classesDirType = this.myClassesDirType;
            if (classesDirType == null) {
                MyClassesDirBuildRootDescriptor.$$$reportNull$$$0(3);
            }
            return classesDirType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classesDirType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyClassesDirBuildRootDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassesDirType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ClassesDirType {
        ANDROID_APP,
        ANDROID_LIB,
        JAVA;

    }

    public static final class MyTargetType
    extends AndroidBuildTargetType<AndroidDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-dex", "DEX");
        }

        @Override
        public AndroidDexBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            return !extension.isLibrary() ? new AndroidDexBuildTarget(extension.getModule()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidDexBuildTarget$MyTargetType", "createBuildTarget"));
        }
    }
}

