/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidApkBuilder;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidApkBuilderConfigState;
import org.jetbrains.jps.android.AndroidApkBuilderConfigStateStorage;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPackagingStateStorage;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidDexBuildTarget;
import org.jetbrains.jps.android.builder.AndroidPackagingBuildTarget;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidPackagingBuildTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidPackagingBuilder");
    private static final String BUILDER_NAME = "Android Packager";

    public AndroidPackagingBuilder() {
        super(Collections.singletonList(AndroidPackagingBuildTarget.MyTargetType.INSTANCE));
    }

    @NotNull
    public String getPresentableName() {
        return BUILDER_NAME;
    }

    @Override
    protected void buildTarget(@NotNull AndroidPackagingBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidPackagingBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(3);
        }
        if (AndroidJpsUtil.isLightBuild(context)) {
            return;
        }
        boolean hasDirtyFiles = holder.hasDirtyFiles() || holder.hasRemovedFiles();
        try {
            if (!AndroidPackagingBuilder.doPackaging(target, context, target.getModule(), hasDirtyFiles, outputConsumer)) {
                throw new StopBuildException();
            }
        }
        catch (ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            AndroidJpsUtil.handleException(context, e, BUILDER_NAME, LOG);
        }
    }

    private static boolean doPackaging(@NotNull BuildTarget<?> target, @NotNull CompileContext context, @NotNull JpsModule module, boolean hasDirtyFiles, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        if (target == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(5);
        }
        if (module == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(6);
        }
        if (outputConsumer == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(7);
        }
        boolean release = AndroidJpsUtil.isReleaseBuild(context);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        boolean success = true;
        AndroidApkBuilderConfigStateStorage.Provider builderStateStoragetProvider = new AndroidApkBuilderConfigStateStorage.Provider("apk_builder_config");
        AndroidApkBuilderConfigStateStorage apkBuilderConfigStateStorage = (AndroidApkBuilderConfigStateStorage)dataManager.getStorage(target, (StorageProvider)builderStateStoragetProvider);
        AndroidPackagingStateStorage packagingStateStorage = (AndroidPackagingStateStorage)dataManager.getStorage(target, (StorageProvider)AndroidPackagingStateStorage.Provider.INSTANCE);
        try {
            if (!AndroidPackagingBuilder.doPackagingForModule(context, module, apkBuilderConfigStateStorage, packagingStateStorage, release, hasDirtyFiles, outputConsumer)) {
                success = false;
            }
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
            success = false;
        }
        return success;
    }

    private static boolean doPackagingForModule(@NotNull CompileContext context, @NotNull JpsModule module, @NotNull AndroidApkBuilderConfigStateStorage apkBuilderConfigStateStorage, @NotNull AndroidPackagingStateStorage packagingStateStorage, boolean release, boolean hasDirtyFiles, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        JpsAndroidModuleExtension extension;
        if (context == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(8);
        }
        if (module == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(9);
        }
        if (apkBuilderConfigStateStorage == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(10);
        }
        if (packagingStateStorage == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(11);
        }
        if (outputConsumer == null) {
            AndroidPackagingBuilder.$$$reportNull$$$0(12);
        }
        if ((extension = AndroidJpsUtil.getExtension(module)) == null || extension.isLibrary()) {
            return true;
        }
        Object[] resourceRoots = AndroidJpsUtil.toPaths(AndroidJpsUtil.getJavaOutputRootsForModuleAndDependencies(module));
        Arrays.sort(resourceRoots);
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)module, (boolean)false);
        if (moduleOutputDir == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.output.dir.not.specified", module.getName())));
            return false;
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        HashSet<String> externalJarsSet = new HashSet<String>();
        for (String jarPath : AndroidJpsUtil.getExternalLibraries(context, module, platform)) {
            if (!new File(jarPath).exists()) continue;
            externalJarsSet.add(jarPath);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        File resPackage = AndroidResourcePackagingBuildTarget.getOutputFile(dataPaths, module);
        File classesDexFile = AndroidDexBuildTarget.getOutputFile(dataPaths, module);
        String sdkPath = platform.getSdk().getHomePath();
        String outputPath = AndroidJpsUtil.getApkPath(extension, moduleOutputDir);
        if (outputPath == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.cannot.compute.output.apk", module.getName())));
            return false;
        }
        String customKeyStorePath = FileUtil.toSystemDependentName((String)extension.getCustomDebugKeyStorePath());
        String[] nativeLibDirs = AndroidPackagingBuildTarget.collectNativeLibsFolders(extension, true);
        String resPackagePath = resPackage.getPath();
        String classesDexFilePath = classesDexFile.getPath();
        Object[] externalJars = ArrayUtil.toStringArray(externalJarsSet);
        Arrays.sort(externalJars);
        List<AndroidNativeLibData> additionalNativeLibs = extension.getAdditionalNativeLibs();
        AndroidApkBuilderConfigState currentApkBuilderConfigState = new AndroidApkBuilderConfigState(outputPath, customKeyStorePath, additionalNativeLibs);
        if (!hasDirtyFiles) {
            AndroidApkBuilderConfigState savedApkBuilderConfigState = (AndroidApkBuilderConfigState)apkBuilderConfigStateStorage.getState(module.getName());
            AndroidPackagingStateStorage.MyState packagingState = packagingStateStorage.read();
            if (currentApkBuilderConfigState.equalsTo(savedApkBuilderConfigState) && packagingState != null && packagingState.isRelease() == release) {
                return true;
            }
        }
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.packaging", AndroidJpsUtil.getApkName(module))));
        Map messages = AndroidApkBuilder.execute((String)resPackagePath, (String)classesDexFilePath, (String[])resourceRoots, (String[])externalJars, (String[])nativeLibDirs, additionalNativeLibs, (String)outputPath, (boolean)release, (String)sdkPath, (IAndroidTarget)platform.getTarget(), (String)customKeyStorePath, (Condition)new MyExcludedSourcesFilter(context.getProjectDescriptor().getProject()));
        if (((List)messages.get(AndroidCompilerMessageKind.ERROR)).isEmpty()) {
            final ArrayList<String> srcFiles = new ArrayList<String>();
            srcFiles.add(resPackagePath);
            srcFiles.add(classesDexFilePath);
            for (Object resourceRoot : resourceRoots) {
                FileUtil.processFilesRecursively((File)new File((String)resourceRoot), (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isFile() && AndroidApkBuilder.checkFileForPackaging((File)file)) {
                            srcFiles.add(file.getPath());
                        }
                        return true;
                    }
                });
            }
            Collections.addAll(srcFiles, externalJars);
            for (String nativeLibDir : nativeLibDirs) {
                FileUtil.processFilesRecursively((File)new File(nativeLibDir), (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isFile()) {
                            srcFiles.add(file.getPath());
                        }
                        return true;
                    }
                });
            }
            outputConsumer.registerOutputFile(new File(outputPath), srcFiles);
        }
        AndroidJpsUtil.addMessages(context, messages, BUILDER_NAME, module.getName());
        boolean success = ((List)messages.get(AndroidCompilerMessageKind.ERROR)).isEmpty();
        apkBuilderConfigStateStorage.update(module.getName(), success ? currentApkBuilderConfigState : null);
        packagingStateStorage.saveState(new AndroidPackagingStateStorage.MyState(release));
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkBuilderConfigStateStorage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagingStateStorage";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/android/AndroidPackagingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTarget";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doPackaging";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doPackagingForModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyExcludedSourcesFilter
    implements Condition<File> {
        private final JpsCompilerExcludes myExcludes;

        public MyExcludedSourcesFilter(@NotNull JpsProject project) {
            if (project == null) {
                MyExcludedSourcesFilter.$$$reportNull$$$0(0);
            }
            this.myExcludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getCompilerExcludes();
        }

        public boolean value(File file) {
            return !this.myExcludes.isExcluded(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/android/AndroidPackagingBuilder$MyExcludedSourcesFilter", "<init>"));
        }
    }
}

