/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidManifestMergingTarget
extends ModuleBasedTarget<MyRootDescriptor> {
    public AndroidManifestMergingTarget(ModuleBasedBuildTargetType<? extends ModuleBasedTarget<MyRootDescriptor>> targetType, @NotNull JpsModule module) {
        if (module == null) {
            AndroidManifestMergingTarget.$$$reportNull$$$0(0);
        }
        super(targetType, module);
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    public boolean isTests() {
        return false;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        BuildTargetType mavenResourcesProductionType = TargetTypeRegistry.getInstance().getTargetType("maven-resources-production");
        if (mavenResourcesProductionType != null) {
            return new ArrayList(targetRegistry.getAllTargets(mavenResourcesProductionType));
        }
        return Collections.emptyList();
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
    }

    @NotNull
    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        File manifestFile = AndroidJpsUtil.getManifestFileForCompilationPath(extension);
        if (manifestFile != null) {
            result.add(new MyRootDescriptor((BuildTarget)this, manifestFile, false));
        }
        for (JpsAndroidModuleExtension libExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            File libManifest = AndroidJpsUtil.getManifestFileForCompilationPath(libExtension);
            if (libManifest == null || !libManifest.exists()) continue;
            result.add(new MyRootDescriptor((BuildTarget)this, libManifest, true));
        }
        ArrayList<MyRootDescriptor> arrayList = result;
        if (arrayList == null) {
            AndroidManifestMergingTarget.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return "Android Manifest Merging";
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputDirectory(context));
        if (list == null) {
            AndroidManifestMergingTarget.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public File getOutputDirectory(@NotNull CompileContext context) {
        if (context == null) {
            AndroidManifestMergingTarget.$$$reportNull$$$0(3);
        }
        File file = AndroidJpsUtil.getPreprocessedManifestDirectory(this.myModule, context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            AndroidManifestMergingTarget.$$$reportNull$$$0(4);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidManifestMergingTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidManifestMergingTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final boolean myLibManifestRoot;

        private MyRootDescriptor(@NotNull BuildTarget target, @NotNull File root, boolean libManifestRoot) {
            if (target == null) {
                MyRootDescriptor.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MyRootDescriptor.$$$reportNull$$$0(1);
            }
            super(target, root);
            this.myLibManifestRoot = libManifestRoot;
        }

        public boolean isLibManifestRoot() {
            return this.myLibManifestRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyRootDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MyTargetType
    extends ModuleBasedBuildTargetType<AndroidManifestMergingTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-manifest-merging");
        }

        @NotNull
        public List<AndroidManifestMergingTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                List<AndroidManifestMergingTarget> list = Collections.emptyList();
                if (list == null) {
                    MyTargetType.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList<AndroidManifestMergingTarget> targets = new ArrayList<AndroidManifestMergingTarget>();
            for (JpsModule module : model.getProject().getModules()) {
                JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
                if (extension == null || extension.isLibrary() || !extension.isManifestMergingEnabled()) continue;
                targets.add(new AndroidManifestMergingTarget(this, module));
            }
            ArrayList<AndroidManifestMergingTarget> arrayList = targets;
            if (arrayList == null) {
                MyTargetType.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        public BuildTargetLoader<AndroidManifestMergingTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                MyTargetType.$$$reportNull$$$0(3);
            }
            final HashMap<String, AndroidManifestMergingTarget> targetMap = new HashMap<String, AndroidManifestMergingTarget>();
            for (AndroidManifestMergingTarget target : this.computeAllTargets(model)) {
                targetMap.put(target.getId(), target);
            }
            return new BuildTargetLoader<AndroidManifestMergingTarget>(){

                @Nullable
                public AndroidManifestMergingTarget createTarget(@NotNull String targetId) {
                    if (targetId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (AndroidManifestMergingTarget)((Object)targetMap.get(targetId));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType$1", "createTarget"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAllTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAllTargets";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

