/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidLibraryPackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidLibraryPackagingTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Library Packaging";

    protected AndroidLibraryPackagingBuilder() {
        super(Collections.singletonList(AndroidLibraryPackagingTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidLibraryPackagingTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidLibraryPackagingTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(3);
        }
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidLibraryPackagingBuilder.doBuild(context, target.getModule(), outputConsumer)) {
            throw new StopBuildException();
        }
    }

    private static boolean doBuild(CompileContext context, JpsModule module, BuildOutputConsumer outputConsumer) throws IOException {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null || !extension.isLibrary()) {
            return true;
        }
        File outputDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        File classesDir = ProjectPaths.getModuleOutputDir((JpsModule)module, (boolean)false);
        if (classesDir == null || !classesDir.isDirectory()) {
            return true;
        }
        HashSet<String> subdirs = new HashSet<String>();
        AndroidJpsUtil.addSubdirectories(classesDir, subdirs);
        if (!subdirs.isEmpty()) {
            List srcFiles;
            context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.library.packaging", module.getName())));
            File outputJarFile = new File(outputDir, "classes.jar");
            try {
                srcFiles = AndroidBuildCommonUtils.packClassFilesIntoJar((String[])ArrayUtilRt.EMPTY_STRING_ARRAY, (String[])ArrayUtilRt.toStringArray(subdirs), (File)outputJarFile);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
                return false;
            }
            AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
            if (testingManager != null && outputJarFile.isFile()) {
                testingManager.getCommandExecutor().checkJarContent("library_package_jar", outputJarFile.getPath());
            }
            if (!srcFiles.isEmpty()) {
                outputConsumer.registerOutputFile(outputJarFile, (Collection)srcFiles);
            }
        }
        return true;
    }

    @NotNull
    public String getPresentableName() {
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/android/AndroidLibraryPackagingBuilder";
        objectArray[2] = "buildTarget";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

