/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidJpsProjectUtil {
    @NonNls
    public static final String ANDROID_STORAGE_DIR = "android";
    @NonNls
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    @NonNls
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    @NonNls
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";

    static JpsAndroidModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(0);
        }
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull JpsProject project) {
        if (project == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(1);
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(2);
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(@NotNull Collection<JpsModule> modules) {
        if (modules == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(3);
        }
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsProjectUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    @NotNull
    public static File getGeneratedResourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(4);
        }
        return AndroidJpsProjectUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
    }

    @NotNull
    static File getGeneratedResourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(5);
        }
        if (dataPaths == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(6);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
    }

    @NotNull
    public static File getStorageFile(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(7);
        }
        if (storageName == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(8);
        }
        return new File(AndroidJpsProjectUtil.getStorageDir(dataStorageRoot, storageName), storageName);
    }

    @NotNull
    public static File getStorageDir(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(9);
        }
        if (storageName == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(10);
        }
        return new File(new File(dataStorageRoot, ANDROID_STORAGE_DIR), storageName);
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(11);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
    }

    @NotNull
    public static File getCopiedSourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(12);
        }
        if (dataPaths == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(13);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        return AndroidJpsProjectUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidProjectWithoutGradleFacet";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getGeneratedResourcesStorage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getStorageFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getStorageDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getGeneratedSourcesStorage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getCopiedSourcesStorage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

