/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ValueResourcesFileParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidBuildDataCache {
    private static AndroidBuildDataCache ourInstance;
    private final Map<JpsModule, MyAndroidDeps> myModule2AndroidDeps = new HashMap<JpsModule, MyAndroidDeps>();
    private final Map<String, List<ResourceEntry>> myParsedValueResourceFiles = new HashMap<String, List<ResourceEntry>>();

    @NotNull
    public static AndroidBuildDataCache getInstance() {
        if (ourInstance == null) {
            ourInstance = new AndroidBuildDataCache();
        }
        AndroidBuildDataCache androidBuildDataCache = ourInstance;
        if (androidBuildDataCache == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(0);
        }
        return androidBuildDataCache;
    }

    public static void clean() {
        ourInstance = null;
    }

    public List<ResourceEntry> getParsedValueResourceFile(@NotNull File file) throws IOException {
        String path;
        List<ResourceEntry> entries;
        if (file == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(1);
        }
        if ((entries = this.myParsedValueResourceFiles.get(path = FileUtil.toCanonicalPath((String)file.getPath()))) == null) {
            entries = AndroidBuildDataCache.parseValueResourceFile(file);
            this.myParsedValueResourceFiles.put(path, entries);
        }
        return entries;
    }

    @NotNull
    private static List<ResourceEntry> parseValueResourceFile(@NotNull File valueResXmlFile) throws IOException {
        if (valueResXmlFile == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(2);
        }
        final ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(valueResXmlFile));){
            FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new ValueResourcesFileParser(){

                protected void stop() {
                    throw new FormsParsing.ParserStoppedException();
                }

                protected void process(@NotNull ResourceEntry resourceEntry) {
                    if (resourceEntry == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.add(resourceEntry);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceEntry", "org/jetbrains/jps/android/AndroidBuildDataCache$1", "process"));
                }
            });
        }
        ArrayList<ResourceEntry> arrayList = result;
        if (arrayList == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<JpsAndroidModuleExtension> getAllAndroidDependencies(@NotNull JpsModule module, boolean librariesOnly) {
        MyAndroidDeps deps;
        if (module == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(4);
        }
        if ((deps = this.myModule2AndroidDeps.get(module)) == null) {
            deps = AndroidBuildDataCache.computeAndroidDependencies(module);
            this.myModule2AndroidDeps.put(module, deps);
        }
        List<JpsAndroidModuleExtension> list = librariesOnly ? deps.myLibAndroidDeps : deps.myAndroidDeps;
        if (list == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static MyAndroidDeps computeAndroidDependencies(@NotNull JpsModule module) {
        if (module == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(6);
        }
        MyAndroidDeps result = new MyAndroidDeps();
        boolean recursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(module);
        AndroidBuildDataCache.collectAndroidDependencies(module, result, new HashSet<String>(), true, recursively);
        Collections.reverse(result.myAndroidDeps);
        Collections.reverse(result.myLibAndroidDeps);
        MyAndroidDeps myAndroidDeps = result;
        if (myAndroidDeps == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(7);
        }
        return myAndroidDeps;
    }

    private static void collectAndroidDependencies(@NotNull JpsModule module, @NotNull MyAndroidDeps result, @NotNull Set<String> visitedSet, boolean fillLibs, boolean recursively) {
        if (module == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(8);
        }
        if (result == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(9);
        }
        if (visitedSet == null) {
            AndroidBuildDataCache.$$$reportNull$$$0(10);
        }
        ArrayList dependencies = new ArrayList(JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false));
        for (int i = dependencies.size() - 1; i >= 0; --i) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            JpsDependencyElement item = (JpsDependencyElement)dependencies.get(i);
            if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !visitedSet.add(depModule.getName())) continue;
            if (recursively) {
                boolean newRecursively = AndroidJpsUtil.shouldProcessDependenciesRecursively(depModule);
                AndroidBuildDataCache.collectAndroidDependencies(depModule, result, visitedSet, fillLibs && depExtension.isLibrary(), newRecursively);
            }
            result.myAndroidDeps.add(depExtension);
            if (!fillLibs || !depExtension.isLibrary()) continue;
            result.myLibAndroidDeps.add(depExtension);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidBuildDataCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueResXmlFile";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidBuildDataCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValueResourceFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAndroidDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParsedValueResourceFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseValueResourceFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAndroidDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAndroidDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAndroidDeps {
        final List<JpsAndroidModuleExtension> myAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();
        final List<JpsAndroidModuleExtension> myLibAndroidDeps = new ArrayList<JpsAndroidModuleExtension>();

        private MyAndroidDeps() {
        }
    }

    public static class ComputationException
    extends Exception {
        public ComputationException(@NotNull String message) {
            if (message == null) {
                ComputationException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jps/android/AndroidBuildDataCache$ComputationException", "<init>"));
        }
    }

    private static final class ErrorComputedValue<T>
    extends MyComputedValue<T> {
        @NotNull
        private final String myMessage;

        private ErrorComputedValue(@NotNull String message) {
            if (message == null) {
                ErrorComputedValue.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
        }

        @Override
        @NotNull
        T getValue() throws ComputationException {
            throw new ComputationException(this.myMessage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jps/android/AndroidBuildDataCache$ErrorComputedValue", "<init>"));
        }
    }

    private static final class SuccessComputedValue<T>
    extends MyComputedValue<T> {
        @NotNull
        private final T myValue;

        private SuccessComputedValue(@NotNull T value) {
            if (value == null) {
                SuccessComputedValue.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @NotNull
        T getValue() throws ComputationException {
            T t = this.myValue;
            if (t == null) {
                SuccessComputedValue.$$$reportNull$$$0(1);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/android/AndroidBuildDataCache$SuccessComputedValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/android/AndroidBuildDataCache$SuccessComputedValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MyComputedValue<T> {
        private MyComputedValue() {
        }

        @NotNull
        abstract T getValue() throws ComputationException;
    }
}

