/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.profiler.ui.treetable.DefaultTreeTableCellRenderer;
import com.intellij.profiler.ui.treetable.MouseAwareTreeCellRendererPanel;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.settings.JVMProfilerConfigurable;
import com.intellij.profiler.ultimate.welcome.AttachToProcessUtils;
import com.intellij.profiler.ultimate.welcome.CpuAndMemoryTab;
import com.intellij.profiler.ultimate.welcome.WelcomeScreenPanel;
import com.intellij.profiler.ultimate.welcome.WelcomeScreenPanel$WhenMappings;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.components.panels.FlowLayoutWrapper;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.actions.AttachToProcessActionBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0006\u001e\u001f !\"#B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/project/Project;)V", "actions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "alarm", "Lcom/intellij/util/Alarm;", "processTree", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessesTree;", "snapshotList", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "cancelProcessListUpdate", "", "createApplicationProcessPanel", "Ljavax/swing/JComponent;", "createDumpHistoryPanel", "dispose", "initComponents", "initListeners", "runProcessListUpdate", "runSnapshotListUpdate", "scheduleProcessListUpdate", "getAppName", "", "Lcom/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachToProcessItem;", "Companion", "MyColumns", "MyHeader", "MyHistoryItem", "MyProcessModel", "MyProcessesTree", "intellij.profiler.ultimate"})
public final class WelcomeScreenPanel
extends BorderLayoutPanel
implements Disposable {
    private final MyProcessesTree processTree;
    private final JBPanelWithEmptyText snapshotList;
    private final DefaultActionGroup actions;
    private final Alarm alarm;
    private final ToolWindow toolWindow;
    private final Project project;
    public static final int UPDATE_TIME = 500;
    public static final Companion Companion = new Companion(null);

    private final void scheduleProcessListUpdate() {
        this.alarm.addRequest(new Runnable(this){
            final /* synthetic */ WelcomeScreenPanel this$0;

            public void run() {
                boolean bl = WelcomeScreenPanel.access$getAlarm$p(this.this$0).getActiveRequestCount() == 1;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Try add request into non empty queue";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                WelcomeScreenPanel.access$getAlarm$p(this.this$0).addRequest((Runnable)this, 500);
                WelcomeScreenPanel.access$runProcessListUpdate(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        }, 0);
    }

    private final void cancelProcessListUpdate() {
        this.alarm.cancelAllRequests();
    }

    private final void runProcessListUpdate() {
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        Content content = contentManager.getSelectedContent();
        JComponent selectedComponent = content != null ? content.getComponent() : null;
        boolean bl = selectedComponent == this;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WelcomeScreenPanel$runProcessListUpdate$22 = false;
            String $i$a$-assert-WelcomeScreenPanel$runProcessListUpdate$22 = "Try run update with " + selectedComponent;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-WelcomeScreenPanel$runProcessListUpdate$22));
        }
        List<AttachToProcessActionBase.AttachToProcessItem> list = AttachToProcessUtils.getAttaches(this.project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"AttachToProcessUtils.getAttaches(project)");
        Iterable $this$distinctBy$iv = list;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            AttachToProcessActionBase.AttachToProcessItem it = (AttachToProcessActionBase.AttachToProcessItem)e$iv;
            boolean bl3 = false;
            AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = it;
            Intrinsics.checkNotNullExpressionValue((Object)attachToProcessItem, (String)"it");
            ProcessInfo processInfo = attachToProcessItem.getProcessInfo();
            Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
            Integer key$iv = processInfo.getPid();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$sortedBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        boolean bl4 = false;
        List attaches = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AttachToProcessActionBase.AttachToProcessItem it = (AttachToProcessActionBase.AttachToProcessItem)a;
                boolean bl2 = false;
                AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = it;
                Intrinsics.checkNotNullExpressionValue((Object)attachToProcessItem, (String)"it");
                ProcessInfo processInfo = attachToProcessItem.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                it = (AttachToProcessActionBase.AttachToProcessItem)b;
                Comparable comparable = Integer.valueOf(processInfo.getPid());
                bl2 = false;
                AttachToProcessActionBase.AttachToProcessItem attachToProcessItem2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)attachToProcessItem2, (String)"it");
                ProcessInfo processInfo2 = attachToProcessItem2.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo2, (String)"it.processInfo");
                Integer n = processInfo2.getPid();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(this, attaches){
            final /* synthetic */ WelcomeScreenPanel this$0;
            final /* synthetic */ List $attaches;

            public final void run() {
                TreeTableModel treeTableModel = WelcomeScreenPanel.access$getProcessTree$p(this.this$0).getModel();
                if (treeTableModel == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.welcome.WelcomeScreenPanel.MyProcessModel");
                }
                MyProcessModel myProcessModel = (MyProcessModel)treeTableModel;
                boolean bl = false;
                boolean bl2 = false;
                MyProcessModel model = myProcessModel;
                boolean bl3 = false;
                model.setLocals(this.$attaches);
                WelcomeScreenPanel.access$getProcessTree$p(this.this$0).getTree().expandPath(new TreePath(model.getRoot()));
            }
            {
                this.this$0 = welcomeScreenPanel;
                this.$attaches = list;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void runSnapshotListUpdate() {
        void $this$mapTo$iv$iv;
        this.snapshotList.removeAll();
        Iterable $this$map$iv = ProfileHistoryConfiguration.Companion.getInstance(this.project).history();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ProfilerDumpDescriptor profilerDumpDescriptor = (ProfilerDumpDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MyHistoryItem myHistoryItem = new MyHistoryItem((ProfilerDumpDescriptor)p1);
            collection.add(myHistoryItem);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MyHistoryItem item = (MyHistoryItem)((Object)element$iv);
            boolean bl = false;
            this.snapshotList.add((Component)((Object)item));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initComponents() {
        void it;
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter();
        boolean bl = false;
        boolean bl2 = false;
        OnePixelSplitter onePixelSplitter2 = onePixelSplitter;
        WelcomeScreenPanel welcomeScreenPanel = this;
        boolean bl3 = false;
        it.setFirstComponent(this.createApplicationProcessPanel());
        it.setSecondComponent(this.createDumpHistoryPanel());
        Unit unit = Unit.INSTANCE;
        welcomeScreenPanel.addToCenter((Component)onePixelSplitter);
        this.setBorder((Border)JBUI.Borders.empty());
        this.runSnapshotListUpdate();
    }

    /*
     * WARNING - void declaration
     */
    private final void initListeners() {
        void it;
        DumbAwareAction dumbAwareAction = new DumbAwareAction(this, UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.attach", new Object[0])){
            final /* synthetic */ WelcomeScreenPanel this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                block8: {
                    TreePath path;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Tree tree2 = WelcomeScreenPanel.access$getProcessTree$p(this.this$0).getTree();
                    Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"processTree.tree");
                    TreePath treePath = path = tree2.getSelectionPath();
                    Object object = treePath != null ? treePath.getLastPathComponent() : null;
                    if (!(object instanceof AttachToProcessActionBase.AttachToProcessItem)) {
                        object = null;
                    }
                    AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = (AttachToProcessActionBase.AttachToProcessItem)object;
                    if (attachToProcessItem == null) break block8;
                    AttachToProcessActionBase.AttachToProcessItem attachToProcessItem2 = attachToProcessItem;
                    boolean bl = false;
                    boolean bl2 = false;
                    AttachToProcessActionBase.AttachToProcessItem it = attachToProcessItem2;
                    boolean bl3 = false;
                    if (it.getSubItems().isEmpty()) {
                        AttachToProcessUtils.attach(it, WelcomeScreenPanel.access$getProject$p(this.this$0));
                    } else {
                        RelativePoint mouseLocation;
                        RelativePoint relativePoint;
                        RelativePoint relativePoint2;
                        Serializable serializable;
                        InputEvent inputEvent = e.getInputEvent();
                        if (!(inputEvent instanceof MouseEvent)) {
                            inputEvent = null;
                        }
                        MouseEvent mouseEvent = (MouseEvent)inputEvent;
                        Object object2 = mouseEvent != null ? mouseEvent.getSource() : null;
                        if (!(object2 instanceof Component)) {
                            object2 = null;
                        }
                        if ((serializable = (Component)object2) != null && (serializable = serializable.getLocation()) != null) {
                            Serializable serializable2 = serializable;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Serializable p1 = serializable2;
                            boolean bl6 = false;
                            relativePoint2 = new RelativePoint((Point)p1);
                        } else {
                            relativePoint2 = null;
                        }
                        if ((relativePoint = (mouseLocation = relativePoint2)) == null) {
                            RelativePoint relativePoint3 = TreeUtil.getPointForPath((JTree)((JTree)WelcomeScreenPanel.access$getProcessTree$p(this.this$0).getTree()), (TreePath)path);
                            relativePoint = relativePoint3;
                            Intrinsics.checkNotNullExpressionValue((Object)relativePoint3, (String)"TreeUtil.getPointForPath(processTree.tree, path)");
                        }
                        RelativePoint point = relativePoint;
                        JBPopupFactory.getInstance().createListPopup((ListPopupStep)AttachToProcessUtils.attach(it.getSubItems(), WelcomeScreenPanel.access$getProject$p(this.this$0))).show(point);
                    }
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        DumbAwareAction dumbAwareAction2 = dumbAwareAction;
        DefaultActionGroup defaultActionGroup = this.actions;
        boolean bl3 = false;
        it.registerCustomShortcutSet(10, 0, (JComponent)((Object)this.processTree));
        Unit unit = Unit.INSTANCE;
        defaultActionGroup.add((AnAction)dumbAwareAction);
        this.actions.add((AnAction)new DumbAwareAction(this, UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.cpuandmemory", new Object[0])){
            final /* synthetic */ WelcomeScreenPanel this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    TreePath path;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Tree tree2 = WelcomeScreenPanel.access$getProcessTree$p(this.this$0).getTree();
                    Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"processTree.tree");
                    TreePath treePath = path = tree2.getSelectionPath();
                    Object object = treePath != null ? treePath.getLastPathComponent() : null;
                    if (!(object instanceof AttachToProcessActionBase.AttachToProcessItem)) {
                        object = null;
                    }
                    AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = (AttachToProcessActionBase.AttachToProcessItem)object;
                    if (attachToProcessItem == null) break block1;
                    AttachToProcessActionBase.AttachToProcessItem attachToProcessItem2 = attachToProcessItem;
                    boolean bl = false;
                    boolean bl2 = false;
                    AttachToProcessActionBase.AttachToProcessItem it = attachToProcessItem2;
                    boolean bl3 = false;
                    ProcessInfo processInfo = it.getProcessInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                    int pid = processInfo.getPid();
                    CpuAndMemoryTab tab = new CpuAndMemoryTab(pid);
                    tab.setFocusable(true);
                    String tabName = WelcomeScreenPanel.access$getAppName(this.this$0, it);
                    Project project = e.getProject();
                    Intrinsics.checkNotNull((Object)project);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
                    Content content = ProfilerToolWindowManager.Companion.getInstance(project).addTab((JComponent)((Object)tab), "" + pid + ' ' + tabName);
                    Disposer.register((Disposable)((Disposable)content), (Disposable)tab);
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
        this.processTree.getTree().addMouseListener((MouseListener)new PopupHandler(this){
            final /* synthetic */ WelcomeScreenPanel this$0;

            public void invokePopup(@Nullable Component comp, int x, int y) {
                ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)WelcomeScreenPanel.access$getActions$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026nPlaces.UNKNOWN, actions)");
                actionPopupMenu.getComponent().show(comp, x, y);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NlsSafe
    private final String getAppName(AttachToProcessActionBase.AttachToProcessItem $this$getAppName) {
        String string = $this$getAppName.getText(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(project)");
        String applicationNameWithPid = string;
        ProcessInfo processInfo = $this$getAppName.getProcessInfo();
        Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"processInfo");
        int pid = processInfo.getPid();
        String string2 = applicationNameWithPid;
        double d = pid;
        boolean bl = false;
        int n = (int)Math.log10(d) + 2;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String applicationName = string4;
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)applicationName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createApplicationProcessPanel() {
        void scrollPane;
        Object header;
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        boolean bl2 = false;
        BorderLayoutPanel it = borderLayoutPanel;
        boolean bl3 = false;
        Object object = new MyHeader(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.header", new Object[0]));
        boolean bl4 = false;
        boolean bl5 = false;
        MyHeader myHeader = object;
        BorderLayoutPanel borderLayoutPanel2 = it;
        boolean bl6 = false;
        header.setBorder(JBUI.Borders.empty((int)10));
        Unit unit = Unit.INSTANCE;
        borderLayoutPanel2.addToTop((Component)object);
        object = this.processTree;
        bl4 = false;
        bl5 = false;
        header = object;
        borderLayoutPanel2 = it;
        boolean bl7 = false;
        scrollPane.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        unit = Unit.INSTANCE;
        borderLayoutPanel2.addToCenter((Component)object);
        return (JComponent)borderLayoutPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createDumpHistoryPanel() {
        void scrollPane;
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        boolean bl2 = false;
        BorderLayoutPanel it = borderLayoutPanel;
        boolean bl3 = false;
        it.addToTop((Component)((Object)new MyHeader(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots", new Object[0]))));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.snapshotList));
        boolean bl4 = false;
        boolean bl5 = false;
        JScrollPane jScrollPane2 = jScrollPane;
        BorderLayoutPanel borderLayoutPanel2 = it;
        boolean bl6 = false;
        void v0 = scrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"scrollPane");
        v0.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)10, (int)0));
        Unit unit = Unit.INSTANCE;
        borderLayoutPanel2.addToCenter((Component)jScrollPane);
        JButton browse = new JButton(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.open", new Object[0]));
        browse.addActionListener(new ActionListener(this){
            final /* synthetic */ WelcomeScreenPanel this$0;
            {
                this.this$0 = welcomeScreenPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    VirtualFile virtualFile = ImportProfilerResultAction.Companion.chooseProfilerSnapshot(WelcomeScreenPanel.access$getProject$p(this.this$0));
                    if (virtualFile == null) break block0;
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile file = virtualFile2;
                    boolean bl3 = false;
                    ImportProfilerResultAction.Companion.importProfilerDump$default((ImportProfilerResultAction.Companion)ImportProfilerResultAction.Companion, (Project)WelcomeScreenPanel.access$getProject$p(this.this$0), (File)new File(file.getPath()), null, null, null, (int)28, null);
                }
            }
        });
        it.addToBottom((Component)new FlowLayoutWrapper((JComponent)browse));
        it.setBorder(JBUI.Borders.empty((int)10));
        return (JComponent)borderLayoutPanel;
    }

    public void dispose() {
        this.alarm.cancelAllRequests();
    }

    /*
     * WARNING - void declaration
     */
    public WelcomeScreenPanel(@NotNull ToolWindow toolWindow, @NotNull Project project) {
        void box;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.toolWindow = toolWindow;
        this.project = project;
        this.processTree = new MyProcessesTree(this.project);
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText();
        boolean bl = false;
        boolean bl2 = false;
        JBPanelWithEmptyText jBPanelWithEmptyText2 = jBPanelWithEmptyText;
        WelcomeScreenPanel welcomeScreenPanel = this;
        boolean bl3 = false;
        box.withEmptyText(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.hint", new Object[0]));
        box.setLayout((LayoutManager)new VerticalLayout(10));
        Unit unit = Unit.INSTANCE;
        welcomeScreenPanel.snapshotList = jBPanelWithEmptyText;
        this.actions = new DefaultActionGroup();
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Disposer.register((Disposable)this.toolWindow.getDisposable(), (Disposable)this);
        this.initComponents();
        this.initListeners();
        this.toolWindow.getComponent().addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ContentManager contentManager = toolWindow.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
                Content content = contentManager.getSelectedContent();
                if ((content != null ? content.getComponent() : null) == this) {
                    this.runSnapshotListUpdate();
                    this.scheduleProcessListUpdate();
                }
            }

            public void ancestorRemoved(@NotNull AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.cancelProcessListUpdate();
            }
        });
        this.toolWindow.addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"event.content");
                if (content.getComponent() == this) {
                    ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                    if (contentOperation != null) {
                        switch (WelcomeScreenPanel$WhenMappings.$EnumSwitchMapping$0[contentOperation.ordinal()]) {
                            case 1: {
                                this.runSnapshotListUpdate();
                                this.scheduleProcessListUpdate();
                                break;
                            }
                            case 2: {
                                this.cancelProcessListUpdate();
                                break;
                            }
                        }
                    }
                }
            }
        });
    }

    public static final /* synthetic */ Alarm access$getAlarm$p(WelcomeScreenPanel $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$runProcessListUpdate(WelcomeScreenPanel $this) {
        $this.runProcessListUpdate();
    }

    public static final /* synthetic */ MyProcessesTree access$getProcessTree$p(WelcomeScreenPanel $this) {
        return $this.processTree;
    }

    public static final /* synthetic */ Project access$getProject$p(WelcomeScreenPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$getAppName(WelcomeScreenPanel $this, AttachToProcessActionBase.AttachToProcessItem $this$access_u24getAppName) {
        return $this.getAppName($this$access_u24getAppName);
    }

    public static final /* synthetic */ DefaultActionGroup access$getActions$p(WelcomeScreenPanel $this) {
        return $this.actions;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyHeader;", "Lcom/intellij/ui/components/JBLabel;", "text", "", "(Ljava/lang/String;)V", "setUI", "", "ui", "Ljavax/swing/plaf/LabelUI;", "intellij.profiler.ultimate"})
    private static final class MyHeader
    extends JBLabel {
        public void setUI(@Nullable LabelUI ui) {
            super.setUI(ui);
            if (this.getFont() != null) {
                Font font = this.getFont();
                Font font2 = this.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
                this.setFont(new FontUIResource(font.deriveFont(font2.getSize2D() + (float)JBUIScale.scale((int)3)).deriveFont(1)));
            }
        }

        public MyHeader(@NlsContexts.Label @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyHistoryItem;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "descriptor", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "(Lcom/intellij/profiler/api/ProfilerDumpDescriptor;)V", "contextActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getDescriptor", "()Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "link", "Lcom/intellij/ui/components/ActionLink;", "path", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.ultimate"})
    private static final class MyHistoryItem
    extends BorderLayoutPanel {
        private final ActionLink link;
        private final JLabel path;
        private final DefaultActionGroup contextActions;
        @NotNull
        private final ProfilerDumpDescriptor descriptor;

        @NotNull
        public final ProfilerDumpDescriptor getDescriptor() {
            return this.descriptor;
        }

        public MyHistoryItem(@NotNull ProfilerDumpDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.descriptor = descriptor;
            this.link = new ActionLink(this.descriptor.getName(), null, 2, null);
            JLabel jLabel = ComponentPanelBuilder.createCommentComponent((String)this.descriptor.getFile().getParent(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"ComponentPanelBuilder.cr\u2026iptor.file.parent, false)");
            this.path = jLabel;
            this.contextActions = new DefaultActionGroup();
            this.contextActions.add((AnAction)DumbAwareAction.create((String)RevealFileAction.getActionName(), (Consumer)((Consumer)new Consumer<AnActionEvent>(){

                public final void consume(AnActionEvent it) {
                    RevealFileAction.openFile((File)this.getDescriptor().getFile());
                }
            })));
            this.link.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    ProfilerDumpDescriptor.open$default((ProfilerDumpDescriptor)this.getDescriptor(), null, (int)1, null);
                }
            });
            this.link.setToolTipText(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.open", new Object[0]));
            this.link.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(@Nullable Component comp, int x, int y) {
                    ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)contextActions);
                    Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026.UNKNOWN, contextActions)");
                    actionPopupMenu.getComponent().show(comp, x, y);
                }
            });
            this.addToCenter((Component)this.link);
            this.addToBottom(this.path);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0003J\u0014\u0010\n\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0003\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessesTree;", "Lcom/intellij/ui/components/JBTreeTable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "removePid", "", "textWithPid", "from", "", "getExecuteCommand", "Lcom/intellij/execution/process/ProcessInfo;", "programName", "intellij.profiler.ultimate"})
    private static final class MyProcessesTree
    extends JBTreeTable {
        @NlsSafe
        private final String getExecuteCommand(ProcessInfo $this$getExecuteCommand, String programName) {
            if (Intrinsics.areEqual((Object)$this$getExecuteCommand.getExecutableDisplayName(), (Object)"java")) {
                String string = $this$getExecuteCommand.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"args");
                int sillyIndex = StringsKt.indexOf$default((CharSequence)string, (String)(' ' + programName + ' '), (int)0, (boolean)false, (int)6, null);
                if (sillyIndex >= 0) {
                    String string2 = $this$getExecuteCommand.getArgs();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"args");
                    String string3 = string2;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(sillyIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    return string5;
                }
            }
            return (String)$this$getExecuteCommand.getExecutableCannonicalPath().orElseGet((Supplier)new Supplier<String>($this$getExecuteCommand){
                final /* synthetic */ ProcessInfo $this_getExecuteCommand;

                public final String get() {
                    return this.$this_getExecuteCommand.getExecutableDisplayName();
                }
                {
                    this.$this_getExecuteCommand = processInfo;
                }
            }) + ' ' + $this$getExecuteCommand.getArgs();
        }

        @NlsSafe
        private final String removePid(@NlsSafe String textWithPid, int from) {
            String string;
            if (from == 0) {
                string = textWithPid;
            } else {
                String string2 = textWithPid;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(from);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            }
            return string;
        }

        public MyProcessesTree(final @NotNull Project project) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                super((TreeTableModel)new MyProcessModel());
                JBTable jBTable = this.getTable();
                Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"table");
                StatusText statusText = jBTable.getEmptyText();
                Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"table.emptyText");
                statusText.setText("");
                Tree tree2 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"tree");
                tree2.getEmptyText().clear();
                Tree tree3 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"tree");
                tree3.getEmptyText().appendText(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.notfound", new Object[0]));
                Tree tree4 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree4, (String)"tree");
                tree4.getEmptyText().appendSecondaryText(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.configure", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                    @Override
                    public final void actionPerformed(ActionEvent it) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(project, JVMProfilerConfigurable.class);
                    }
                });
                Tree tree5 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree5, (String)"tree");
                ExpandableItemsHandler expandableItemsHandler = tree5.getExpandableItemsHandler();
                Intrinsics.checkNotNullExpressionValue((Object)expandableItemsHandler, (String)"tree.expandableItemsHandler");
                expandableItemsHandler.setEnabled(false);
                Tree tree6 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree6, (String)"tree");
                Tree tree7 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree7, (String)"tree");
                tree6.setRowHeight(tree7.getRowHeight() + 4);
                Tree tree8 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree8, (String)"tree");
                tree8.setCellRenderer((TreeCellRenderer)new MouseAwareTreeCellRendererPanel((JTree)this.getTree()){
                    private final ActionLink actionLink;
                    private final ActionLink[] highlighters;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                        this.setBackground(UIUtil.getTableBackground((boolean)selected, (boolean)RenderingUtil.isFocused((JComponent)tree2)));
                        this.setForeground(UIUtil.getTableForeground((boolean)selected, (boolean)RenderingUtil.isFocused((JComponent)tree2)));
                        boolean isSimpleForeground = selected || !this.isHighlightEnabled(row, value);
                        this.actionLink.setForeground(isSimpleForeground ? this.getForeground() : JBUI.CurrentTheme.Link.linkColor());
                        ButtonModel buttonModel = this.actionLink.getModel();
                        Intrinsics.checkNotNullExpressionValue((Object)buttonModel, (String)"actionLink.model");
                        buttonModel.setRollover(this.getHighlightedRow() == row);
                        Object object = value;
                        if (object instanceof AttachToProcessActionBase.AttachToProcessItem) {
                            String string;
                            int n;
                            boolean bl;
                            ProcessInfo processInfo = ((AttachToProcessActionBase.AttachToProcessItem)value).getProcessInfo();
                            Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"value.processInfo");
                            if (processInfo.getPid() >= 0) {
                                ProcessInfo processInfo2 = ((AttachToProcessActionBase.AttachToProcessItem)value).getProcessInfo();
                                Intrinsics.checkNotNullExpressionValue((Object)processInfo2, (String)"value.processInfo");
                                double d = processInfo2.getPid();
                                bl = false;
                                n = (int)Math.log10(d) + 2;
                            } else {
                                n = 0;
                            }
                            int trimPidFrom = n;
                            String string2 = ((AttachToProcessActionBase.AttachToProcessItem)value).getText(project);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.getText(project)");
                            this.actionLink.setText(this.removePid(string2, trimPidFrom));
                            2 v5 = this;
                            if (this.getHighlightedRow() == row && this.getHighlightedComponent() == this.actionLink) {
                                HtmlChunk.Element $this$with;
                                void builder;
                                HtmlBuilder htmlBuilder = new HtmlBuilder();
                                boolean bl2 = false;
                                bl = false;
                                HtmlBuilder htmlBuilder2 = htmlBuilder;
                                2 var23_16 = v5;
                                boolean bl3 = false;
                                HtmlChunk.Element element = HtmlChunk.div((String)"margin-bottom: 4px");
                                boolean bl4 = false;
                                boolean bl5 = false;
                                HtmlChunk.Element element2 = element;
                                void var20_22 = builder;
                                boolean bl6 = false;
                                HtmlChunk.Element element3 = $this$with.addText(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.attach", new Object[0]));
                                var20_22.append((HtmlChunk)element3);
                                element = HtmlChunk.div((String)"white-space: nowrap");
                                bl4 = false;
                                bl5 = false;
                                $this$with = element;
                                var20_22 = builder;
                                boolean bl7 = false;
                                ProcessInfo processInfo3 = ((AttachToProcessActionBase.AttachToProcessItem)value).getProcessInfo();
                                Intrinsics.checkNotNullExpressionValue((Object)processInfo3, (String)"value.processInfo");
                                String string3 = this.actionLink.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"actionLink.text");
                                element3 = $this$with.addText(StringUtil.shortenTextWithEllipsis((String)this.getExecuteCommand(processInfo3, string3), (int)106, (int)51));
                                HtmlBuilder htmlBuilder3 = var20_22.append((HtmlChunk)element3);
                                v5 = var23_16;
                                string = htmlBuilder3.wrapWithHtmlBody().toString();
                            } else {
                                string = null;
                            }
                            v5.setToolTipText(string);
                        } else {
                            this.actionLink.setText(String.valueOf(value));
                        }
                        return (Component)((Object)this);
                    }

                    public boolean isHighlightEnabled(int row, @Nullable Object value) {
                        return value instanceof AttachToProcessActionBase.AttachToProcessItem;
                    }

                    @NotNull
                    protected ActionLink[] getHighlightables() {
                        return this.highlighters;
                    }

                    protected void mouseClicked(@NotNull MouseEvent event) {
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (event.getButton() != 1) {
                                return;
                            }
                            Object object = this.getHighlightedValue();
                            if (!(object instanceof AttachToProcessActionBase.AttachToProcessItem)) {
                                object = null;
                            }
                            AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = (AttachToProcessActionBase.AttachToProcessItem)object;
                            if (attachToProcessItem == null) break block4;
                            AttachToProcessActionBase.AttachToProcessItem attachToProcessItem2 = attachToProcessItem;
                            boolean bl = false;
                            boolean bl2 = false;
                            AttachToProcessActionBase.AttachToProcessItem it = attachToProcessItem2;
                            boolean bl3 = false;
                            if (it.getSubItems().isEmpty()) {
                                AttachToProcessUtils.attach(it, project);
                            } else {
                                JBPopupFactory.getInstance().createListPopup((ListPopupStep)AttachToProcessUtils.attach(it.getSubItems(), project)).show(new RelativePoint(event));
                            }
                        }
                    }
                    {
                        void it;
                        super($super_call_param$2);
                        this.actionLink = new ActionLink();
                        this.highlighters = new ActionLink[]{this.actionLink};
                        this.setLayout(new BorderLayout());
                        JPanel jPanel = new JPanel();
                        boolean bl = false;
                        boolean bl2 = false;
                        JPanel jPanel2 = jPanel;
                        2 var9_8 = this;
                        boolean bl3 = false;
                        it.setOpaque(false);
                        it.setLayout((LayoutManager)new HorizontalLayout(5));
                        it.add((Component)this.actionLink);
                        Unit unit = Unit.INSTANCE;
                        var9_8.add(jPanel);
                    }
                });
                DefaultTreeTableCellRenderer.install((JBTreeTable)this);
                TableCellRenderer tableCellRenderer = this.getTable().getDefaultRenderer(MyColumns.PROCESS_ID.getColumnClass());
                if (!(tableCellRenderer instanceof DefaultTreeTableCellRenderer)) {
                    tableCellRenderer = null;
                }
                DefaultTreeTableCellRenderer defaultTreeTableCellRenderer = (DefaultTreeTableCellRenderer)tableCellRenderer;
                if (defaultTreeTableCellRenderer == null) break block1;
                defaultTreeTableCellRenderer.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004*\u0001\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J$\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010%\u001a\u00020\u001d*\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0082\u0004J!\u0010%\u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0082\u0004R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel;", "Lcom/intellij/ui/tree/BaseTreeModel;", "", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "()V", "localProcessRoot", "com/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel$localProcessRoot$1", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel$localProcessRoot$1;", "value", "", "Lcom/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachToProcessItem;", "locals", "getLocals", "()Ljava/util/List;", "setLocals", "(Ljava/util/List;)V", "getChildren", "parent", "getColumnClass", "Ljava/lang/Class;", "column", "", "getColumnCount", "getColumnName", "", "getRoot", "getValueAt", "node", "isCellEditable", "", "setTree", "", "tree", "Ljavax/swing/JTree;", "setValueAt", "", "aValue", "isSameAs", "other", "intellij.profiler.ultimate"})
    private static final class MyProcessModel
    extends BaseTreeModel<Object>
    implements TreeTableModel {
        @NotNull
        private List<? extends AttachToProcessActionBase.AttachToProcessItem> locals = CollectionsKt.emptyList();
        private final localProcessRoot.1 localProcessRoot = new Object(){

            @NotNull
            public String toString() {
                return UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.locals", new Object[0]);
            }
        };

        @NotNull
        public final List<AttachToProcessActionBase.AttachToProcessItem> getLocals() {
            return this.locals;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLocals(@NotNull List<? extends AttachToProcessActionBase.AttachToProcessItem> value) {
            void $this$filterTo$iv$iv;
            int n;
            void $this$filterTo$iv$iv2;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv;
            Pair pair;
            Object object;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            if (this.isSameAs(value, this.locals)) {
                return;
            }
            Iterable $this$map$iv = this.locals;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = (AttachToProcessActionBase.AttachToProcessItem)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                ProcessInfo processInfo = it.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                pair = TuplesKt.to((Object)processInfo.getPid(), (Object)it);
                object.add(pair);
            }
            Map oldValue = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = value;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it;
                AttachToProcessActionBase.AttachToProcessItem bl = (AttachToProcessActionBase.AttachToProcessItem)item$iv$iv3;
                object = destination$iv$iv2;
                boolean bl2 = false;
                ProcessInfo processInfo = it.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                pair = TuplesKt.to((Object)processInfo.getPid(), (Object)it);
                object.add(pair);
            }
            Map newValue = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            Set set = CollectionsKt.intersect((Iterable)oldValue.keySet(), (Iterable)newValue.keySet());
            if (set == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.Int>");
            }
            Set common = TypeIntrinsics.asMutableSet((Object)set);
            common.removeIf((Predicate)new Predicate<Integer>(this, oldValue, newValue){
                final /* synthetic */ MyProcessModel this$0;
                final /* synthetic */ Map $oldValue;
                final /* synthetic */ Map $newValue;

                public final boolean test(@NotNull Integer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    V v = this.$oldValue.get(it);
                    Intrinsics.checkNotNull(v);
                    AttachToProcessActionBase.AttachToProcessItem attachToProcessItem = (AttachToProcessActionBase.AttachToProcessItem)v;
                    V v2 = this.$newValue.get(it);
                    Intrinsics.checkNotNull(v2);
                    return !MyProcessModel.access$isSameAs(this.this$0, attachToProcessItem, (AttachToProcessActionBase.AttachToProcessItem)v2);
                }
                {
                    this.this$0 = myProcessModel;
                    this.$oldValue = map;
                    this.$newValue = map2;
                }
            });
            Set old = CollectionsKt.subtract((Iterable)oldValue.keySet(), (Iterable)common);
            Set set2 = CollectionsKt.subtract((Iterable)newValue.keySet(), (Iterable)common);
            Iterable $this$filter$iv = this.locals;
            boolean $i$f$filter = false;
            item$iv$iv3 = $this$filter$iv;
            Collection destination$iv$iv222 = new ArrayList();
            int $i$f$filterTo = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                AttachToProcessActionBase.AttachToProcessItem it = (AttachToProcessActionBase.AttachToProcessItem)element$iv$iv;
                boolean bl = false;
                ProcessInfo processInfo = it.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                if (!old.contains(processInfo.getPid())) continue;
                destination$iv$iv222.add(element$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv222;
            int $i$f$toTypedArray = 0;
            Object thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new AttachToProcessActionBase.AttachToProcessItem[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] removed = objectArray;
            $i$f$toTypedArray = removed.length;
            thisCollection$iv = new int[$i$f$toTypedArray];
            int destination$iv$iv222 = 0;
            while (destination$iv$iv222 < $i$f$toTypedArray) {
                void it;
                $i$f$filterTo = destination$iv$iv222;
                int n2 = destination$iv$iv222++;
                object = thisCollection$iv;
                boolean bl = false;
                n = this.locals.indexOf(removed[it]);
                object[n2] = n;
            }
            Object removedIndices = thisCollection$iv;
            Iterable $this$filter$iv2 = value;
            boolean $i$f$filter2 = false;
            Iterable it = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            int $i$f$filterTo2 = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AttachToProcessActionBase.AttachToProcessItem it2 = (AttachToProcessActionBase.AttachToProcessItem)element$iv$iv;
                boolean bl = false;
                ProcessInfo processInfo = it2.getProcessInfo();
                Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"it.processInfo");
                if (!set2.contains(processInfo.getPid())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Collection $this$toTypedArray$iv2 = (List)destination$iv$iv3;
            int $i$f$toTypedArray2 = 0;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Object[] objectArray2 = thisCollection$iv2.toArray(new AttachToProcessActionBase.AttachToProcessItem[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] added = objectArray2;
            $i$f$toTypedArray2 = added.length;
            int[] nArray = new int[$i$f$toTypedArray2];
            int n3 = 0;
            while (n3 < $i$f$toTypedArray2) {
                void it3;
                $i$f$filterTo2 = n3;
                int n4 = n3++;
                object = nArray;
                boolean bl = false;
                n = value.indexOf(added[it3]);
                object[n4] = n;
            }
            int[] addedIndices = nArray;
            this.locals = value;
            TreePath path = new TreePath(this.getRoot());
            this.treeNodesRemoved(path, (int[])removedIndices, removed);
            this.treeNodesInserted(path, addedIndices, added);
        }

        @NotNull
        public Object getRoot() {
            return this.localProcessRoot;
        }

        @NotNull
        public List<Object> getChildren(@Nullable Object parent) {
            Object object = parent;
            return Intrinsics.areEqual((Object)object, (Object)this.localProcessRoot) ? this.locals : CollectionsKt.emptyList();
        }

        @NotNull
        public Class<?> getColumnClass(int column) {
            return MyColumns.values()[column].getColumnClass();
        }

        @NotNull
        public String getColumnName(int column) {
            return MyColumns.values()[column].getColumnName();
        }

        public boolean isCellEditable(@Nullable Object node, int column) {
            return false;
        }

        @NotNull
        public Void setValueAt(@Nullable Object aValue, @Nullable Object node, int column) {
            String string = "Not implemented";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public int getColumnCount() {
            return MyColumns.values().length;
        }

        @Nullable
        public Object getValueAt(@Nullable Object node, int column) {
            return MyColumns.values()[column].getValue(node, this);
        }

        public void setTree(@Nullable JTree tree2) {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isSameAs(List<? extends AttachToProcessActionBase.AttachToProcessItem> $this$isSameAs, List<? extends AttachToProcessActionBase.AttachToProcessItem> other) {
            if ($this$isSameAs.size() != other.size()) {
                return false;
            }
            int n = 0;
            int n2 = $this$isSameAs.size();
            while (n < n2) {
                void i;
                if (!this.isSameAs($this$isSameAs.get((int)i), other.get((int)i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSameAs(AttachToProcessActionBase.AttachToProcessItem $this$isSameAs, AttachToProcessActionBase.AttachToProcessItem other) {
            if ($this$isSameAs.compareTo((AttachToProcessActionBase.AttachItem)other) != 0) return false;
            List list = $this$isSameAs.getSubItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.subItems");
            List list2 = other.getSubItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"other.subItems");
            if (!this.isSameAs(list, list2)) return false;
            return true;
        }

        public static final /* synthetic */ boolean access$isSameAs(MyProcessModel $this, AttachToProcessActionBase.AttachToProcessItem $this$access_u24isSameAs, AttachToProcessActionBase.AttachToProcessItem other) {
            return $this.isSameAs($this$access_u24isSameAs, other);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH&j\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyColumns;", "", "(Ljava/lang/String;I)V", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "getValue", "", "node", "model", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel;", "DISPLAY_NAME", "PROCESS_ID", "intellij.profiler.ultimate"})
    private static final abstract class MyColumns
    extends Enum<MyColumns> {
        public static final /* enum */ MyColumns DISPLAY_NAME;
        public static final /* enum */ MyColumns PROCESS_ID;
        private static final /* synthetic */ MyColumns[] $VALUES;

        static {
            MyColumns[] myColumnsArray = new MyColumns[2];
            MyColumns[] myColumnsArray2 = myColumnsArray;
            myColumnsArray[0] = DISPLAY_NAME = new DISPLAY_NAME("DISPLAY_NAME", 0);
            myColumnsArray[1] = PROCESS_ID = new PROCESS_ID("PROCESS_ID", 1);
            $VALUES = myColumnsArray;
        }

        @Nullable
        public abstract Object getValue(@Nullable Object var1, @NotNull MyProcessModel var2);

        @NotNull
        public Class<?> getColumnClass() {
            return String.class;
        }

        @NlsContexts.ColumnName
        @NotNull
        public String getColumnName() {
            return "";
        }

        private MyColumns() {
        }

        public /* synthetic */ MyColumns(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static MyColumns[] values() {
            return (MyColumns[])$VALUES.clone();
        }

        public static MyColumns valueOf(String string) {
            return Enum.valueOf(MyColumns.class, string);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\f\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyColumns$DISPLAY_NAME;", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyColumns;", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "getValue", "", "node", "model", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel;", "intellij.profiler.ultimate"})
        static final class DISPLAY_NAME
        extends MyColumns {
            @Override
            @Nullable
            public Object getValue(@Nullable Object node, @NotNull MyProcessModel model) {
                Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
                return null;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }

            @Override
            @NotNull
            public String getColumnName() {
                return UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.application", new Object[0]);
            }

            /*
             * WARNING - void declaration
             */
            DISPLAY_NAME() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\f\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyColumns$PROCESS_ID;", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyColumns;", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "getValue", "", "node", "model", "Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$MyProcessModel;", "intellij.profiler.ultimate"})
        static final class PROCESS_ID
        extends MyColumns {
            @Override
            @Nullable
            public Object getValue(@Nullable Object node, @NotNull MyProcessModel model) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
                Object object = node;
                if (object instanceof AttachToProcessActionBase.AttachToProcessItem) {
                    ProcessInfo processInfo = ((AttachToProcessActionBase.AttachToProcessItem)node).getProcessInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)processInfo, (String)"node.processInfo");
                    n = processInfo.getPid();
                } else {
                    n = null;
                }
                return n;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass() {
                return Integer.TYPE;
            }

            @Override
            @NotNull
            public String getColumnName() {
                return UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.pid", new Object[0]);
            }

            /*
             * WARNING - void declaration
             */
            PROCESS_ID() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ultimate/welcome/WelcomeScreenPanel$Companion;", "", "()V", "UPDATE_TIME", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

