/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.profiler.api.NameBasedFilterProvider;
import com.intellij.profiler.ultimate.settings.JavaRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;

@State(name="javaRuleManager", storages={@Storage(value="javaRuleManager.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u001f\u0010\u0004\u001a\u00060\u0005R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/settings/JavaRuleManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "cache", "Lcom/intellij/profiler/ultimate/settings/JavaRuleManager$Compiled;", "getCache", "()Lcom/intellij/profiler/ultimate/settings/JavaRuleManager$Compiled;", "cache$delegate", "Lkotlin/Lazy;", "rules", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/ultimate/settings/JavaRule;", "Lkotlin/collections/ArrayList;", "getRules", "()Ljava/util/ArrayList;", "setRules", "(Ljava/util/ArrayList;)V", "getState", "loadState", "", "state", "noStateLoaded", "Companion", "Compiled", "intellij.profiler.ultimate"})
public final class JavaRuleManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Lazy cache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Compiled>(this){
        final /* synthetic */ JavaRuleManager this$0;

        @NotNull
        public final Compiled invoke() {
            return new Compiled(this.this$0, null, null, 3, null);
        }
        {
            this.this$0 = javaRuleManager;
            super(0);
        }
    }));
    @NotNull
    private ArrayList<JavaRule> rules = new ArrayList();
    @NotNull
    public static final String JAVA_RULE_MANAGER = "javaRuleManager";
    @NotNull
    private static final List<JavaRule> DEF;
    public static final Companion Companion;

    @NotNull
    public final Compiled getCache() {
        Lazy lazy = this.cache$delegate;
        JavaRuleManager javaRuleManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Compiled)lazy.getValue();
    }

    @NotNull
    public final ArrayList<JavaRule> getRules() {
        return this.rules;
    }

    public final void setRules(@NotNull ArrayList<JavaRule> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.rules = arrayList;
    }

    @NotNull
    public Element getState() {
        Element el = new Element(JAVA_RULE_MANAGER);
        for (JavaRule group : this.rules) {
            Element gel = new Element("group").setAttribute("name", group.getGroupName());
            Iterable $this$forEach$iv = group.getRules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                gel.addContent(new Element("item").addContent(it));
            }
            el.addContent(gel);
        }
        return el;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.rules.clear();
        Iterator iterator2 = state.getContent((Filter)new ElementFilter()).iterator();
        while (iterator2.hasNext()) {
            String groupName;
            Element element;
            Element element2 = element = (Element)iterator2.next();
            if (element2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jdom.Element");
            }
            Attribute attribute = element2.getAttribute("name");
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"(element as Element).getAttribute(\"name\")");
            String string = groupName = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"groupName");
            JavaRule jr = new JavaRule(string, new String[0]);
            for (Element rule : element.getContent((Filter)new ElementFilter())) {
                List<String> list = jr.getRules();
                Content content = rule.getContent(0);
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"rule.getContent(0)");
                String string2 = content.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rule.getContent(0).value");
                list.add(string2);
            }
            this.rules.add(jr);
        }
    }

    public void noStateLoaded() {
        this.rules.addAll((Collection<JavaRule>)DEF);
    }

    static {
        Companion = new Companion(null);
        DEF = CollectionsKt.listOf((Object[])new JavaRule[]{new JavaRule("Java", "java.*", "javax.*", "sun.*", "sunw.*", "com.sun.*", "org.omg.CORBA.*", "org.omg.CosNaming.*", "COM.rsa.*", "jrockit.*", "javafx.*", "jdk.internal.*"), new JavaRule("Google", "com.google.*"), new JavaRule("Gradle", "org.gradle.*"), new JavaRule("Groovy", "org.codehaus.groovy.*", "groovy.lang.*", "groovyjarjarasm.*"), new JavaRule("Hibernate", "org.hibernate.*"), new JavaRule("Intellij IDEA", "com.intellij.rt.execution.*"), new JavaRule("JBoss", "org.jboss.*", "org.jbossmq.*", "org.enhydra.*", "org.hsql.*"), new JavaRule("JRuby", "org.jruby.*", "jline.*"), new JavaRule("Netty", "io.netty.*"), new JavaRule("OSGi", "org.osgi.*"), new JavaRule("SQL", "org.hsqldb.*", "com.mysql.*", "com.microsoft.sqlserver.*", "org.postgresql.*"), new JavaRule("Tests", "junit.*", "org.junit.*", "org.testng.*", "com.beust.*", "org.spockframework.*"), new JavaRule("XML & JSON", "org.w3c.*", "org.xml.*", "org.jdom.*", "org.json.*", "org.dom4j.*", "org.kxml*", "org.codehaus.jackson.*", "net.sf.json.*", "com.fasterxml.*", "com.ctc.wstx.*", "GregorSamsa"), new JavaRule("Native & Others", "[unknown]", "_*", "*::*")});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/settings/JavaRuleManager$Compiled;", "", "filters", "", "Ljava/util/regex/Pattern;", "exclusions", "(Lcom/intellij/profiler/ultimate/settings/JavaRuleManager;Ljava/util/List;Ljava/util/List;)V", "getExclusions", "()Ljava/util/List;", "getFilters", "recompile", "", "intellij.profiler.ultimate"})
    public final class Compiled {
        @NotNull
        private final List<Pattern> filters;
        @NotNull
        private final List<Pattern> exclusions;
        final /* synthetic */ JavaRuleManager this$0;

        /*
         * WARNING - void declaration
         */
        public final void recompile() {
            void $this$flatMapTo$iv$iv;
            this.filters.clear();
            this.exclusions.clear();
            Iterable $this$flatMap$iv = this.this$0.getRules();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JavaRule it = (JavaRule)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getRules();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((CharSequence)it, (char)'+', (boolean)false, (int)2, null)) {
                    String string = it;
                    int n = 1;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    this.exclusions.add(NameBasedFilterProvider.Companion.compile(string3));
                    continue;
                }
                this.filters.add(NameBasedFilterProvider.Companion.compile(it));
            }
        }

        @NotNull
        public final List<Pattern> getFilters() {
            return this.filters;
        }

        @NotNull
        public final List<Pattern> getExclusions() {
            return this.exclusions;
        }

        public Compiled(@NotNull JavaRuleManager this$0, @NotNull List<Pattern> filters, List<Pattern> exclusions) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
            this.this$0 = this$0;
            this.filters = filters;
            this.exclusions = exclusions;
            this.recompile();
        }

        public /* synthetic */ Compiled(JavaRuleManager javaRuleManager, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl;
            if ((n & 1) != 0) {
                bl = false;
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                bl = false;
                list2 = new ArrayList();
            }
            this(javaRuleManager, list, list2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/settings/JavaRuleManager$Companion;", "", "()V", "DEF", "", "Lcom/intellij/profiler/ultimate/settings/JavaRule;", "getDEF", "()Ljava/util/List;", "JAVA_RULE_MANAGER", "", "getInstance", "Lcom/intellij/profiler/ultimate/settings/JavaRuleManager;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @NotNull
        public final JavaRuleManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(JavaRuleManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026aRuleManager::class.java)");
            return (JavaRuleManager)object;
        }

        @NotNull
        public final List<JavaRule> getDEF() {
            return DEF;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

