/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.fileTypes.AbstractSnapshotFileType;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JfrFileType
extends AbstractSnapshotFileType {
    public static final JfrFileType INSTANCE = new JfrFileType();

    private JfrFileType() {
    }

    @NonNls
    @NotNull
    public String getName() {
        return "JFR";
    }

    @NlsContexts.Label
    @NotNull
    public String getDescription() {
        String string = UltimateProfilerBundleKt.profilerMessage("jfr.dump.description", new Object[0]);
        if (string == null) {
            JfrFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDefaultExtension() {
        return "jfr";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Jfr;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            JfrFileType.$$$reportNull$$$0(1);
        }
        if (!this.checkBinaryHeader("FLR", file)) {
            return false;
        }
        ImportProfilerResultAction.Companion.importProfilerDump(project, file.toNioPath().toFile(), null, null, null);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ultimate/jfr/JfrFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ultimate/jfr/JfrFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

