/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.CopyFileDumpWriter;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.AttachedToAlreadyRunningProcessCommunicator;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.StartedFromExternalSystemProcess;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProvider;
import com.intellij.profiler.ultimate.jfr.JFRProfilerProcess;
import com.intellij.profiler.ultimate.jfr.RecordingConfiguration;
import com.intellij.profiler.ultimate.jfr.configuration.JFRConfigurationState;
import com.sun.tools.attach.VirtualMachine;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import sun.tools.attach.HotSpotVirtualMachine;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001&B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "communicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "recordingConfiguration", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "attachedTimestamp", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;J)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAttachedTimestamp", "()J", "helpId", "", "getHelpId", "()Ljava/lang/String;", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "doStop", "", "targetProcessId", "", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.profiler.ultimate"})
public final class JFRProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends JavaProfilerProcess<TargetProcess> {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final String helpId;
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    private final RecordingConfiguration recordingConfiguration;
    private final long attachedTimestamp;
    private static final Logger logger;
    private static final String CMD_HELP = "help";
    private static final String CMD_START = "JFR.start";
    private static final String CMD_STOP = "JFR.stop";
    private static final String CMD_CHECK = "JFR.check";
    private static final String CMD_CONFIGURE = "JFR.configure";
    private static final String UNLOCK_COMMERCIAL_MESSAGE = "Use VM.unlock_commercial_features to enable.";
    private static final String STARTED_MESSAGE = "Started recording";
    private static final String STOPPED_MESSAGE = "Stopped recording";
    private static final String JFR_LICENSE_URL = "http://www.oracle.com/technetwork/java/javase/terms/products/index.html";
    public static final Companion Companion;

    @NotNull
    protected Logger getLOG() {
        return this.LOG;
    }

    @Override
    protected boolean doStop(int targetProcessId) {
        Function1<Exception, Unit> $fun$onUnexpectedError$1 = new Function1<Exception, Unit>(this){
            final /* synthetic */ JFRProfilerProcess this$0;

            public final void invoke(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getLOG().error((Throwable)e);
                JFRProfilerProcess.access$changeStateAndNotifyAsync(this.this$0, (ProfilerState)new ProfilerError(UltimateProfilerBundleKt.profilerMessage("jfr.cant.stop.profiler", new Object[0])));
            }
            {
                this.this$0 = jFRProfilerProcess;
                super(1);
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, targetProcessId, $fun$onUnexpectedError$1){
            final /* synthetic */ JFRProfilerProcess this$0;
            final /* synthetic */ int $targetProcessId;
            final /* synthetic */ doStop.1 $onUnexpectedError$1;

            public final void run() {
                JFRProfilerProcess.access$runUnderDumpReadIndicator(this.this$0, (Function1)new Function1<ProgressIndicator, Unit>(this){
                    final /* synthetic */ doStop.2 this$0;

                    public final void invoke(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$safeVMAttach(JFRProfilerProcess.Companion, this.this$0.$targetProcessId, (Function1)new Function1<Exception, Unit>(this){
                            final /* synthetic */ doStop.1 this$0;

                            public final void invoke(@NotNull Exception p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                this.this$0.this$0.$onUnexpectedError$1.invoke(p1);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1, null, "onUnexpectedError", "invoke(Ljava/lang/Exception;)V", 0);
                            }
                        }, (Function1)new Function1<HotSpotVirtualMachine, Unit>(this, indicator){
                            final /* synthetic */ doStop.1 this$0;
                            final /* synthetic */ ProgressIndicator $indicator;

                            public final void invoke(@NotNull HotSpotVirtualMachine vm) {
                                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                                this.$indicator.checkCanceled();
                                JFRProfilerProcess.access$getCommunicator$p(this.this$0.this$0.this$0).dispose();
                                JFRProfilerProcess.access$changeStateAndNotifyAsync(this.this$0.this$0.this$0, (ProfilerState)ReadingData.INSTANCE);
                                File file = FileUtil.createTempFile((String)"javaFlightRecorder", (String)".jfr", (boolean)true);
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026tRecorder\", \".jfr\", true)");
                                File dumpFile = file;
                                List command = CollectionsKt.listOf((Object[])new String[]{"JFR.stop", "name=\"" + JFRProfilerProcess.access$getRecordingConfiguration$p(this.this$0.this$0.this$0).getName() + '\"', "filename=\"" + dumpFile.getAbsolutePath() + '\"'});
                                this.this$0.this$0.this$0.getLOG().info("stop profiler command: " + command);
                                String stop = com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$execCommand(JFRProfilerProcess.Companion, vm, CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                                this.$indicator.checkCanceled();
                                if (StringsKt.contains$default((CharSequence)stop, (CharSequence)"Stopped recording", (boolean)false, (int)2, null)) {
                                    this.this$0.this$0.this$0.getLOG().info("doStop, targetPid: " + this.this$0.this$0.$targetProcessId + ", dumpFile: " + dumpFile.getAbsolutePath());
                                    ProfilerState readResult = JFRProfilerProcess.access$readPreparedDumpAndReportStatistics(this.this$0.this$0.this$0, dumpFile, this.$indicator);
                                    JFRProfilerProcess.access$changeStateAndNotifyAsync(this.this$0.this$0.this$0, readResult);
                                } else {
                                    this.this$0.this$0.$onUnexpectedError$1.invoke(new IllegalStateException(UltimateProfilerBundleKt.profilerMessage("jfr.unexpected.response", "JFR.stop", stop)));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$indicator = progressIndicator;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = jFRProfilerProcess;
                this.$targetProcessId = n;
                this.$onUnexpectedError$1 = var3_3;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.getTargetProcess() instanceof StartedFromExternalSystemProcess) {
            String string = this.getDumpFileWhenTargetProcessFinished().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dumpFileWhenTargetProcessFinished.absolutePath");
            File errorMessageFile = new File(Companion.errorMessageFileFromDumpFile(string));
            if (errorMessageFile.exists() && errorMessageFile.length() > 0L) {
                try {
                    String message = FilesKt.readText$default((File)errorMessageFile, null, (int)1, null);
                    CharSequence charSequence = message;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        charSequence = (ProfilerState)new ProfilerError(message);
                        return charSequence;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    errorMessageFile.delete();
                }
            }
        }
        ProfilerDumpFileParsingResult result = JFRDumpParserProvider.INSTANCE.createParser(this.getProject()).parse(dump, indicator);
        return this.asProfilerState(result, (ProfilerDumpWriter)new CopyFileDumpWriter(dump, this.getTargetProcess().getPrettyHumanReadableNameWithoutPid(), this.getAttachedTimestamp(), "jfr"));
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    public JFRProfilerProcess(@NotNull Project project, @NotNull ProfilerProcessCommunicator<TargetProcess> communicator, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull RecordingConfiguration recordingConfiguration, long attachedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(communicator, (String)"communicator");
        Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)recordingConfiguration, (String)"recordingConfiguration");
        super(project, communicator, recordingConfiguration.getDumpFile());
        this.profilerConfiguration = profilerConfiguration;
        this.recordingConfiguration = recordingConfiguration;
        this.attachedTimestamp = attachedTimestamp;
        this.LOG = logger;
        this.helpId = "procedures.profiler";
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JFRProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        JFRProfilerProcess.logger = logger;
    }

    public static final /* synthetic */ void access$changeStateAndNotifyAsync(JFRProfilerProcess $this, ProfilerState newState) {
        $this.changeStateAndNotifyAsync(newState);
    }

    public static final /* synthetic */ void access$runUnderDumpReadIndicator(JFRProfilerProcess $this, Function1 process) {
        $this.runUnderDumpReadIndicator(process);
    }

    public static final /* synthetic */ ProfilerProcessCommunicator access$getCommunicator$p(JFRProfilerProcess $this) {
        return $this.getCommunicator();
    }

    public static final /* synthetic */ RecordingConfiguration access$getRecordingConfiguration$p(JFRProfilerProcess $this) {
        return $this.recordingConfiguration;
    }

    public static final /* synthetic */ ProfilerState access$readPreparedDumpAndReportStatistics(JFRProfilerProcess $this, File dump, ProgressIndicator indicator) {
        return $this.readPreparedDumpAndReportStatistics(dump, indicator);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J<\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u001f0#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001f0#H\u0002J\u0014\u0010(\u001a\u00020\u0004*\u00020'2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess$Companion;", "", "()V", "CMD_CHECK", "", "CMD_CONFIGURE", "getCMD_CONFIGURE$annotations", "CMD_HELP", "CMD_START", "CMD_STOP", "JFR_LICENSE_URL", "STARTED_MESSAGE", "STOPPED_MESSAGE", "UNLOCK_COMMERCIAL_MESSAGE", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "attach", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "recordingConfiguration", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "settings", "Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;", "project", "Lcom/intellij/openapi/project/Project;", "errorMessageFileFromDumpFile", "dumpFile", "safeVMAttach", "", "pid", "", "onError", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "body", "Lsun/tools/attach/HotSpotVirtualMachine;", "execCommand", "command", "intellij.profiler.ultimate"})
    public static final class Companion {
        private static /* synthetic */ void getCMD_CONFIGURE$annotations() {
        }

        @NotNull
        public final Promise<JFRProfilerProcess<AttachableTargetProcess>> attach(@NotNull AttachableTargetProcess targetProcess, @NotNull RecordingConfiguration recordingConfiguration, @NotNull JFRConfigurationState settings, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)recordingConfiguration, (String)"recordingConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result = new AsyncPromise();
            new Task.Backgroundable(targetProcess, result, project, settings, recordingConfiguration, project, CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.title", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ AsyncPromise $result;
                final /* synthetic */ Project $project;
                final /* synthetic */ JFRConfigurationState $settings;
                final /* synthetic */ RecordingConfiguration $recordingConfiguration;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    indicator.setText(CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.text", (Object[])new Object[]{this.$targetProcess.getFullName()}));
                    Function1<Exception, Unit> $fun$onUnexpectedError$1 = new Function1<Exception, Unit>(this){
                        final /* synthetic */ attach.1 this$0;

                        public final void invoke(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            JFRProfilerProcess.access$getLogger$cp().error((Throwable)e);
                            this.this$0.$result.setError((Throwable)new AttachFailedException(UtilsKt.explain((Throwable)e, (String)UltimateProfilerBundleKt.profilerMessage("jfr.profile.cant.attach", new Object[0]))));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$safeVMAttach(JFRProfilerProcess.Companion, this.$targetProcess.getPid(), (Function1)new Function1<Exception, Unit>($fun$onUnexpectedError$1){
                        final /* synthetic */ attach.run.1 $onUnexpectedError$1;

                        public final void invoke(@NotNull Exception p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            this.$onUnexpectedError$1.invoke(p1);
                        }
                        {
                            this.$onUnexpectedError$1 = var1_1;
                            super(1, null, "onUnexpectedError", "invoke(Ljava/lang/Exception;)V", 0);
                        }
                    }, (Function1)new Function1<HotSpotVirtualMachine, Unit>(this){
                        final /* synthetic */ attach.1 this$0;

                        public final void invoke(@NotNull HotSpotVirtualMachine vm) {
                            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                            Object[] objectArray = StringUtil.splitByLines((String)com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$execCommand(JFRProfilerProcess.Companion, vm, "help"));
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"StringUtil.splitByLines(vm.execCommand(CMD_HELP))");
                            List supportedCommands = ArraysKt.toList((Object[])objectArray);
                            if (!supportedCommands.containsAll(CollectionsKt.listOf((Object[])new String[]{"JFR.check", "JFR.start", "JFR.stop"}))) {
                                this.this$0.$result.setError((Throwable)new AttachFailedException(UltimateProfilerBundleKt.profilerMessage("jfr.cant.attach.unsupported", new Object[0])));
                                return;
                            }
                            String check = com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$execCommand(JFRProfilerProcess.Companion, vm, "JFR.check");
                            if (StringsKt.contains$default((CharSequence)check, (CharSequence)"Use VM.unlock_commercial_features to enable.", (boolean)false, (int)2, null)) {
                                MisConfiguredException commercialFeaturesMessage2 = new MisConfiguredException(this, this.this$0.$project, UltimateProfilerBundleKt.profilerMessage("jfr.commercial.message", String.valueOf(this.this$0.$targetProcess.getPid())), UltimateProfilerBundleKt.profilerMessage("jfr.commercial.url.text", new Object[0])){
                                    final /* synthetic */ attach.run.3 this$0;

                                    public void fixAction(@NotNull Project project) {
                                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                        BrowserUtil.browse((String)"http://www.oracle.com/technetwork/java/javase/terms/products/index.html");
                                    }
                                    {
                                        this.this$0 = this$0;
                                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                                    }
                                };
                                this.this$0.$result.setError((Throwable)commercialFeaturesMessage2);
                                return;
                            }
                            Object warningMessage = null;
                            CharSequence charSequence = this.this$0.$settings.getFlightRecorderOptions();
                            boolean bl = false;
                            boolean bl2 = false;
                            if (!(charSequence == null || charSequence.length() == 0)) {
                                Companion.attach.run.1 $fun$buildWarningMessage$1 = Companion.attach.run.1.INSTANCE;
                                warningMessage = $fun$buildWarningMessage$1.invoke();
                            }
                            List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"JFR.start"), (Iterable)this.this$0.$recordingConfiguration.startCommand(this.this$0.$settings.getStartSetting()));
                            JFRProfilerProcess.access$getLogger$cp().info("attach profiler  command: " + command);
                            String start = com.intellij.profiler.ultimate.jfr.JFRProfilerProcess$Companion.access$execCommand(JFRProfilerProcess.Companion, vm, CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            if (StringsKt.contains$default((CharSequence)start, (CharSequence)"Started recording", (boolean)false, (int)2, null)) {
                                AttachedToAlreadyRunningProcessCommunicator communicator = new AttachedToAlreadyRunningProcessCommunicator(this.this$0.$targetProcess);
                                this.this$0.$result.setResult(new JFRProfilerProcess<TargetProcess>(this.this$0.$project, communicator, (ProfilerConfigurationState)this.this$0.$settings, this.this$0.$recordingConfiguration, System.currentTimeMillis()));
                                CharSequence charSequence2 = (CharSequence)warningMessage;
                                boolean bl3 = false;
                                boolean bl4 = false;
                                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                                    ProfilerToolWindowManager.Companion.getInstance(this.this$0.$project).showWarningBalloon((String)warningMessage);
                                }
                            } else {
                                throw (Throwable)new IllegalStateException(UltimateProfilerBundleKt.profilerMessage("jfr.unexpected.response", "JFR.start", start));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                {
                    this.$targetProcess = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$settings = $captured_local_variable$3;
                    this.$recordingConfiguration = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                }
            }.queue();
            return (Promise)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void safeVMAttach(int pid, Function1<? super Exception, Unit> onError, Function1<? super HotSpotVirtualMachine, Unit> body) {
            VirtualMachine vm = null;
            try {
                HotSpotVirtualMachine hvm;
                vm = VirtualMachine.attach(String.valueOf(pid));
                VirtualMachine virtualMachine = vm;
                if (!(virtualMachine instanceof HotSpotVirtualMachine)) {
                    virtualMachine = null;
                }
                if ((hvm = (HotSpotVirtualMachine)virtualMachine) == null) {
                    logger.debug("Can't cast " + vm + " to HotSpotVirtualMachine");
                    throw (Throwable)new IllegalStateException();
                }
                body.invoke((Object)hvm);
            }
            catch (Exception e) {
                onError.invoke((Object)e);
            }
            finally {
                try {
                    VirtualMachine virtualMachine = vm;
                    if (virtualMachine != null) {
                        virtualMachine.detach();
                    }
                }
                catch (Exception e) {
                    logger.debug((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String execCommand(HotSpotVirtualMachine $this$execCommand, String command) {
            List list;
            Closeable closeable = $this$execCommand.executeJCmd(command);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                InputStream inputStream = it;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                list = TextStreamsKt.readLines((Reader)new InputStreamReader(inputStream2, charset));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String errorMessageFileFromDumpFile(@NotNull String dumpFile) {
            Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
            return dumpFile + ".gradle_error";
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$safeVMAttach(Companion $this, int pid, Function1 onError, Function1 body) {
            $this.safeVMAttach(pid, (Function1<? super Exception, Unit>)onError, (Function1<? super HotSpotVirtualMachine, Unit>)body);
        }

        public static final /* synthetic */ String access$execCommand(Companion $this, HotSpotVirtualMachine $this$access_u24execCommand, String command) {
            return $this.execCommand($this$access_u24execCommand, command);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

