/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ultimate.jfr.JFRProfilerData$sam$java_lang_Runnable$0;
import com.intellij.profiler.ultimate.jfr.jmc.StreamModel;
import com.intellij.profiler.ultimate.jfr.ui.JFRDumpViewKt;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import com.intellij.profiler.ultimate.model.OtherJavaCall;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.TimestampUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData;", "Lcom/intellij/profiler/api/ProfilerData;", "allEvents", "Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "cpuSampling", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "(Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;Lcom/intellij/profiler/DummyCallTreeBuilder;)V", "getCpuSampling", "()Lcom/intellij/profiler/DummyCallTreeBuilder;", "isEmpty", "", "()Z", "doCreateTopLevelComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "ArrayFactory", "IItemFactory", "JFRSamplingTreeBuilder", "Sample", "SampleFactory", "intellij.profiler.ultimate"})
public final class JFRProfilerData
implements ProfilerData {
    private final boolean isEmpty;
    private final StreamModel allEvents;
    @NotNull
    private final DummyCallTreeBuilder<BaseCallStackElement> cpuSampling;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @NotNull
    public JComponent doCreateTopLevelComponent(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return JFRDumpViewKt.createJFRDumpView(project, parent, this.allEvents, this.cpuSampling);
    }

    @NotNull
    public final DummyCallTreeBuilder<BaseCallStackElement> getCpuSampling() {
        return this.cpuSampling;
    }

    public JFRProfilerData(@NotNull StreamModel allEvents, @NotNull DummyCallTreeBuilder<BaseCallStackElement> cpuSampling) {
        Intrinsics.checkNotNullParameter((Object)allEvents, (String)"allEvents");
        Intrinsics.checkNotNullParameter(cpuSampling, (String)"cpuSampling");
        this.allEvents = allEvents;
        this.cpuSampling = cpuSampling;
        this.isEmpty = !this.allEvents.getItems().hasItems() && this.cpuSampling.isEmpty();
    }

    @NotNull
    public JComponent createTopLevelComponent(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return ProfilerData.DefaultImpls.createTopLevelComponent((ProfilerData)this, (Project)project, (Disposable)parent);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0006\u0010\u001d\u001a\u00020\u0019J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\u001d\u0010#\u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u00192\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$JFRSamplingTreeBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachingReader", "Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;", "closed", "", "future", "Ljava/util/concurrent/Future;", "kotlin.jvm.PlatformType", "nativeCallsCache", "Ljava/util/HashMap;", "", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lkotlin/collections/HashMap;", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "sampleFactory", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory;", "", "tree", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "addEvent", "", "event", "([Ljava/lang/Object;)V", "buildTree", "finish", "getTree", "process", "data", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "put", "readData", "item", "([Ljava/lang/Object;)Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "setDataStructure", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "Companion", "intellij.profiler.ultimate"})
    public static final class JFRSamplingTreeBuilder {
        private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(100);
        private final Future<?> future;
        private volatile boolean closed;
        private final DummyCallTreeBuilder<BaseCallStackElement> tree;
        private final JavaCachingStackElementReader cachingReader;
        private final HashMap<String, BaseCallStackElement> nativeCallsCache;
        private SampleFactory<Object[]> sampleFactory;
        private static final String END = "End";
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        private final void process(Sample data2) {
            void $this$mapTo$iv$iv;
            if (Intrinsics.areEqual((Object)data2.getState(), (Object)"STATE_RUNNABLE") ^ true) {
                return;
            }
            List list = data2.getStack().getFrames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"data.stack.frames");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BaseCallStackElement baseCallStackElement;
                void frame;
                IMCFrame iMCFrame = (IMCFrame)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = frame;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"frame");
                if (v1.getType() == IMCFrame.Type.UNKNOWN) {
                    Object object;
                    String key$iv;
                    void $this$getOrPut$iv;
                    String string;
                    IMCMethod iMCMethod = frame.getMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)iMCMethod, (String)"frame.method");
                    if (Intrinsics.areEqual((Object)iMCMethod.getMethodName(), (Object)"new")) {
                        IMCMethod iMCMethod2 = frame.getMethod();
                        Intrinsics.checkNotNullExpressionValue((Object)iMCMethod2, (String)"frame.method");
                        IMCType iMCType = iMCMethod2.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)iMCType, (String)"frame.method.type");
                        string = iMCType.getTypeName();
                    } else {
                        IMCMethod iMCMethod3 = frame.getMethod();
                        Intrinsics.checkNotNullExpressionValue((Object)iMCMethod3, (String)"frame.method");
                        string = iMCMethod3.getMethodName();
                    }
                    String symbol = string;
                    Map map = this.nativeCallsCache;
                    Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        String string2 = frame.getRawType();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"frame.rawType");
                        BaseCallStackElement answer$iv = this.cachingReader.parseNativeCall(symbol, string2);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    baseCallStackElement = (BaseCallStackElement)object;
                } else {
                    baseCallStackElement = this.cachingReader.internJFRMethodCall((IMCFrame)frame);
                }
                BaseCallStackElement baseCallStackElement2 = baseCallStackElement;
                collection.add(baseCallStackElement2);
            }
            List preparedFrames = CollectionsKt.asReversed((List)((List)destination$iv$iv));
            List stackElements = data2.getStack().getTruncationState() == IMCStackTrace.TruncationState.TRUNCATED ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.cachingReader.intern(new OtherJavaCall("[truncated]"))), (Iterable)preparedFrames) : preparedFrames;
            this.tree.addStack(data2.getThread(), stackElements, 1L);
        }

        public final void setDataStructure(@Nullable List<ValueField> dataStructure) {
            if (dataStructure == null) {
                return;
            }
            if (this.sampleFactory != null) {
                return;
            }
            this.sampleFactory = SampleFactory.Companion.create(dataStructure);
        }

        private final Sample readData(Object[] item) {
            SampleFactory<Object[]> sampleFactory = this.sampleFactory;
            Intrinsics.checkNotNull(sampleFactory);
            return sampleFactory.get(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void buildTree() {
            try {
                Object event = null;
                while (true) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.queue.take(), (String)"queue.take()");
                    if (event == END) {
                        break;
                    }
                    Object object = event;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.jfr.JFRProfilerData.Sample");
                    }
                    this.process((Sample)object);
                }
            }
            finally {
                this.closed = true;
                this.queue.clear();
            }
        }

        public final void addEvent(@NotNull Object[] event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.put(this.readData(event));
            if (this.closed) {
                this.future.get();
            }
        }

        public final void finish() {
            this.put(END);
        }

        private final void put(Object event) {
            while (!this.closed && !this.queue.offer(event, 100L, TimeUnit.MILLISECONDS)) {
            }
        }

        @NotNull
        public final DummyCallTreeBuilder<BaseCallStackElement> getTree() {
            this.future.get();
            return this.tree;
        }

        public JFRSamplingTreeBuilder(@Nullable Project project) {
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    JFRSamplingTreeBuilder.access$buildTree((JFRSamplingTreeBuilder)this.receiver);
                }
            };
            this.future = AppExecutorUtil.getAppExecutorService().submit(new JFRProfilerData$sam$java_lang_Runnable$0(function0));
            this.tree = new DummyCallTreeBuilder();
            this.cachingReader = JavaCachingStackElementReader.Companion.getOrCreate(project);
            boolean bl = false;
            this.nativeCallsCache = new HashMap();
        }

        public static final /* synthetic */ void access$buildTree(JFRSamplingTreeBuilder $this) {
            $this.buildTree();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$JFRSamplingTreeBuilder$Companion;", "", "()V", "END", "", "intellij.profiler.ultimate"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "", "state", "", "timestampMs", "", "thread", "Lcom/intellij/profiler/model/ThreadInfo;", "stack", "Lorg/openjdk/jmc/common/IMCStackTrace;", "(Ljava/lang/String;JLcom/intellij/profiler/model/ThreadInfo;Lorg/openjdk/jmc/common/IMCStackTrace;)V", "getStack", "()Lorg/openjdk/jmc/common/IMCStackTrace;", "getState", "()Ljava/lang/String;", "getThread", "()Lcom/intellij/profiler/model/ThreadInfo;", "getTimestampMs", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.profiler.ultimate"})
    public static final class Sample {
        @NotNull
        private final String state;
        private final long timestampMs;
        @NotNull
        private final ThreadInfo thread;
        @NotNull
        private final IMCStackTrace stack;
        @NotNull
        public static final String STATE_RUNNABLE = "STATE_RUNNABLE";
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getState() {
            return this.state;
        }

        public final long getTimestampMs() {
            return this.timestampMs;
        }

        @NotNull
        public final ThreadInfo getThread() {
            return this.thread;
        }

        @NotNull
        public final IMCStackTrace getStack() {
            return this.stack;
        }

        public Sample(@NotNull String state, long timestampMs, @NotNull ThreadInfo thread, @NotNull IMCStackTrace stack) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.state = state;
            this.timestampMs = timestampMs;
            this.thread = thread;
            this.stack = stack;
        }

        @NotNull
        public final String component1() {
            return this.state;
        }

        public final long component2() {
            return this.timestampMs;
        }

        @NotNull
        public final ThreadInfo component3() {
            return this.thread;
        }

        @NotNull
        public final IMCStackTrace component4() {
            return this.stack;
        }

        @NotNull
        public final Sample copy(@NotNull String state, long timestampMs, @NotNull ThreadInfo thread, @NotNull IMCStackTrace stack) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new Sample(state, timestampMs, thread, stack);
        }

        public static /* synthetic */ Sample copy$default(Sample sample, String string, long l, ThreadInfo threadInfo, IMCStackTrace iMCStackTrace, int n, Object object) {
            if ((n & 1) != 0) {
                string = sample.state;
            }
            if ((n & 2) != 0) {
                l = sample.timestampMs;
            }
            if ((n & 4) != 0) {
                threadInfo = sample.thread;
            }
            if ((n & 8) != 0) {
                iMCStackTrace = sample.stack;
            }
            return sample.copy(string, l, threadInfo, iMCStackTrace);
        }

        @NotNull
        public String toString() {
            return "Sample(state=" + this.state + ", timestampMs=" + this.timestampMs + ", thread=" + this.thread + ", stack=" + this.stack + ")";
        }

        public int hashCode() {
            String string = this.state;
            ThreadInfo threadInfo = this.thread;
            IMCStackTrace iMCStackTrace = this.stack;
            return (((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.timestampMs)) * 31 + (threadInfo != null ? threadInfo.hashCode() : 0)) * 31 + (iMCStackTrace != null ? iMCStackTrace.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Sample)) break block3;
                    Sample sample = (Sample)object;
                    if (!Intrinsics.areEqual((Object)this.state, (Object)sample.state) || this.timestampMs != sample.timestampMs || !Intrinsics.areEqual((Object)this.thread, (Object)sample.thread) || !Intrinsics.areEqual((Object)this.stack, (Object)sample.stack)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample$Companion;", "", "()V", "STATE_RUNNABLE", "", "intellij.profiler.ultimate"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory;", "Source", "", "()V", "createThread", "Lcom/intellij/profiler/model/ThreadInfo;", "thread", "Lorg/openjdk/jmc/common/IMCThread;", "get", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "source", "(Ljava/lang/Object;)Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "Companion", "intellij.profiler.ultimate"})
    public static abstract class SampleFactory<Source> {
        public static final Companion Companion = new Companion(null);

        @NotNull
        public abstract Sample get(Source var1);

        @NotNull
        protected final ThreadInfo createThread(@NotNull IMCThread thread) {
            String string;
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Long l = thread.getThreadId();
            String string2 = l != null ? String.valueOf(l) : null;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            if ((string = thread.getThreadName()) == null) {
                string = "Unknown Thread";
            }
            return (ThreadInfo)new JVMThread(string3, string);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory$Companion;", "", "()V", "create", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory;", "", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "Lorg/openjdk/jmc/common/item/IItem;", "item", "intellij.profiler.ultimate"})
        public static final class Companion {
            @NotNull
            public final SampleFactory<IItem> create(@NotNull IItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return IItemFactory.Companion.create(item);
            }

            @NotNull
            public final SampleFactory<Object[]> create(@NotNull List<ValueField> dataStructure) {
                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                return ArrayFactory.Companion.create(dataStructure);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B]\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR#\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$IItemFactory;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory;", "Lorg/openjdk/jmc/common/item/IItem;", "thread", "Lorg/openjdk/jmc/common/item/IMemberAccessor;", "Lorg/openjdk/jmc/common/IMCThread;", "stackTrace", "Lorg/openjdk/jmc/common/IMCStackTrace;", "threadState", "", "timestamp", "Lorg/openjdk/jmc/common/unit/ITypedQuantity;", "Lorg/openjdk/jmc/common/unit/TimestampUnit;", "(Lorg/openjdk/jmc/common/item/IMemberAccessor;Lorg/openjdk/jmc/common/item/IMemberAccessor;Lorg/openjdk/jmc/common/item/IMemberAccessor;Lorg/openjdk/jmc/common/item/IMemberAccessor;)V", "getStackTrace", "()Lorg/openjdk/jmc/common/item/IMemberAccessor;", "getThread", "getThreadState", "getTimestamp", "get", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "source", "Companion", "intellij.profiler.ultimate"})
    private static final class IItemFactory
    extends SampleFactory<IItem> {
        @NotNull
        private final IMemberAccessor<IMCThread, IItem> thread;
        @NotNull
        private final IMemberAccessor<IMCStackTrace, IItem> stackTrace;
        @NotNull
        private final IMemberAccessor<String, IItem> threadState;
        @NotNull
        private final IMemberAccessor<ITypedQuantity<TimestampUnit>, IItem> timestamp;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Sample get(@NotNull IItem source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String state = (String)this.threadState.getMember((Object)source);
            long timestampMs = ((ITypedQuantity)this.timestamp.getMember((Object)source)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_MS);
            IMCThread thread = (IMCThread)this.thread.getMember((Object)source);
            IMCStackTrace stack = (IMCStackTrace)this.stackTrace.getMember((Object)source);
            String string = state;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"state");
            IMCThread iMCThread = thread;
            Intrinsics.checkNotNullExpressionValue((Object)iMCThread, (String)"thread");
            ThreadInfo threadInfo = this.createThread(iMCThread);
            IMCStackTrace iMCStackTrace = stack;
            Intrinsics.checkNotNullExpressionValue((Object)iMCStackTrace, (String)"stack");
            return new Sample(string, timestampMs, threadInfo, iMCStackTrace);
        }

        @NotNull
        public final IMemberAccessor<IMCThread, IItem> getThread() {
            return this.thread;
        }

        @NotNull
        public final IMemberAccessor<IMCStackTrace, IItem> getStackTrace() {
            return this.stackTrace;
        }

        @NotNull
        public final IMemberAccessor<String, IItem> getThreadState() {
            return this.threadState;
        }

        @NotNull
        public final IMemberAccessor<ITypedQuantity<TimestampUnit>, IItem> getTimestamp() {
            return this.timestamp;
        }

        private IItemFactory(IMemberAccessor<IMCThread, IItem> thread, IMemberAccessor<IMCStackTrace, IItem> stackTrace, IMemberAccessor<String, IItem> threadState, IMemberAccessor<ITypedQuantity<TimestampUnit>, IItem> timestamp) {
            this.thread = thread;
            this.stackTrace = stackTrace;
            this.threadState = threadState;
            this.timestamp = timestamp;
        }

        public /* synthetic */ IItemFactory(IMemberAccessor thread, IMemberAccessor stackTrace, IMemberAccessor threadState, IMemberAccessor timestamp, DefaultConstructorMarker $constructor_marker) {
            this((IMemberAccessor<IMCThread, IItem>)thread, (IMemberAccessor<IMCStackTrace, IItem>)stackTrace, (IMemberAccessor<String, IItem>)threadState, (IMemberAccessor<ITypedQuantity<TimestampUnit>, IItem>)timestamp);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$IItemFactory$Companion;", "", "()V", "create", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$IItemFactory;", "event", "Lorg/openjdk/jmc/common/item/IItem;", "intellij.profiler.ultimate"})
        public static final class Companion {
            @NotNull
            public final IItemFactory create(@NotNull IItem event) {
                Object v2;
                IMemberAccessor stackTraceAccessor;
                IMemberAccessor threadAccessor;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    threadAccessor = JfrAttributes.EVENT_THREAD.getAccessor(event.getType());
                    stackTraceAccessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(event.getType());
                    IType iType = event.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)iType, (String)"event.type");
                    Iterable $this$firstOrNull$iv = iType.getAccessorKeys().keySet();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        IAccessorKey k = (IAccessorKey)element$iv;
                        boolean bl = false;
                        IAccessorKey iAccessorKey = k;
                        Intrinsics.checkNotNullExpressionValue((Object)iAccessorKey, (String)"k");
                        if (!Intrinsics.areEqual((Object)iAccessorKey.getIdentifier(), (Object)"state")) continue;
                        v2 = element$iv;
                        break block3;
                    }
                    v2 = null;
                }
                IAccessorKey stateAccessorKey = v2;
                IMemberAccessor stateAccessor = event.getType().getAccessor(stateAccessorKey);
                IMemberAccessor iMemberAccessor = JfrAttributes.START_TIME.getAccessor(event.getType());
                if (iMemberAccessor == null) {
                    iMemberAccessor = JfrAttributes.END_TIME.getAccessor(event.getType());
                }
                IMemberAccessor timestampAccessor = iMemberAccessor;
                boolean bl = threadAccessor != null && stackTraceAccessor != null && stateAccessor != null && timestampAccessor != null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Can't build DataAccessor: " + threadAccessor + ", " + stackTraceAccessor + ", " + stateAccessorKey + ", " + stateAccessor + ", " + timestampAccessor;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return new IItemFactory(threadAccessor, stackTraceAccessor, stateAccessor, timestampAccessor, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000e2\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001:\u0001\u000eB'\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$ArrayFactory;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$SampleFactory;", "", "", "stateIdx", "", "timeIdx", "threadIdx", "stackIdx", "(IIII)V", "get", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "source", "([Ljava/lang/Object;)Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$Sample;", "Companion", "intellij.profiler.ultimate"})
    private static final class ArrayFactory
    extends SampleFactory<Object[]> {
        private final int stateIdx;
        private final int timeIdx;
        private final int threadIdx;
        private final int stackIdx;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public Sample get(@NotNull Object[] source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Object object = source[this.stateIdx];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String state = (String)object;
            Object object2 = source[this.timeIdx];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openjdk.jmc.common.unit.ITypedQuantity<*>");
            }
            long timeMs = ((ITypedQuantity)object2).clampedLongValueIn((IUnit)UnitLookup.EPOCH_MS);
            Object object3 = source[this.threadIdx];
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openjdk.jmc.common.IMCThread");
            }
            IMCThread thread = (IMCThread)object3;
            Object object4 = source[this.stackIdx];
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openjdk.jmc.common.IMCStackTrace");
            }
            IMCStackTrace stack = (IMCStackTrace)object4;
            return new Sample(state, timeMs, this.createThread(thread), stack);
        }

        private ArrayFactory(int stateIdx, int timeIdx, int threadIdx, int stackIdx) {
            this.stateIdx = stateIdx;
            this.timeIdx = timeIdx;
            this.threadIdx = threadIdx;
            this.stackIdx = stackIdx;
        }

        public /* synthetic */ ArrayFactory(int stateIdx, int timeIdx, int threadIdx, int stackIdx, DefaultConstructorMarker $constructor_marker) {
            this(stateIdx, timeIdx, threadIdx, stackIdx);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$ArrayFactory$Companion;", "", "()V", "create", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$ArrayFactory;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "intellij.profiler.ultimate"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayFactory create(@NotNull List<ValueField> dataStructure) {
                int n;
                int threadIdx;
                int timeIdx;
                int stateIdx;
                block16: {
                    int n2;
                    block15: {
                        int n3;
                        int n4;
                        boolean bl;
                        int index$iv;
                        boolean $i$f$indexOfFirst;
                        List<ValueField> $this$indexOfFirst$iv;
                        block13: {
                            int n5;
                            block12: {
                                Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
                                List<ValueField> $this$indexOfFirst$iv2 = dataStructure;
                                boolean $i$f$indexOfFirst2 = false;
                                int index$iv2 = 0;
                                Iterator<ValueField> iterator2 = $this$indexOfFirst$iv2.iterator();
                                while (iterator2.hasNext()) {
                                    ValueField valueField;
                                    ValueField valueField2 = valueField = iterator2.next();
                                    boolean bl2 = false;
                                    if (Intrinsics.areEqual((Object)valueField2.getIdentifier(), (Object)"state")) {
                                        n5 = index$iv2;
                                        break block12;
                                    }
                                    ++index$iv2;
                                }
                                n5 = -1;
                            }
                            stateIdx = n5;
                            $this$indexOfFirst$iv = dataStructure;
                            $i$f$indexOfFirst = false;
                            index$iv = 0;
                            Iterator<ValueField> bl2 = $this$indexOfFirst$iv.iterator();
                            while (bl2.hasNext()) {
                                ValueField valueField;
                                ValueField valueField3 = valueField = bl2.next();
                                bl = false;
                                if (valueField3.matches(JfrAttributes.START_TIME)) {
                                    n4 = index$iv;
                                    break block13;
                                }
                                ++index$iv;
                            }
                            n4 = -1;
                        }
                        timeIdx = n3 = n4;
                        if (timeIdx == -1) {
                            int n6;
                            block14: {
                                $this$indexOfFirst$iv = dataStructure;
                                $i$f$indexOfFirst = false;
                                index$iv = 0;
                                Iterator<ValueField> iterator3 = $this$indexOfFirst$iv.iterator();
                                while (iterator3.hasNext()) {
                                    ValueField valueField;
                                    ValueField valueField4 = valueField = iterator3.next();
                                    bl = false;
                                    if (valueField4.matches(JfrAttributes.END_TIME)) {
                                        n6 = index$iv;
                                        break block14;
                                    }
                                    ++index$iv;
                                }
                                n6 = -1;
                            }
                            timeIdx = n3 = n6;
                        }
                        List<ValueField> $this$indexOfFirst$iv3 = dataStructure;
                        boolean $i$f$indexOfFirst3 = false;
                        boolean bl3 = false;
                        Iterator<ValueField> iterator4 = $this$indexOfFirst$iv3.iterator();
                        while (iterator4.hasNext()) {
                            void var7_19;
                            ValueField valueField;
                            ValueField it = valueField = iterator4.next();
                            boolean bl4 = false;
                            if (it.matches(JfrAttributes.EVENT_THREAD)) {
                                n2 = var7_19;
                                break block15;
                            }
                            ++var7_19;
                        }
                        n2 = -1;
                    }
                    threadIdx = n2;
                    List<ValueField> $this$indexOfFirst$iv = dataStructure;
                    boolean bl = false;
                    boolean bl5 = false;
                    Iterator<ValueField> iterator5 = $this$indexOfFirst$iv.iterator();
                    while (iterator5.hasNext()) {
                        void var8_29;
                        ValueField item$iv2;
                        ValueField it = item$iv2 = iterator5.next();
                        boolean bl6 = false;
                        if (it.matches(JfrAttributes.EVENT_STACKTRACE)) {
                            n = var8_29;
                            break block16;
                        }
                        ++var8_29;
                    }
                    n = -1;
                }
                int stackIdx = n;
                boolean bl = stateIdx != -1 && timeIdx != -1 && threadIdx != -1 && stackIdx != -1;
                boolean bl7 = false;
                boolean bl8 = false;
                if (!bl) {
                    boolean bl9 = false;
                    String string = "Can't build DataStructureReader: stateIdx=" + stateIdx + ", timeIdx=" + timeIdx + ", threadIdx=" + threadIdx + ", stackIdx=" + stackIdx;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return new ArrayFactory(stateIdx, timeIdx, threadIdx, stackIdx, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

