/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProviderKt;
import com.intellij.profiler.ultimate.jfr.JFRFileParser;
import com.intellij.profiler.ultimate.jfr.JFRProfilerData;
import com.intellij.profiler.ultimate.jfr.jmc.StreamModel;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.FlightRecordingLoader;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.IEventSinkFactory;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "helpId", "", "getHelpId", "()Ljava/lang/String;", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "ProfilerDataBuilder", "intellij.profiler.ultimate"})
public final class JFRFileParser
implements ProfilerDumpFileParser {
    @NotNull
    private final String helpId;
    private final Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        InputStream stream = IOToolkit.openUncompressedStream((File)file);
        EventArray[] events = null;
        ProfilerDataBuilder profilerDataBuilder = new ProfilerDataBuilder(this.project, indicator);
        try {
            List list = ParserExtensionRegistry.getParserExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ParserExtensionRegistry.getParserExtensions()");
            List extensions = CollectionsKt.plus((Collection)list, (Object)profilerDataBuilder);
            EventArray[] eventArrayArray = FlightRecordingLoader.loadStream((InputStream)stream, (List)extensions, (boolean)true, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)eventArrayArray, (String)"FlightRecordingLoader.lo\u2026, extensions, true, true)");
            events = eventArrayArray;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (OutOfMemoryError e) {
            ProfilerDumpFileParsingResult profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Failure(UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.memory", new Object[0]));
            return profilerDumpFileParsingResult;
        }
        catch (Throwable e) {
            if (e instanceof InvalidJfrFileException) {
                if (file.length() == 0L) {
                    ProfilerDumpFileParsingResult profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Failure(UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.file.empty", new Object[0]));
                    return profilerDumpFileParsingResult;
                }
                ProfilerDumpFileParsingResult profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Failure(UtilsKt.explain((Throwable)e, (String)UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.file.invalid.format", new Object[0])));
                return profilerDumpFileParsingResult;
            }
            JFRDumpParserProviderKt.access$getLOG$p().error(e);
            ProfilerDumpFileParsingResult profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Failure(UtilsKt.explain((Throwable)e, (String)UltimateProfilerBundleKt.profilerMessage("jfr.parser.result.failure.cant.parse", new Object[0])));
            return profilerDumpFileParsingResult;
        }
        finally {
            profilerDataBuilder.finish();
            IOToolkit.closeSilently((Closeable)stream);
        }
        indicator.checkCanceled();
        return (ProfilerDumpFileParsingResult)new Success(profilerDataBuilder.create(new StreamModel(events)));
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    public JFRFileParser(@Nullable Project project) {
        this.project = project;
        this.helpId = "procedures.profiler";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRFileParser$ProfilerDataBuilder;", "Lorg/openjdk/jmc/flightrecorder/parser/IParserExtension;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "builder", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData$JFRSamplingTreeBuilder;", "create", "Lcom/intellij/profiler/api/ProfilerData;", "model", "Lcom/intellij/profiler/ultimate/jfr/jmc/StreamModel;", "finish", "", "getEventSinkFactory", "Lorg/openjdk/jmc/flightrecorder/parser/IEventSinkFactory;", "subFactory", "getValueInterpretation", "", "eventTypeId", "", "fieldId", "intellij.profiler.ultimate"})
    public static final class ProfilerDataBuilder
    implements IParserExtension {
        private final JFRProfilerData.JFRSamplingTreeBuilder builder;
        private final ProgressIndicator indicator;

        @Nullable
        public Void getValueInterpretation(@Nullable String eventTypeId, @Nullable String fieldId) {
            return null;
        }

        @NotNull
        public IEventSinkFactory getEventSinkFactory(@NotNull IEventSinkFactory subFactory) {
            Intrinsics.checkNotNullParameter((Object)subFactory, (String)"subFactory");
            return new IEventSinkFactory(this, subFactory){
                private final /* synthetic */ IEventSinkFactory $$delegate_0;
                final /* synthetic */ ProfilerDataBuilder this$0;
                final /* synthetic */ IEventSinkFactory $subFactory;

                @NotNull
                public IEventSink create(@Nullable String identifier, @Nullable String label, @Nullable String[] category, @Nullable String description, @Nullable List<ValueField> dataStructure) {
                    IEventSink sink = this.$subFactory.create(identifier, label, category, description, dataStructure);
                    if (Intrinsics.areEqual((Object)"jdk.ExecutionSample", (Object)identifier)) {
                        ProfilerDataBuilder.access$getBuilder$p(this.this$0).setDataStructure(dataStructure);
                        return new IEventSink(this, sink){
                            final /* synthetic */ getEventSinkFactory.1 this$0;
                            final /* synthetic */ IEventSink $sink;

                            public final void addEvent(Object[] it) {
                                ProfilerDataBuilder.access$getIndicator$p(this.this$0.this$0).checkCanceled();
                                JFRProfilerData.JFRSamplingTreeBuilder jFRSamplingTreeBuilder = ProfilerDataBuilder.access$getBuilder$p(this.this$0.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                jFRSamplingTreeBuilder.addEvent(it);
                                this.$sink.addEvent(it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$sink = iEventSink;
                            }
                        };
                    }
                    IEventSink iEventSink = sink;
                    Intrinsics.checkNotNullExpressionValue((Object)iEventSink, (String)"sink");
                    return iEventSink;
                }
                {
                    this.this$0 = this$0;
                    this.$subFactory = $captured_local_variable$1;
                    this.$$delegate_0 = $captured_local_variable$1;
                }

                public void flush() {
                    this.$$delegate_0.flush();
                }
            };
        }

        public final void finish() {
            this.builder.finish();
        }

        @NotNull
        public final ProfilerData create(@NotNull StreamModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new JFRProfilerData(model, this.builder.getTree());
        }

        public ProfilerDataBuilder(@Nullable Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.indicator = indicator;
            this.builder = new JFRProfilerData.JFRSamplingTreeBuilder(project);
        }

        public static final /* synthetic */ JFRProfilerData.JFRSamplingTreeBuilder access$getBuilder$p(ProfilerDataBuilder $this) {
            return $this.builder;
        }

        public static final /* synthetic */ ProgressIndicator access$getIndicator$p(ProfilerDataBuilder $this) {
            return $this.indicator;
        }
    }
}

