/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.ProfilerRunnerSettings;
import com.intellij.profiler.ultimate.jfr.RecordingConfiguration;
import com.intellij.profiler.ultimate.jfr.configuration.JFRConfigurationState;
import com.intellij.profiler.ultimate.jfr.configuration.JFRStarter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J3\u0010\n\u001a\u00020\u000b\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J9\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010\u0019J;\u0010\u001a\u001a\u00020\u000b\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fR'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u00020\u0005\u00a2\u0006\u0002\b\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRConfigurationExtensionBase;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "()V", "profilerParametersKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProfilerParametersKey", "()Lcom/intellij/openapi/util/Key;", "doUpdateJavaParameters", "", "T", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "configuration", "settings", "Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;Lcom/intellij/execution/configurations/JavaParameters;)V", "isApplicableFor", "", "makeProfilerAgentParameters", "", "", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;Lcom/intellij/execution/configurations/JavaParameters;)Ljava/util/List;", "updateJavaParameters", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/Executor;)V", "Companion", "intellij.profiler.ultimate"})
public abstract class JFRConfigurationExtensionBase
extends JavaProfilerConfigurationExtension<RecordingConfiguration> {
    @NotNull
    private final Key<RecordingConfiguration> profilerParametersKey = RECORDING_CONFIGURATION_KEY;
    @NotNull
    public static final String ENABLE_JFR_PARAMETER = "-XX:+FlightRecorder";
    @NotNull
    public static final String START_JFR_PARAMETER = "-XX:StartFlightRecording";
    private static final String JFR_OPTIONS = "-XX:FlightRecorderOptions";
    private static final String UNLOCK_DIAGNOSTIC = "-XX:+UnlockDiagnosticVMOptions";
    private static final String DEBUG_NON_SAFEPOINTS = "-XX:+DebugNonSafepoints";
    private static final Logger LOG;
    private static final Key<RecordingConfiguration> RECORDING_CONFIGURATION_KEY;
    public static final Companion Companion;

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        return JFRStarter.INSTANCE.isApplicable(project) && JFRStarter.INSTANCE.canRun((RunProfile)configuration);
    }

    public final <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings, @NotNull Executor executor) {
        DefaultProfilerExecutorGroup defaultProfilerExecutorGroup;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                if (!(runnerSettings instanceof ProfilerRunnerSettings)) {
                    return;
                }
                defaultProfilerExecutorGroup = DefaultProfilerExecutorGroup.Companion.getInstance();
                if (defaultProfilerExecutorGroup == null) break block6;
                String string = executor.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executor.id");
                if ((defaultProfilerExecutorGroup = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)defaultProfilerExecutorGroup.getRegisteredSettings(string)) != null) break block7;
            }
            return;
        }
        DefaultProfilerExecutorGroup executorSettings = defaultProfilerExecutorGroup;
        ProfilerConfigurationState profilerConfigurationState = executorSettings.getState();
        if (!(profilerConfigurationState instanceof JFRConfigurationState)) {
            profilerConfigurationState = null;
        }
        JFRConfigurationState jFRConfigurationState = (JFRConfigurationState)profilerConfigurationState;
        if (jFRConfigurationState == null) {
            return;
        }
        JFRConfigurationState settings = jFRConfigurationState;
        this.doUpdateJavaParameters(configuration, settings, params);
    }

    protected <T extends RunConfigurationBase<?>> void doUpdateJavaParameters(@NotNull T configuration, @NotNull JFRConfigurationState settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<String> vmParameters = this.makeProfilerAgentParameters(configuration, settings, params);
        params.getVMParametersList().addAll(vmParameters);
    }

    @NotNull
    protected final <T extends RunConfigurationBase<?>> List<String> makeProfilerAgentParameters(@NotNull T configuration, @NotNull JFRConfigurationState settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.name");
        RecordingConfiguration recordingConfiguration = RecordingConfiguration.Companion.fromNameAndTime$default(RecordingConfiguration.Companion, string, 0L, null, 6, null);
        List<String> startParameters = recordingConfiguration.startCommand(settings.getStartSetting());
        List vmParameters = CollectionsKt.mutableListOf((Object[])new String[]{UNLOCK_DIAGNOSTIC, DEBUG_NON_SAFEPOINTS, ENABLE_JFR_PARAMETER, "-XX:StartFlightRecording=" + CollectionsKt.joinToString$default((Iterable)startParameters, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)});
        CharSequence charSequence = settings.getFlightRecorderOptions();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            vmParameters.add("-XX:FlightRecorderOptions=" + settings.getFlightRecorderOptions());
        }
        LOG.info("target run configuration: '" + configuration + "', target jdk: '" + params.getJdk() + "', appended vm parameters: " + vmParameters);
        configuration.putUserData(this.getProfilerConfigurationStateKey(), (Object)settings);
        configuration.putUserData(this.getProfilerParametersKey(), (Object)recordingConfiguration);
        return vmParameters;
    }

    @Override
    @NotNull
    protected Key<RecordingConfiguration> getProfilerParametersKey() {
        return this.profilerParametersKey;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JFRConfigurationExtensionBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        Key key = Key.create((String)"jfr.recording.configuration");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<RecordingConf\u2026recording.configuration\")");
        RECORDING_CONFIGURATION_KEY = key;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRConfigurationExtensionBase$Companion;", "", "()V", "DEBUG_NON_SAFEPOINTS", "", "ENABLE_JFR_PARAMETER", "JFR_OPTIONS", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RECORDING_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "kotlin.jvm.PlatformType", "START_JFR_PARAMETER", "UNLOCK_DIAGNOSTIC", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

