/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.NewProcessStartedWithProfilerCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.JFRConfigurationExtensionBase;
import com.intellij.profiler.ultimate.jfr.JFRProfilerProcess;
import com.intellij.profiler.ultimate.jfr.RecordingConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\nH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRConfigurationExtension;", "Lcom/intellij/profiler/ultimate/jfr/JFRConfigurationExtensionBase;", "()V", "attachToProcess", "", "profilerConfigurationState", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "profilerParameters", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "isApplicableFor", "", "configuration", "Companion", "intellij.profiler.ultimate"})
public final class JFRConfigurationExtension
extends JFRConfigurationExtensionBase {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return super.isApplicableFor(configuration) && configuration instanceof CommonJavaRunConfigurationParameters;
    }

    @Override
    protected void attachToProcess(@NotNull ProfilerConfigurationState profilerConfigurationState, @NotNull RecordingConfiguration profilerParameters, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)profilerConfigurationState, (String)"profilerConfigurationState");
        Intrinsics.checkNotNullParameter((Object)profilerParameters, (String)"profilerParameters");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler instanceof ExternalSystemProcessHandler) {
            return;
        }
        if (!(handler instanceof OSProcessHandler)) {
            LOG.error("unexpected process handler: '" + handler + '\'');
            throw (Throwable)new ExecutionException(UltimateProfilerBundleKt.profilerMessage("profiler.exception.cant.start", new Object[0]));
        }
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
        String string = runConfiguration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runConfiguration.name");
        JFRProfilerProcess profilerProcess = new JFRProfilerProcess(project, new NewProcessStartedWithProfilerCommunicator(string, (BaseOSProcessHandler)handler), profilerConfigurationState, profilerParameters, System.currentTimeMillis());
        this.openToolWindowAndReportStart((ProfilerProcess)profilerProcess, runConfiguration);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JFRConfigurationExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRConfigurationExtension$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

