/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.profiler.ultimate.jbonlymac.Statistics;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.JavaInterpreterCall;
import com.intellij.profiler.ultimate.model.JavaMethodCall;
import com.intellij.profiler.ultimate.model.UnknownMemoryJavaCall;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c2\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006%"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/JavaCalls;", "Lcom/intellij/profiler/ultimate/jbonlymac/Statistics;", "Lcom/intellij/profiler/ultimate/model/BaseJavaCall;", "_total", "", "_mapped", "_compiled", "_inlined", "_interpreter", "(IIIII)V", "compiled", "getCompiled", "()I", "inlined", "getInlined", "interpreter", "getInterpreter", "mapped", "getMapped", "total", "getTotal", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "update", "", "item", "intellij.profiler.ultimate"})
public final class JavaCalls
implements Statistics<BaseJavaCall> {
    private int _total;
    private int _mapped;
    private int _compiled;
    private int _inlined;
    private int _interpreter;

    public final int getTotal() {
        return this._total;
    }

    public final int getMapped() {
        return this._mapped;
    }

    public final int getCompiled() {
        return this._compiled;
    }

    public final int getInlined() {
        return this._inlined;
    }

    public final int getInterpreter() {
        return this._interpreter;
    }

    @Override
    public void update(@NotNull BaseJavaCall item) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        int n = this._total;
        this._total = n + 1;
        if (!(item instanceof UnknownMemoryJavaCall)) {
            n = this._mapped;
            this._mapped = n + 1;
        }
        if (item instanceof JavaInterpreterCall) {
            n = this._interpreter;
            this._interpreter = n + 1;
        }
        if (item instanceof JavaMethodCall) {
            n = this._compiled;
            this._compiled = n + 1;
            if (((JavaMethodCall)item).getInlined()) {
                n = this._inlined;
                this._inlined = n + 1;
            }
        }
    }

    public JavaCalls(int _total, int _mapped, int _compiled, int _inlined, int _interpreter) {
        this._total = _total;
        this._mapped = _mapped;
        this._compiled = _compiled;
        this._inlined = _inlined;
        this._interpreter = _interpreter;
    }

    public /* synthetic */ JavaCalls(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 0;
        }
        if ((n6 & 2) != 0) {
            n2 = 0;
        }
        if ((n6 & 4) != 0) {
            n3 = 0;
        }
        if ((n6 & 8) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 0;
        }
        this(n, n2, n3, n4, n5);
    }

    public JavaCalls() {
        this(0, 0, 0, 0, 0, 31, null);
    }

    @Override
    public void update(@NotNull Collection<? extends BaseJavaCall> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Statistics.DefaultImpls.update(this, items);
    }

    private final int component1() {
        return this._total;
    }

    private final int component2() {
        return this._mapped;
    }

    private final int component3() {
        return this._compiled;
    }

    private final int component4() {
        return this._inlined;
    }

    private final int component5() {
        return this._interpreter;
    }

    @NotNull
    public final JavaCalls copy(int _total, int _mapped, int _compiled, int _inlined, int _interpreter) {
        return new JavaCalls(_total, _mapped, _compiled, _inlined, _interpreter);
    }

    public static /* synthetic */ JavaCalls copy$default(JavaCalls javaCalls, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = javaCalls._total;
        }
        if ((n6 & 2) != 0) {
            n2 = javaCalls._mapped;
        }
        if ((n6 & 4) != 0) {
            n3 = javaCalls._compiled;
        }
        if ((n6 & 8) != 0) {
            n4 = javaCalls._inlined;
        }
        if ((n6 & 0x10) != 0) {
            n5 = javaCalls._interpreter;
        }
        return javaCalls.copy(n, n2, n3, n4, n5);
    }

    @NotNull
    public String toString() {
        return "JavaCalls(_total=" + this._total + ", _mapped=" + this._mapped + ", _compiled=" + this._compiled + ", _inlined=" + this._inlined + ", _interpreter=" + this._interpreter + ")";
    }

    public int hashCode() {
        return (((Integer.hashCode(this._total) * 31 + Integer.hashCode(this._mapped)) * 31 + Integer.hashCode(this._compiled)) * 31 + Integer.hashCode(this._inlined)) * 31 + Integer.hashCode(this._interpreter);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JavaCalls)) break block3;
                JavaCalls javaCalls = (JavaCalls)object;
                if (this._total != javaCalls._total || this._mapped != javaCalls._mapped || this._compiled != javaCalls._compiled || this._inlined != javaCalls._inlined || this._interpreter != javaCalls._interpreter) break block3;
            }
            return true;
        }
        return false;
    }
}

