/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.ultimate.jbonlymac.CompiledMethod;
import com.intellij.profiler.ultimate.jbonlymac.InlinedMethods;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRange;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangeWithData;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangesStorage;
import com.intellij.profiler.ultimate.jbonlymac.SingleMethod;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import com.intellij.profiler.ultimate.model.JavaMethodCall;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a \u0010\u000b\u001a\u0004\u0018\u00010\u0005*\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\nH\u0000\u001a\u001e\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\u0018\"\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildCompiledMethodsStorage", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethod;", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethodsStorage;", "Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;", "lines", "Lkotlin/sequences/Sequence;", "", "findBestReplace", "addr", "", "inMemoryRange", "", "range", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRange;", "parseCompiledMethod", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangeWithData;", "line", "readCompiledMethodsStorage", "file", "Ljava/io/File;", "CompiledMethodsStorage", "intellij.profiler.ultimate"})
public final class CompiledMethodsStorageKt {
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MemoryRangeWithData<CompiledMethod> parseCompiledMethod(@NotNull JavaCachingStackElementReader $this$parseCompiledMethod, @NotNull String line) {
        CompiledMethod compiledMethod;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$parseCompiledMethod), (String)"$this$parseCompiledMethod");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String start = StringsKt.substringBefore$default((String)line, (char)' ', null, (int)2, null);
        String string = line;
        int n = start.length() + 1;
        int n2 = 0;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String length = StringsKt.substringBefore$default((String)string2, (char)' ', null, (int)2, null);
        String string3 = line;
        n2 = start.length() + 1 + length.length() + 1;
        boolean bl = false;
        String string4 = string3.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        List methods = StringsKt.split$default((CharSequence)string4, (String[])new String[]{"->"}, (boolean)false, (int)0, (int)6, null);
        if (methods.size() > 1) {
            Collection<JavaMethodCall> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)methods, (int)1);
            BaseJavaCall baseJavaCall = JavaCachingStackElementReader.parseJavaMethodCall$default($this$parseCompiledMethod, (String)CollectionsKt.first((List)methods), false, 2, null);
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                JavaMethodCall javaMethodCall = $this$parseCompiledMethod.parseJavaMethodCall((String)it, true);
                collection.add(javaMethodCall);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            BaseJavaCall baseJavaCall2 = baseJavaCall;
            compiledMethod = new InlinedMethods(baseJavaCall2, list);
        } else {
            compiledMethod = new SingleMethod($this$parseCompiledMethod.parseJavaCall((String)CollectionsKt.first((List)methods)));
        }
        CompiledMethod method = compiledMethod;
        String string6 = length;
        bl = false;
        return new MemoryRangeWithData<CompiledMethod>(UtilsKt.parseHexLong((String)start), Long.parseLong(string6), method);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CompiledMethod findBestReplace(@NotNull MemoryRangesStorage<? extends CompiledMethod> $this$findBestReplace, long addr) {
        Object v0;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findBestReplace, (String)"$this$findBestReplace");
        Iterable $this$filter$iv = $this$findBestReplace.getRangesAddressBelongsTo(addr);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemoryRangeWithData it = (MemoryRangeWithData)element$iv$iv;
            boolean bl = false;
            if (!CompiledMethodsStorageKt.inMemoryRange(addr, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minBy$iv = (List)destination$iv$iv;
        boolean $i$f$minBy = false;
        Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v0 = minElem$iv$iv;
            } else {
                MemoryRangeWithData it = (MemoryRangeWithData)minElem$iv$iv;
                boolean bl = false;
                long minValue$iv$iv = it.getLength();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    MemoryRangeWithData it2 = (MemoryRangeWithData)e$iv$iv;
                    $i$a$-minBy-CompiledMethodsStorageKt$findBestReplace$2 = false;
                    long v$iv$iv = it2.getLength();
                    if (minValue$iv$iv <= v$iv$iv) continue;
                    minElem$iv$iv = e$iv$iv;
                    minValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v0 = minElem$iv$iv;
            }
        }
        MemoryRangeWithData memoryRangeWithData = v0;
        return memoryRangeWithData != null ? (CompiledMethod)memoryRangeWithData.getData() : null;
    }

    @NotNull
    public static final MemoryRangesStorage<CompiledMethod> buildCompiledMethodsStorage(@NotNull JavaCachingStackElementReader $this$buildCompiledMethodsStorage, @NotNull Sequence<String> lines) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$buildCompiledMethodsStorage), (String)"$this$buildCompiledMethodsStorage");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        boolean bl = false;
        List compiledMethods = new ArrayList();
        Sequence<String> $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl2 = false;
            try {
                Collection collection = compiledMethods;
                MemoryRangeWithData<CompiledMethod> memoryRangeWithData = CompiledMethodsStorageKt.parseCompiledMethod($this$buildCompiledMethodsStorage, line);
                boolean bl3 = false;
                collection.add(memoryRangeWithData);
            }
            catch (Exception e) {
                LOG.info("while parsing `" + line + '`', (Throwable)e);
            }
        }
        return new MemoryRangesStorage<CompiledMethod>(compiledMethods, 0, 2, null);
    }

    @NotNull
    public static final MemoryRangesStorage<CompiledMethod> readCompiledMethodsStorage(@NotNull JavaCachingStackElementReader $this$readCompiledMethodsStorage, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$readCompiledMethodsStorage), (String)"$this$readCompiledMethodsStorage");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object = file2;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        object2 = new FileInputStream((File)object2);
        bl3 = false;
        object = new InputStreamReader((InputStream)object2, charset);
        bl2 = false;
        return CompiledMethodsStorageKt.buildCompiledMethodsStorage($this$readCompiledMethodsStorage, (Sequence<String>)TextStreamsKt.lineSequence((BufferedReader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n))));
    }

    public static final boolean inMemoryRange(long $this$inMemoryRange, @NotNull MemoryRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return range.getStart() <= $this$inMemoryRange && $this$inMemoryRange < range.getEnd();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MemoryRangesStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

