/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitor;
import com.intellij.profiler.ultimate.hprof.visitors.ReferenceConsumer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.LongToIntFunction;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J_\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001eJ(\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/ReferenceVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "classMap", "Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "remapId", "Ljava/util/function/LongToIntFunction;", "consumer", "Lcom/intellij/profiler/ultimate/hprof/visitors/ReferenceConsumer;", "(Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;Ljava/util/function/LongToIntFunction;Lcom/intellij/profiler/ultimate/hprof/visitors/ReferenceConsumer;)V", "getConsumer", "()Lcom/intellij/profiler/ultimate/hprof/visitors/ReferenceConsumer;", "fields", "Ljava/util/ArrayList;", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "Lkotlin/collections/ArrayList;", "preVisit", "", "visitClassDump", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "Companion", "intellij.profiler.ultimate"})
public final class ReferenceVisitor
extends HProfVisitor {
    private final ArrayList<InstanceFieldEntry> fields;
    private final ClassVisitor classMap;
    private final LongToIntFunction remapId;
    @NotNull
    private final ReferenceConsumer consumer;
    public static final Companion Companion = new Companion(null);

    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        int parent = this.remapId.applyAsInt(classId);
        if (parent < 0) {
            return;
        }
        for (StaticFieldEntry field : staticFields) {
            int child;
            if (field.getType() != Type.OBJECT || field.getValue() == 0L || (child = this.remapId.applyAsInt(field.getValue())) < 0) continue;
            this.consumer.consume(parent, child);
        }
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        int parent = this.remapId.applyAsInt(arrayObjectId);
        if (parent < 0) {
            return;
        }
        for (long reference : objects) {
            int child;
            if (reference == 0L || (child = this.remapId.applyAsInt(reference)) < 0) continue;
            this.consumer.consume(parent, child);
        }
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int parent = this.remapId.applyAsInt(objectId);
        if (parent < 0) {
            return;
        }
        Intrinsics.checkNotNull((Object)this.classMap.get(classObjectId));
        int offset = 0;
        for (HprofClass info = v25218; info != null; info = info.getSupertype()) {
            for (InstanceFieldEntry field : info.getInstanceFields()) {
                this.fields.add(field);
            }
        }
        boolean isReferenceClass = false;
        for (InstanceFieldEntry field : this.fields) {
            if (field.getType() == Type.OBJECT) {
                long ref = bytes.getLong(offset);
                boolean isReferenceField = false;
                if (ref != 0L) {
                    int child = this.remapId.applyAsInt(ref);
                    if (child < 0) continue;
                    this.consumer.consume(parent, child);
                }
                offset += this.classMap.getSizeOfID();
                continue;
            }
            offset += field.getType().getSize();
        }
        this.fields.clear();
    }

    @NotNull
    public final ReferenceConsumer getConsumer() {
        return this.consumer;
    }

    public ReferenceVisitor(@NotNull ClassVisitor classMap, @NotNull LongToIntFunction remapId, @NotNull ReferenceConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)((Object)classMap), (String)"classMap");
        Intrinsics.checkNotNullParameter((Object)remapId, (String)"remapId");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.classMap = classMap;
        this.remapId = remapId;
        this.consumer = consumer;
        this.fields = new ArrayList(111);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/ReferenceVisitor$Companion;", "", "()V", "accept", "", "nextObjectId", "", "newPosition", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "visitor", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "intellij.profiler.ultimate"})
    public static final class Companion {
        @Deprecated(message="Do not access to heap dump directly")
        public final void accept(long nextObjectId, long newPosition, @NotNull HProfEventBasedParser parser2, @NotNull HProfVisitor visitor2) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            boolean bl = newPosition != 0L;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Cannot find object with id=" + nextObjectId + " in index";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            parser2.getBuffer().position(newPosition);
            int tag = parser2.getBuffer().getUnsignedByte();
            parser2.acceptHeapDumpRecord(HeapDumpRecordType.Companion.fromInt(tag), visitor2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

