/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.visitors.ObjectConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J_\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ(\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\bH\u0002J(\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,H\u0016J0\u0010-\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/ObjectVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "hprof", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "consumer", "Lcom/intellij/profiler/ultimate/hprof/visitors/ObjectConsumer;", "currentOffset", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;Lcom/intellij/profiler/ultimate/hprof/visitors/ObjectConsumer;Lkotlin/jvm/functions/Function1;)V", "fieldCount", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "postVisit", "", "preVisit", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitDump", "objectId", "objectClassId", "objectCount", "shallowSize", "visitInstanceDump", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "intellij.profiler.ultimate"})
public class ObjectVisitor
extends HProfVisitor {
    private final Long2ObjectOpenHashMap<Integer> fieldCount;
    private final HprofDump hprof;
    private final ObjectConsumer consumer;
    private final Function1<ObjectVisitor, Long> currentOffset;

    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
    }

    private final void visitDump(long objectId, long objectClassId, int objectCount, long shallowSize) {
        this.consumer.consume(objectId, objectClassId, objectCount, shallowSize, ((Number)this.currentOffset.invoke((Object)this)).longValue());
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
        this.visitDump(arrayObjectId, this.hprof.getClasses().getClassForType(elementType), (int)numberOfElements, numberOfElements * (long)elementType.getSize() + (long)24);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        this.visitDump(classId, -1L, staticFields.length, 0L);
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.visitDump(arrayObjectId, arrayClassObjectId, objects.length, (long)objects.length * (long)this.hprof.getClasses().getSizeOfID() + 24L);
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        HprofClass hprofClass = this.hprof.getClasses().get(classObjectId);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass info = hprofClass;
        Integer n2 = (Integer)this.fieldCount.get(classObjectId);
        if (n2 != null) {
            n = n2;
        } else {
            ObjectVisitor objectVisitor = this;
            boolean bl = false;
            boolean bl2 = false;
            ObjectVisitor it = objectVisitor;
            boolean bl3 = false;
            int totalFields = 0;
            Iterable $this$forEach$iv = this.hprof.getClasses().getClassHierarchy(classObjectId);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HprofClass it2 = (HprofClass)element$iv;
                boolean bl4 = false;
                totalFields += it2.getInstanceFields().length;
            }
            this.fieldCount.put(classObjectId, (Object)totalFields);
            n = totalFields;
        }
        int totalFields = n;
        this.visitDump(objectId, classObjectId, totalFields, info.getInstanceSize() + (long)16);
    }

    public void postVisit() {
        this.fieldCount.clear();
    }

    public ObjectVisitor(@NotNull HprofDump hprof, @NotNull ObjectConsumer consumer, @NotNull Function1<? super ObjectVisitor, Long> currentOffset) {
        Intrinsics.checkNotNullParameter((Object)hprof, (String)"hprof");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(currentOffset, (String)"currentOffset");
        this.hprof = hprof;
        this.consumer = consumer;
        this.currentOffset = currentOffset;
        this.fieldCount = new Long2ObjectOpenHashMap();
    }

    public /* synthetic */ ObjectVisitor(HprofDump hprofDump, ObjectConsumer objectConsumer, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(hprofDump, objectConsumer, (Function1<? super ObjectVisitor, Long>)function1);
    }
}

