/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.impl.HprofArray;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.impl.HprofObject;
import com.intellij.profiler.ultimate.hprof.impl.HprofRecord;
import com.intellij.profiler.ultimate.hprof.utils.BBUtils;
import com.intellij.profiler.ultimate.hprof.utils.IntList;
import com.intellij.profiler.ultimate.hprof.utils.LongBufferUtils;
import com.intellij.profiler.ultimate.hprof.utils.LongList;
import com.intellij.profiler.ultimate.hprof.utils.WriteOnceFile;
import com.intellij.profiler.ultimate.hprof.visitors.IndexFileVisitorKt;
import com.intellij.profiler.ultimate.hprof.visitors.ObjectConsumer;
import com.intellij.profiler.ultimate.hprof.visitors.ObjectVisitor;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001YB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u001a\u0010\u001b\u001a\u00020\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001dJ\"\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001dJ$\u0010\u001b\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0014\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020\u00170\u001dJ\u0094\u0001\u0010#\u001a\u00020\u00192\u008b\u0001\u0010\u001c\u001a\u0086\u0001\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00170$J\u000e\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020)J\u0010\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010-\u001a\u00020 J\u0010\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020)J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020)J\u000e\u00102\u001a\u00020)2\u0006\u0010-\u001a\u00020 J\u000e\u00103\u001a\u00020 2\u0006\u0010+\u001a\u00020)J\u000e\u00104\u001a\u00020 2\u0006\u0010+\u001a\u00020)J\b\u00105\u001a\u00020\u0017H\u0002J\u0006\u00106\u001a\u00020\u0017J\u0012\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020)H\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u0010-\u001a\u00020 H\u0002JI\u00107\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u0010\n\u001a\u00020 2\u0006\u0010\f\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020 2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020\u0019H\u0016J\b\u0010;\u001a\u00020\u0019H\u0016J\u0016\u0010<\u001a\u00020\u00192\u0006\u0010+\u001a\u00020)2\u0006\u0010=\u001a\u00020 J\u000e\u0010>\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u0017J_\u0010?\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020 2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0E2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0EH\u0016\u00a2\u0006\u0002\u0010KJ(\u0010L\u001a\u00020\u00192\u0006\u0010-\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010M\u001a\u00020 2\u0006\u0010N\u001a\u00020OH\u0016J(\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010R\u001a\u00020 2\u0006\u0010!\u001a\u00020SH\u0016J0\u0010T\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010U\u001a\u00020 2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020OH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "Ljava/lang/AutoCloseable;", "folder", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;)V", "classes", "Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "count", "Lcom/intellij/profiler/ultimate/hprof/utils/IntList;", "offsets", "remap", "retained", "shallow", "visitor", "Lcom/intellij/profiler/ultimate/hprof/visitors/ObjectVisitor;", "wereThereFiles", "", "Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$Files;", "", "close", "", "deleteFiles", "forEachObject", "consumer", "Lkotlin/Function1;", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "classId", "", "objects", "Lkotlin/collections/LongIterator;", "forEachRecord", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "id", "offset", "", "getClassId", "position", "getObjectById", "objectId", "getObjectByIndex", "objectIndex", "getObjectId", "remapId", "getRemapId", "getRetainedSize", "getShallowSize", "isAllFilesExists", "isRetainedSizeCalculated", "newObject", "isArray", "(JJJIJJLjava/lang/Boolean;)Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "postVisit", "preVisit", "setRetainedSize", "value", "setRetainedSizeCalculated", "visitClassDump", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "Files", "intellij.profiler.ultimate"})
public final class IndexFileVisitor
extends HProfVisitor
implements AutoCloseable {
    private LongList remap;
    private LongList offsets;
    private LongList classes;
    private IntList count;
    private LongList shallow;
    private LongList retained;
    private final Map<Files, Boolean> wereThereFiles;
    private ObjectVisitor visitor;
    private final Path folder;
    private final ProgressIndicator indicator;
    private final HprofDump dump;

    @Nullable
    public final HprofObject getObjectById(long objectId) {
        return this.newObject(objectId);
    }

    @Nullable
    public final HprofObject getObjectByIndex(int objectIndex) {
        return this.newObject(objectIndex);
    }

    public final int getRemapId(long objectId) {
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        return IndexFileVisitorKt.access$find(longList, objectId);
    }

    public final long getObjectId(int remapId) {
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        return longList.get(remapId);
    }

    public final long getClassId(int position) {
        LongList longList = this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        return longList.get(position);
    }

    public final long getShallowSize(int position) {
        LongList longList = this.shallow;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
        }
        return longList.get(position);
    }

    public final boolean isRetainedSizeCalculated() {
        return this.retained != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRetainedSizeCalculated(boolean value) {
        if (value && this.retained == null) {
            void $this$with;
            Path path = Files.RETAINED.resolve(this.folder);
            boolean bl = false;
            boolean bl2 = false;
            Path path2 = path;
            IndexFileVisitor indexFileVisitor = this;
            boolean bl3 = false;
            LongList longList = this.remap;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            }
            LongList.FileBuffer fileBuffer = new LongList.FileBuffer(longList.limit(), (Path)$this$with, Arrays.copyOf(BBUtils.READ_WRITE, BBUtils.READ_WRITE.length));
            indexFileVisitor.retained = fileBuffer;
        }
        if (!value && this.retained != null) {
            try {
                PathKt.delete$default((Path)Files.RETAINED.resolve(this.folder), (boolean)false, (int)1, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.retained = null;
        }
    }

    public final long getRetainedSize(int position) {
        LongList longList = this.retained;
        return longList != null ? longList.get(position) : 0L;
    }

    public final void setRetainedSize(int position, long value) {
        block0: {
            this.setRetainedSizeCalculated(true);
            LongList longList = this.retained;
            if (longList == null) break block0;
            longList.put(position, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachRecord(@NotNull Function6<? super Long, ? super Long, ? super Long, ? super Integer, ? super Long, ? super Long, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int n = 0;
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        int n2 = longList.limit();
        while (n < n2) {
            void i;
            LongList longList2 = this.remap;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            }
            Long l = longList2.get((int)i);
            LongList longList3 = this.offsets;
            if (longList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            }
            Long l2 = longList3.get((int)i);
            LongList longList4 = this.classes;
            if (longList4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            }
            Long l3 = longList4.get((int)i);
            IntList intList = this.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
            }
            Integer n3 = intList.get((int)i);
            LongList longList5 = this.shallow;
            if (longList5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
            }
            LongList longList6 = this.retained;
            consumer.invoke((Object)l, (Object)l2, (Object)l3, (Object)n3, (Object)longList5.get((int)i), (Object)(longList6 != null ? longList6.get((int)i) : 0L));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachObject(@NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int n = 0;
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        int n2 = longList.limit();
        while (n < n2) {
            void i;
            LongList longList2 = this.remap;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            }
            long l = longList2.get((int)i);
            LongList longList3 = this.offsets;
            if (longList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            }
            long l2 = longList3.get((int)i);
            LongList longList4 = this.classes;
            if (longList4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            }
            long l3 = longList4.get((int)i);
            IntList intList = this.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
            }
            int n3 = intList.get((int)i);
            LongList longList5 = this.shallow;
            if (longList5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
            }
            LongList longList6 = this.retained;
            if (!((Boolean)consumer.invoke((Object)IndexFileVisitor.newObject$default(this, l, l2, l3, n3, longList5.get((int)i), longList6 != null ? longList6.get((int)i) : 0L, null, 64, null))).booleanValue()) break;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachObject(long classId, @NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        HprofClass hprofClass = this.dump.getClasses().get(classId);
        boolean isArray = hprofClass != null && hprofClass.isArray();
        int n = 0;
        LongList longList = this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        int n2 = longList.limit();
        while (n < n2) {
            void i;
            long clazz;
            LongList longList2 = this.classes;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            }
            if (classId == (clazz = longList2.get((int)i))) {
                LongList longList3 = this.remap;
                if (longList3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                }
                long l = longList3.get((int)i);
                LongList longList4 = this.offsets;
                if (longList4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                }
                long l2 = longList4.get((int)i);
                IntList intList = this.count;
                if (intList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                }
                int n3 = intList.get((int)i);
                LongList longList5 = this.shallow;
                if (longList5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
                }
                LongList longList6 = this.retained;
                if (!((Boolean)consumer.invoke((Object)this.newObject(l, l2, classId, n3, longList5.get((int)i), longList6 != null ? longList6.get((int)i) : 0L, isArray))).booleanValue()) break;
            }
            ++i;
        }
    }

    public final void forEachObject(@NotNull LongIterator objects, @NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        while (objects.hasNext()) {
            boolean res;
            boolean bl;
            int id;
            long objectId = objects.nextLong();
            LongList longList = this.remap;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            }
            if ((id = IndexFileVisitorKt.access$find(longList, objectId)) >= 0) {
                LongList longList2 = this.remap;
                if (longList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                }
                long l = longList2.get(id);
                LongList longList3 = this.offsets;
                if (longList3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                }
                long l2 = longList3.get(id);
                LongList longList4 = this.classes;
                if (longList4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                }
                long l3 = longList4.get(id);
                IntList intList = this.count;
                if (intList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                }
                int n = intList.get(id);
                LongList longList5 = this.shallow;
                if (longList5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
                }
                LongList longList6 = this.retained;
                bl = (Boolean)consumer.invoke((Object)IndexFileVisitor.newObject$default(this, l, l2, l3, n, longList5.get(id), longList6 != null ? longList6.get(id) : 0L, null, 64, null));
            } else {
                bl = (Boolean)consumer.invoke(null);
            }
            if (res = bl) continue;
            break;
        }
    }

    private final HprofObject newObject(long objectId) {
        int id;
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        if ((id = IndexFileVisitorKt.access$find(longList, objectId)) < 0) {
            return null;
        }
        LongList longList2 = this.offsets;
        if (longList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        long l = longList2.get(id);
        LongList longList3 = this.classes;
        if (longList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        long l2 = longList3.get(id);
        IntList intList = this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
        }
        int n = intList.get(id);
        LongList longList4 = this.shallow;
        if (longList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
        }
        LongList longList5 = this.retained;
        return IndexFileVisitor.newObject$default(this, objectId, l, l2, n, longList4.get(id), longList5 != null ? longList5.get(id) : 0L, null, 64, null);
    }

    private final HprofObject newObject(int objectIndex) {
        if (objectIndex < 0) {
            return null;
        }
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
        }
        long l = longList.get(objectIndex);
        LongList longList2 = this.offsets;
        if (longList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        long l2 = longList2.get(objectIndex);
        LongList longList3 = this.classes;
        if (longList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        long l3 = longList3.get(objectIndex);
        IntList intList = this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
        }
        int n = intList.get(objectIndex);
        LongList longList4 = this.shallow;
        if (longList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
        }
        LongList longList5 = this.retained;
        return IndexFileVisitor.newObject$default(this, l, l2, l3, n, longList4.get(objectIndex), longList5 != null ? longList5.get(objectIndex) : 0L, null, 64, null);
    }

    private final HprofObject newObject(long id, long offset, long classes2, int count, long shallow, long retained, Boolean isArray) {
        Boolean bl = isArray;
        if (bl == null) {
            HprofClass hprofClass = this.dump.getClasses().get(classes2);
            bl = hprofClass != null ? Boolean.valueOf(hprofClass.isArray()) : null;
        }
        return Intrinsics.areEqual((Object)bl, (Object)true) ? (HprofObject)new HprofArray(id, classes2, count, shallow, retained, null, offset, this.dump) : (HprofObject)new HprofRecord(id, classes2, count, shallow, retained, null, offset, this.dump);
    }

    static /* synthetic */ HprofObject newObject$default(IndexFileVisitor indexFileVisitor, long l, long l2, long l3, int n, long l4, long l5, Boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = null;
        }
        return indexFileVisitor.newObject(l, l2, l3, n, l4, l5, bl);
    }

    public void preVisit() {
        this.disableAll();
        this.wereThereFiles.clear();
        Files[] $this$forEach$iv = Files.values();
        boolean $i$f$forEach = false;
        Files[] filesArray = $this$forEach$iv;
        int n = filesArray.length;
        for (int i = 0; i < n; ++i) {
            Files element$iv;
            Files it = element$iv = filesArray[i];
            boolean bl = false;
            this.wereThereFiles.put(it, PathKt.exists((Path)it.resolve(this.folder)));
        }
        if (!this.isAllFilesExists()) {
            WriteOnceFile remap = new WriteOnceFile(Files.REMAP.resolve(this.folder));
            WriteOnceFile classes2 = new WriteOnceFile(Files.CLASSES.resolve(this.folder));
            WriteOnceFile offsets = new WriteOnceFile(Files.OFFSETS.resolve(this.folder));
            WriteOnceFile count = new WriteOnceFile(Files.COUNT.resolve(this.folder));
            WriteOnceFile shallow = new WriteOnceFile(Files.SHALLOW.resolve(this.folder));
            this.visitor = new ObjectVisitor(this, remap, offsets, classes2, count, shallow, this.dump, new ObjectConsumer(remap, classes2, offsets, count, shallow){
                final /* synthetic */ WriteOnceFile $remap;
                final /* synthetic */ WriteOnceFile $classes;
                final /* synthetic */ WriteOnceFile $offsets;
                final /* synthetic */ WriteOnceFile $count;
                final /* synthetic */ WriteOnceFile $shallow;

                public final void consume(long objectId, long classId, int elementCount, long shallowSize, long offset) {
                    this.$remap.putLong(objectId);
                    this.$classes.putLong(classId);
                    this.$offsets.putLong(offset);
                    this.$count.putInt(elementCount);
                    this.$shallow.putLong(shallowSize);
                }
                {
                    this.$remap = writeOnceFile;
                    this.$classes = writeOnceFile2;
                    this.$offsets = writeOnceFile3;
                    this.$count = writeOnceFile4;
                    this.$shallow = writeOnceFile5;
                }
            }, (Function1)new Function1<ObjectVisitor, Long>(this){
                final /* synthetic */ IndexFileVisitor this$0;

                public final long invoke(@NotNull ObjectVisitor $receiver) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$receiver), (String)"$receiver");
                    return this.this$0.getVisitorContext().getCurrentHeapRecordOffset();
                }
                {
                    this.this$0 = indexFileVisitor;
                    super(1);
                }
            }){
                final /* synthetic */ IndexFileVisitor this$0;
                final /* synthetic */ WriteOnceFile $remap;
                final /* synthetic */ WriteOnceFile $offsets;
                final /* synthetic */ WriteOnceFile $classes;
                final /* synthetic */ WriteOnceFile $count;
                final /* synthetic */ WriteOnceFile $shallow;

                public void postVisit() {
                    super.postVisit();
                    this.$remap.close();
                    this.$offsets.close();
                    this.$classes.close();
                    this.$count.close();
                    this.$shallow.close();
                }
                {
                    this.this$0 = this$0;
                    this.$remap = $captured_local_variable$1;
                    this.$offsets = $captured_local_variable$2;
                    this.$classes = $captured_local_variable$3;
                    this.$count = $captured_local_variable$4;
                    this.$shallow = $captured_local_variable$5;
                    super($super_call_param$6, $super_call_param$7, (Function1<? super ObjectVisitor, Long>)$super_call_param$8);
                }
            };
        }
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitPrimitiveArrayDump(arrayObjectId, stackTraceSerialNumber, numberOfElements, elementType, primitiveArrayData);
        }
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
            Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
            Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitClassDump(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields);
        }
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitObjectArrayDump(arrayObjectId, stackTraceSerialNumber, arrayClassObjectId, objects);
        }
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitInstanceDump(objectId, stackTraceSerialNumber, classObjectId, bytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postVisit() {
        Path $this$with;
        boolean isReadOnly = this.visitor == null;
        StandardOpenOption[] options = isReadOnly ? BBUtils.READ_ONLY : BBUtils.READ_WRITE;
        ObjectVisitor objectVisitor = this.visitor;
        if (objectVisitor != null) {
            objectVisitor.postVisit();
        }
        this.visitor = null;
        Path path = Files.REMAP.resolve(this.folder);
        boolean bl = false;
        int n = 0;
        Path path2 = path;
        IndexFileVisitor indexFileVisitor = this;
        boolean bl2 = false;
        Object object = new LongList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)8), $this$with, Arrays.copyOf(options, options.length));
        indexFileVisitor.remap = (LongList)object;
        path = Files.OFFSETS.resolve(this.folder);
        bl = false;
        n = 0;
        $this$with = path;
        indexFileVisitor = this;
        boolean bl3 = false;
        object = new LongList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)8), $this$with, Arrays.copyOf(options, options.length));
        indexFileVisitor.offsets = (LongList)object;
        path = Files.CLASSES.resolve(this.folder);
        bl = false;
        n = 0;
        $this$with = path;
        indexFileVisitor = this;
        boolean bl4 = false;
        object = new LongList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)8), $this$with, Arrays.copyOf(options, options.length));
        indexFileVisitor.classes = (LongList)object;
        path = Files.COUNT.resolve(this.folder);
        bl = false;
        n = 0;
        $this$with = path;
        indexFileVisitor = this;
        boolean bl5 = false;
        object = new IntList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)4), $this$with, Arrays.copyOf(options, options.length));
        indexFileVisitor.count = (IntList)object;
        path = Files.SHALLOW.resolve(this.folder);
        bl = false;
        n = 0;
        $this$with = path;
        indexFileVisitor = this;
        boolean bl6 = false;
        object = new LongList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)8), $this$with, Arrays.copyOf(options, options.length));
        indexFileVisitor.shallow = (LongList)object;
        Path retainedFile = Files.RETAINED.resolve(this.folder);
        if (PathKt.exists((Path)retainedFile)) {
            bl = false;
            n = 0;
            $this$with = retainedFile;
            indexFileVisitor = this;
            boolean bl7 = false;
            object = new LongList.FileBuffer((int)(PathKt.size((Path)$this$with) / (long)8), $this$with, Arrays.copyOf(options, options.length));
            indexFileVisitor.retained = (LongList)object;
        }
        if (!isReadOnly) {
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator != null) {
                progressIndicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.save", new Object[0]));
            }
            HprofClass hprofClass = this.dump.getClasses().get(this.dump.getClasses().getIdOfClassClass());
            Intrinsics.checkNotNull((Object)hprofClass);
            HprofClass clazz = hprofClass;
            n = 0;
            int n2 = this.dump.getClasses().getClasses().size();
            while (n < n2) {
                void i;
                LongList longList = this.classes;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                }
                longList.put((int)i, clazz.getId());
                LongList longList2 = this.shallow;
                if (longList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
                }
                longList2.put((int)i, clazz.getInstanceSize() + (long)16);
                ++i;
            }
            LongList longList = this.remap;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            }
            LongBufferUtils.sort(longList, this.indicator, new LongBufferUtils.SwapConsumer(this){
                final /* synthetic */ IndexFileVisitor this$0;

                public final void accept(int left, int right) {
                    block0: {
                        IndexFileVisitor.access$getClasses$p(this.this$0).swap(left, right);
                        IndexFileVisitor.access$getOffsets$p(this.this$0).swap(left, right);
                        IndexFileVisitor.access$getCount$p(this.this$0).swap(left, right);
                        IndexFileVisitor.access$getShallow$p(this.this$0).swap(left, right);
                        LongList longList = IndexFileVisitor.access$getRetained$p(this.this$0);
                        if (longList == null) break block0;
                        longList.swap(left, right);
                    }
                }
                {
                    this.this$0 = indexFileVisitor;
                }
            });
        }
    }

    @Override
    public void close() {
    }

    public final void deleteFiles() throws IOException {
        Files[] $this$forEach$iv = Files.values();
        boolean $i$f$forEach = false;
        Files[] filesArray = $this$forEach$iv;
        int n = filesArray.length;
        for (int i = 0; i < n; ++i) {
            Files element$iv;
            Files it = element$iv = filesArray[i];
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)this.wereThereFiles.get((Object)it), (Object)true) ^ true)) continue;
            PathKt.delete$default((Path)it.resolve(this.folder), (boolean)false, (int)1, null);
        }
    }

    private final boolean isAllFilesExists() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = CollectionsKt.listOf((Object[])new Files[]{Files.REMAP, Files.CLASSES, Files.OFFSETS, Files.COUNT, Files.SHALLOW});
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Files it = (Files)((Object)element$iv);
                    boolean bl2 = false;
                    Boolean bl3 = this.wereThereFiles.get((Object)it);
                    if (bl3 != null ? bl3 : false) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public IndexFileVisitor(@NotNull Path folder, @Nullable ProgressIndicator indicator, @NotNull HprofDump dump) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.folder = folder;
        this.indicator = indicator;
        this.dump = dump;
        boolean bl = false;
        this.wereThereFiles = new LinkedHashMap();
    }

    public static final /* synthetic */ LongList access$getClasses$p(IndexFileVisitor $this) {
        LongList longList = $this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        return longList;
    }

    public static final /* synthetic */ void access$setClasses$p(IndexFileVisitor $this, LongList longList) {
        $this.classes = longList;
    }

    public static final /* synthetic */ LongList access$getOffsets$p(IndexFileVisitor $this) {
        LongList longList = $this.offsets;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        return longList;
    }

    public static final /* synthetic */ void access$setOffsets$p(IndexFileVisitor $this, LongList longList) {
        $this.offsets = longList;
    }

    public static final /* synthetic */ IntList access$getCount$p(IndexFileVisitor $this) {
        IntList intList = $this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
        }
        return intList;
    }

    public static final /* synthetic */ void access$setCount$p(IndexFileVisitor $this, IntList intList) {
        $this.count = intList;
    }

    public static final /* synthetic */ LongList access$getShallow$p(IndexFileVisitor $this) {
        LongList longList = $this.shallow;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shallow");
        }
        return longList;
    }

    public static final /* synthetic */ void access$setShallow$p(IndexFileVisitor $this, LongList longList) {
        $this.shallow = longList;
    }

    public static final /* synthetic */ LongList access$getRetained$p(IndexFileVisitor $this) {
        return $this.retained;
    }

    public static final /* synthetic */ void access$setRetained$p(IndexFileVisitor $this, LongList longList) {
        $this.retained = longList;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$Files;", "", "fileName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "exists", "", "folder", "Ljava/nio/file/Path;", "resolve", "size", "", "REMAP", "CLASSES", "OFFSETS", "COUNT", "SHALLOW", "RETAINED", "intellij.profiler.ultimate"})
    public static final class Files
    extends Enum<Files> {
        public static final /* enum */ Files REMAP;
        public static final /* enum */ Files CLASSES;
        public static final /* enum */ Files OFFSETS;
        public static final /* enum */ Files COUNT;
        public static final /* enum */ Files SHALLOW;
        public static final /* enum */ Files RETAINED;
        private static final /* synthetic */ Files[] $VALUES;
        private final String fileName;

        static {
            Files[] filesArray = new Files[6];
            Files[] filesArray2 = filesArray;
            filesArray[0] = REMAP = new Files("remap.index");
            filesArray[1] = CLASSES = new Files("classes.index");
            filesArray[2] = OFFSETS = new Files("offsets.index");
            filesArray[3] = COUNT = new Files("count.index");
            filesArray[4] = SHALLOW = new Files("shallow.index");
            filesArray[5] = RETAINED = new Files("retained.index");
            $VALUES = filesArray;
        }

        @NotNull
        public final Path resolve(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Path path = folder.resolve(this.fileName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"folder.resolve(fileName)");
            return path;
        }

        public final boolean exists(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            return PathKt.exists((Path)this.resolve(folder));
        }

        public final long size(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            return PathKt.size((Path)this.resolve(folder));
        }

        private Files(String fileName) {
            this.fileName = fileName;
        }

        public static Files[] values() {
            return (Files[])$VALUES.clone();
        }

        public static Files valueOf(String string) {
            return Enum.valueOf(Files.class, string);
        }
    }
}

