/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitor;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0016J_\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#H\u0016\u00a2\u0006\u0002\u0010)J(\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0016J(\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0016J0\u00104\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u00105\u001a\u00020\f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020.H\u0016J\u0018\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0002J \u0010;\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\f2\u0006\u0010:\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006<"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/HistogramVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "classes", "Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "(Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;)V", "getClasses", "()Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "classloaders", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "getClassloaders", "()Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "maximumId", "", "minimumId", "objectIdToThreadId", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "getObjectIdToThreadId", "()Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "threadSerialNumToObjectId", "getThreadSerialNumToObjectId", "<set-?>", "totalInstances", "getTotalInstances", "()J", "totalSize", "getTotalSize", "preVisit", "", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "visitRootObject", "threadSerialNumber", "visitRootThreadObject", "intellij.profiler.ultimate"})
public final class HistogramVisitor
extends HProfVisitor {
    private long totalInstances;
    private long totalSize;
    private long minimumId;
    private long maximumId;
    @NotNull
    private final Long2LongOpenHashMap threadSerialNumToObjectId;
    @NotNull
    private final Long2LongOpenHashMap objectIdToThreadId;
    @NotNull
    private final LongOpenHashSet classloaders;
    @NotNull
    private final ClassVisitor classes;

    public final long getTotalInstances() {
        return this.totalInstances;
    }

    public final long getTotalSize() {
        return this.totalSize;
    }

    @NotNull
    public final Long2LongOpenHashMap getThreadSerialNumToObjectId() {
        return this.threadSerialNumToObjectId;
    }

    @NotNull
    public final Long2LongOpenHashMap getObjectIdToThreadId() {
        return this.objectIdToThreadId;
    }

    @NotNull
    public final LongOpenHashSet getClassloaders() {
        return this.classloaders;
    }

    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.HeapDump);
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.RootThreadObject);
        this.enable(HeapDumpRecordType.RootLocalJNI);
        this.enable(HeapDumpRecordType.RootJavaFrame);
        this.enable(HeapDumpRecordType.RootThreadBlock);
        this.enable(HeapDumpRecordType.RootNativeStack);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        long l = this.totalInstances;
        this.totalInstances = l + 1L;
        l = this.minimumId;
        boolean bl = false;
        this.minimumId = Math.min(classId, l);
        l = this.maximumId;
        bl = false;
        this.maximumId = Math.max(classId, l);
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        HprofClass info;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        HprofClass hprofClass = this.classes.get(classObjectId);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass hprofClass2 = info = hprofClass;
        long l = hprofClass2.getSoftRefCount();
        hprofClass2.setSoftRefCount(l + 1L);
        HprofClass hprofClass3 = info;
        hprofClass3.setSoftRefSize(hprofClass3.getSoftRefSize() + (info.getInstanceSize() + (long)16));
        l = this.totalInstances;
        this.totalInstances = l + 1L;
        this.totalSize += info.getInstanceSize() + (long)16;
        l = this.minimumId;
        boolean bl = false;
        this.minimumId = Math.min(objectId, l);
        l = this.maximumId;
        bl = false;
        this.maximumId = Math.max(objectId, l);
        if (classObjectId == this.classes.getIdOfThreadClass() || this.classes.isSubclassOf(classObjectId, this.classes.getIdOfThreadClass())) {
            int offset = 0;
            for (InstanceFieldEntry field : this.classes.collectInstanceFields(info.getClassId())) {
                if (this.classes.getObjectString(field.getFieldNameStringId()) != null) {
                    String string;
                    switch (string.hashCode()) {
                        case 114831: {
                            if (!string.equals("tid")) break;
                            this.objectIdToThreadId.put(objectId, bytes.getLong(offset));
                            break;
                        }
                    }
                }
                offset += field.getType() == Type.OBJECT ? this.getSizeOfID() : field.getType().getSize();
            }
        }
        if (this.classes.isSubclassOf(classObjectId, this.classes.getIdOfClassLoaderClass())) {
            this.classloaders.add(objectId);
        }
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
        HprofClass hprofClass = this.classes.get(this.classes.getClassForType(elementType));
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass info = hprofClass;
        long shallowSize = numberOfElements * (long)elementType.getSize() + (long)24;
        HprofClass hprofClass2 = info;
        long l = hprofClass2.getSoftRefCount();
        hprofClass2.setSoftRefCount(l + 1L);
        HprofClass hprofClass3 = info;
        hprofClass3.setSoftRefSize(hprofClass3.getSoftRefSize() + shallowSize);
        l = this.totalInstances;
        this.totalInstances = l + 1L;
        this.totalSize += shallowSize;
        l = this.minimumId;
        boolean bl = false;
        this.minimumId = Math.min(arrayObjectId, l);
        l = this.maximumId;
        bl = false;
        this.maximumId = Math.max(arrayObjectId, l);
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        HprofClass hprofClass = this.classes.get(arrayClassObjectId);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass info = hprofClass;
        long shallowSize = (long)objects.length * (long)this.getVisitorContext().getIdSize() + (long)24;
        HprofClass hprofClass2 = info;
        long l = hprofClass2.getSoftRefCount();
        hprofClass2.setSoftRefCount(l + 1L);
        HprofClass hprofClass3 = info;
        hprofClass3.setSoftRefSize(hprofClass3.getSoftRefSize() + shallowSize);
        l = this.totalInstances;
        this.totalInstances = l + 1L;
        this.totalSize += shallowSize;
        l = this.minimumId;
        boolean bl = false;
        this.minimumId = Math.min(arrayObjectId, l);
        l = this.maximumId;
        bl = false;
        this.maximumId = Math.max(arrayObjectId, l);
    }

    public void visitRootThreadObject(long objectId, long threadSerialNumber, long stackTraceSerialNumber) {
        this.visitRootObject(threadSerialNumber, objectId);
    }

    private final void visitRootObject(long threadSerialNumber, long objectId) {
        this.threadSerialNumToObjectId.put(threadSerialNumber, objectId);
    }

    @NotNull
    public final ClassVisitor getClasses() {
        return this.classes;
    }

    public HistogramVisitor(@NotNull ClassVisitor classes2) {
        Intrinsics.checkNotNullParameter((Object)((Object)classes2), (String)"classes");
        this.classes = classes2;
        this.minimumId = Long.MAX_VALUE;
        this.threadSerialNumToObjectId = new Long2LongOpenHashMap();
        this.objectIdToThreadId = new Long2LongOpenHashMap();
        this.classloaders = new LongOpenHashSet();
    }
}

