/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.Disposable;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitor;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitorKt;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0015J\b\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\u00020,2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020,0/J\u0013\u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010*\u001a\u00020\u0015H\u0086\u0002J\u000e\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020#J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0(2\u0006\u0010*\u001a\u00020\u0015J\u0010\u00104\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u0015J\u0010\u00105\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u0015J\u0010\u00107\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u0015J\u0016\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020\u00152\u0006\u0010:\u001a\u000209J\u0016\u0010;\u001a\u0002092\u0006\u0010*\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015J\b\u0010=\u001a\u00020,H\u0016J\b\u0010>\u001a\u00020,H\u0016J_\u0010?\u001a\u00020,2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00152\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0D2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020)0DH\u0016\u00a2\u0006\u0002\u0010IJ(\u0010J\u001a\u00020,2\u0006\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020\u0015H\u0016J\u0018\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u0005H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00150\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00150%j\b\u0012\u0004\u0012\u00020\u0015`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "Lcom/intellij/openapi/Disposable;", "stringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;)V", "classIdToStringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "classLoaderToClasses", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lit/unimi/dsi/fastutil/longs/LongSet;", "classes", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofClass;", "getClasses", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "getDump", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "<set-?>", "", "idOfClassClass", "getIdOfClassClass", "()J", "idOfClassLoaderClass", "getIdOfClassLoaderClass", "idOfObjectClass", "getIdOfObjectClass", "idOfStringClass", "getIdOfStringClass", "idOfThreadClass", "getIdOfThreadClass", "primitiveArrayToClass", "", "Lcom/intellij/diagnostic/hprof/parser/Type;", "referenceClasses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "collectInstanceFields", "", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "classId", "dispose", "", "forEachClass", "consumer", "Lkotlin/Function2;", "get", "getClassForType", "type", "getClassHierarchy", "getClassString", "getObjectString", "objectId", "getPrettyName", "isReferenceClass", "", "includeSubtypes", "isSubclassOf", "superClassId", "postVisit", "preVisit", "visitClassDump", "stackTraceSerialNumber", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitLoadClass", "classSerialNumber", "classObjectId", "stackSerialNumber", "classNameStringId", "visitStringInUTF8", "id", "s", "intellij.profiler.ultimate"})
public final class ClassVisitor
extends HProfVisitor
implements Disposable {
    private final Long2LongOpenHashMap classIdToStringIdMap;
    @NotNull
    private final Long2ObjectOpenHashMap<HprofClass> classes;
    private final HashSet<Long> referenceClasses;
    private long idOfStringClass;
    private long idOfThreadClass;
    private long idOfClassClass;
    private long idOfObjectClass;
    private long idOfClassLoaderClass;
    private final Map<Type, Long> primitiveArrayToClass;
    private final Long2ObjectOpenHashMap<LongSet> classLoaderToClasses;
    private final Long2ObjectMap<String> stringIdMap;
    @NotNull
    private final HprofDump dump;

    @NotNull
    public final Long2ObjectOpenHashMap<HprofClass> getClasses() {
        return this.classes;
    }

    public final long getIdOfStringClass() {
        return this.idOfStringClass;
    }

    public final long getIdOfThreadClass() {
        return this.idOfThreadClass;
    }

    public final long getIdOfClassClass() {
        return this.idOfClassClass;
    }

    public final long getIdOfObjectClass() {
        return this.idOfObjectClass;
    }

    public final long getIdOfClassLoaderClass() {
        return this.idOfClassLoaderClass;
    }

    @Nullable
    public final String getObjectString(long objectId) {
        return (String)this.stringIdMap.get(objectId);
    }

    @Nullable
    public final String getClassString(long classId) {
        long index = this.classIdToStringIdMap.get(classId);
        return index >= 0L ? this.getObjectString(index) : null;
    }

    @Nullable
    public final String getPrettyName(long classId) {
        String string;
        String string2 = this.getClassString(classId);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = ClassDefinition.Companion.computePrettyName(StringsKt.replace$default((String)it, (char)'/', (char)'.', (boolean)false, (int)4, null));
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final HprofClass get(long classId) {
        return (HprofClass)this.classes.get(classId);
    }

    public final boolean isReferenceClass(long classId, boolean includeSubtypes) {
        if (includeSubtypes) {
            return this.referenceClasses.contains(classId);
        }
        return CollectionsKt.contains((Iterable)ClassVisitorKt.access$getSPECIAL_REFS$p(), (Object)this.getClassString(classId));
    }

    public final boolean isSubclassOf(long classId, long superClassId) {
        HprofClass info = (HprofClass)this.classes.get(classId);
        while (info != null) {
            if (info.getSuperClassId() == superClassId) {
                return true;
            }
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return false;
    }

    @NotNull
    public final List<InstanceFieldEntry> collectInstanceFields(long classId) {
        ArrayList<InstanceFieldEntry> fields2 = new ArrayList<InstanceFieldEntry>(20);
        HprofClass info = (HprofClass)this.classes.get(classId);
        while (info != null) {
            InstanceFieldEntry[] $this$forEach$iv = info.getInstanceFields();
            boolean $i$f$forEach = false;
            InstanceFieldEntry[] instanceFieldEntryArray = $this$forEach$iv;
            int n = instanceFieldEntryArray.length;
            for (int i = 0; i < n; ++i) {
                InstanceFieldEntry element$iv;
                InstanceFieldEntry it = element$iv = instanceFieldEntryArray[i];
                boolean bl = false;
                fields2.add(it);
            }
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return fields2;
    }

    @NotNull
    public final List<HprofClass> getClassHierarchy(long classId) {
        HprofClass info;
        HprofClass hprofClass = info = (HprofClass)this.classes.get(classId);
        if (hprofClass != null) {
            if (hprofClass.getClassId() == this.idOfClassClass) {
                return CollectionsKt.listOf((Object)info);
            }
        }
        ArrayList<HprofClass> classes2 = new ArrayList<HprofClass>(10);
        while (info != null) {
            classes2.add(info);
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return classes2;
    }

    public final void forEachClass(@NotNull Function2<? super Long, ? super HprofClass, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ObjectIterator objectIterator = Long2ObjectMaps.fastIterable((Long2ObjectMap)((Long2ObjectMap)this.classes)).iterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry;
            Long2ObjectMap.Entry entry2 = entry = (Long2ObjectMap.Entry)objectIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
            Long l = entry2.getLongKey();
            Object object = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.value");
            consumer.invoke((Object)l, object);
        }
    }

    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.StringInUTF8);
        this.enable(RecordType.LoadClass);
        this.enable(RecordType.HeapDumpSegment);
        this.enable(HeapDumpRecordType.ClassDump);
    }

    public void visitStringInUTF8(long id, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stringIdMap.put(id, (Object)s);
    }

    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        this.classIdToStringIdMap.put(classObjectId, classNameStringId);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        String name;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        this.classes.put(classId, (Object)new HprofClass(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields, 0L, 0L, 0L, this.dump, 1792, null));
        ((LongSet)this.classLoaderToClasses.computeIfAbsent(classloaderClassId, (LongFunction)visitClassDump.1.INSTANCE)).add(classId);
        String string = this.getClassString(classId);
        Intrinsics.checkNotNull((Object)string);
        switch (name = string) {
            case "java/lang/String": {
                this.idOfStringClass = classId;
                break;
            }
            case "java/lang/Thread": {
                this.idOfThreadClass = classId;
                break;
            }
            case "java/lang/Class": {
                this.idOfClassClass = classId;
                break;
            }
            case "java/lang/Object": {
                this.idOfObjectClass = classId;
                break;
            }
            case "java/lang/ClassLoader": {
                this.idOfClassLoaderClass = classId;
                break;
            }
        }
        if (name.length() == 2 && name.charAt(0) == '[' && name.charAt(1) != '[' && name.charAt(1) != 'L') {
            String string2 = name;
            int n = 0;
            int n2 = 2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.primitiveArrayToClass.put(Type.Companion.getType(string4), classId);
        }
    }

    public void postVisit() {
        HprofClass hprofClass = this.get(this.idOfClassClass);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass classInfo = hprofClass;
        this.forEachClass((Function2<? super Long, ? super HprofClass, Unit>)((Function2)new Function2<Long, HprofClass, Unit>(this, classInfo){
            final /* synthetic */ ClassVisitor this$0;
            final /* synthetic */ HprofClass $classInfo;

            public final void invoke(long $noName_0, @NotNull HprofClass info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                HprofClass hprofClass = this.$classInfo;
                long l = hprofClass.getSoftRefCount();
                hprofClass.setSoftRefCount(l + 1L);
                HprofClass hprofClass2 = this.$classInfo;
                hprofClass2.setSoftRefSize(hprofClass2.getSoftRefSize() + (this.$classInfo.getInstanceSize() + (long)16));
                HprofClass cur = info;
                while (cur != null) {
                    String fqn = this.this$0.getClassString(cur.getClassId());
                    if (Intrinsics.areEqual((Object)fqn, (Object)"java/lang/ClassLoader")) {
                        ClassVisitor.access$getClassLoaderToClasses$p(this.this$0).computeIfAbsent(info.getClassId(), (LongFunction)postVisit.1.INSTANCE);
                        break;
                    }
                    if (CollectionsKt.contains((Iterable)ClassVisitorKt.access$getSPECIAL_REFS$p(), (Object)fqn)) {
                        ClassVisitor.access$getReferenceClasses$p(this.this$0).add(info.getClassId());
                        break;
                    }
                    cur = (HprofClass)this.this$0.getClasses().get(cur.getSuperClassId());
                }
            }
            {
                this.this$0 = classVisitor;
                this.$classInfo = hprofClass;
                super(2);
            }
        }));
    }

    public final long getClassForType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Long l = this.primitiveArrayToClass.get(type);
        if (l == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Should contains any type"));
        }
        return l;
    }

    public void dispose() {
        this.stringIdMap.clear();
        this.classes.clear();
    }

    @NotNull
    public final HprofDump getDump() {
        return this.dump;
    }

    public ClassVisitor(@NotNull Long2ObjectMap<String> stringIdMap, @NotNull HprofDump dump) {
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.stringIdMap = stringIdMap;
        this.dump = dump;
        this.classIdToStringIdMap = new Long2LongOpenHashMap();
        this.classes = new Long2ObjectOpenHashMap();
        this.referenceClasses = new HashSet();
        this.idOfStringClass = -1L;
        this.idOfThreadClass = -1L;
        this.idOfClassClass = -1L;
        this.idOfObjectClass = -1L;
        this.idOfClassLoaderClass = -1L;
        boolean bl = false;
        this.primitiveArrayToClass = new LinkedHashMap();
        this.classLoaderToClasses = new Long2ObjectOpenHashMap();
    }

    public static final /* synthetic */ Long2ObjectOpenHashMap access$getClassLoaderToClasses$p(ClassVisitor $this) {
        return $this.classLoaderToClasses;
    }

    public static final /* synthetic */ HashSet access$getReferenceClasses$p(ClassVisitor $this) {
        return $this.referenceClasses;
    }
}

