/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.hprof.utils.LongList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongBufferUtils {
    public static void sort(@NotNull LongList b) {
        if (b == null) {
            LongBufferUtils.$$$reportNull$$$0(0);
        }
        LongBufferUtils.sort(b, null, null);
    }

    public static void sort(@NotNull LongList b, @Nullable ProgressIndicator indicator, @Nullable SwapConsumer consumer) {
        if (b == null) {
            LongBufferUtils.$$$reportNull$$$0(1);
        }
        LongBufferUtils.sort(b, 0, b.limit(), indicator, consumer);
    }

    public static void sort(@NotNull LongList b, int fromIndex, int toIndex, @Nullable ProgressIndicator indicator, @Nullable SwapConsumer consumer) {
        int i;
        int n;
        if (b == null) {
            LongBufferUtils.$$$reportNull$$$0(2);
        }
        if ((n = toIndex - fromIndex) <= 1) {
            return;
        }
        int half = n / 2 - 1;
        double steps = 1.5 * (double)n;
        for (i = fromIndex + half; i >= fromIndex; --i) {
            if (indicator != null) {
                indicator.setFraction((double)(half - i) / steps);
            }
            LongBufferUtils.heapify(b, toIndex, i, fromIndex, consumer);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            if (indicator != null) {
                indicator.setFraction((double)(half + n - i) / steps);
            }
            LongBufferUtils.swap(b, fromIndex, i, consumer);
            LongBufferUtils.heapify(b, i, fromIndex, fromIndex, consumer);
        }
    }

    private static void heapify(@NotNull LongList b, int n, int i, int offset, @Nullable SwapConsumer consumer) {
        if (b == null) {
            LongBufferUtils.$$$reportNull$$$0(3);
        }
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            LongBufferUtils.swap(b, i, largest, consumer);
            LongBufferUtils.heapify(b, n, largest, offset, consumer);
        }
    }

    private static void swap(@NotNull LongList b, int i, int j, @Nullable SwapConsumer consumer) {
        if (b == null) {
            LongBufferUtils.$$$reportNull$$$0(4);
        }
        b.swap(i, j);
        if (consumer != null) {
            consumer.accept(i, j);
        }
    }

    public static int binarySearch(LongList a, long key) {
        int low = 0;
        int high = a.limit() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private LongBufferUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "b";
        objectArray2[1] = "com/intellij/profiler/ultimate/hprof/utils/LongBufferUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sort";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "heapify";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "swap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface SwapConsumer {
        public void accept(int var1, int var2);
    }
}

