/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.profiler.ultimate.hprof.utils.PagedByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntMultimap
implements AutoCloseable {
    @NotNull
    private final PagedByteBuffer myHeader;
    @NotNull
    private final PagedByteBuffer myBody;
    private static final int HEADER_RECORD_SIZE = 12;
    private int mySize;
    private long myFileEnd;
    @Nullable
    private IntUnaryOperator myCollectionSize;

    public IntMultimap(int keySize, @NotNull Function<String, Path> generator) throws IOException {
        if (generator == null) {
            IntMultimap.$$$reportNull$$$0(0);
        }
        this.mySize = 0;
        this.myFileEnd = 0L;
        this.myHeader = new PagedByteBuffer(12L * (long)keySize, 12, generator.apply("head"), new StandardOpenOption[0]);
        long totalValues = 0L;
        ByteBuffer record = ByteBuffer.allocate(12);
        for (long i = 0L; i < this.myHeader.getSize(); i += 12L) {
            record.clear();
            this.myHeader.get(i, record.array());
            record.position(8);
            totalValues += (long)record.getInt();
        }
        this.myBody = new PagedByteBuffer(totalValues * 4L, 4, generator.apply("body"), new StandardOpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public IntMultimap(int keySize, long totalValues, @NotNull IntUnaryOperator collectionSize, @NotNull Function<String, Path> function) throws IOException {
        void generator;
        if (collectionSize == null) {
            IntMultimap.$$$reportNull$$$0(1);
        }
        if (function == null) {
            IntMultimap.$$$reportNull$$$0(2);
        }
        this.mySize = 0;
        this.myFileEnd = 0L;
        this.myHeader = new PagedByteBuffer(12L * (long)keySize, 12, (Path)generator.apply("head"), new StandardOpenOption[0]);
        this.myBody = new PagedByteBuffer(totalValues * 4L, 4, (Path)generator.apply("body"), new StandardOpenOption[0]);
        this.myCollectionSize = collectionSize;
    }

    public int[] get(int key) {
        long position = (long)key * 12L;
        long longArrayOffset = this.myHeader.getLong(position);
        if (longArrayOffset >= 0L) {
            int longArraySize = this.myHeader.getInt(position + 8L);
            int[] result = new int[longArraySize];
            byte[] bytes = new byte[longArraySize * 4];
            this.myBody.get(longArrayOffset, bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            for (int i = 0; i < longArraySize; ++i) {
                result[i] = buffer.getInt();
            }
            return result;
        }
        return new int[0];
    }

    public void get(int key, IntConsumer consumer) {
        long position = (long)key * 12L;
        long longArrayOffset = this.myHeader.getLong(position);
        if (longArrayOffset >= 0L) {
            long longArraySize = this.myHeader.getInt(position + 8L);
            for (long i = 0L; i < longArraySize * 4L; i += 4L) {
                consumer.accept(this.myBody.getInt(longArrayOffset + i));
            }
        }
    }

    public boolean isReadOnly() {
        return this.myCollectionSize == null;
    }

    public void add(int key, int value) {
        if (this.myCollectionSize == null) {
            throw new UnsupportedOperationException("Read only multimap");
        }
        long headerPos = (long)key * 12L;
        assert (headerPos < this.myHeader.getSize()) : headerPos + " >= " + this.myHeader.getSize();
        long offset = this.myHeader.getLong(headerPos);
        int length = this.myHeader.getInt(headerPos + 8L);
        if (offset == 0L && length == 0) {
            offset = this.myFileEnd;
            this.myHeader.putLong(headerPos, offset);
            long count = this.myCollectionSize.applyAsInt(key);
            this.myFileEnd += count * 4L;
            ++this.mySize;
            if (count == 0L) {
                return;
            }
        }
        this.myBody.putInt(offset + (long)length * 4L, value);
        this.myHeader.putInt(headerPos + 8L, ++length);
        int i = this.myCollectionSize.applyAsInt(key);
        assert (i >= length) : String.format("expected size %d, actual is %d for key %d", i, length, key);
    }

    public int size() {
        return this.mySize;
    }

    @Override
    public void close() {
        this.myCollectionSize = null;
        this.myHeader.close();
        this.myBody.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "generator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "collectionSize";
                break;
            }
        }
        objectArray[1] = "com/intellij/profiler/ultimate/hprof/utils/IntMultimap";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

