/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiThread;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006B)\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/SummarySnapshotPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "createCenterComponent", "createRightComponent", "Ljavax/swing/JComponent;", "getTabName", "", "intellij.profiler.ultimate"})
public final class SummarySnapshotPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab {
    @NotNull
    private final MuiSnapshot<T, I> snapshot;
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;

    @Override
    @NotNull
    public String getTabName() {
        return UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary", new Object[0]);
    }

    @Override
    @Nullable
    public JComponent createRightComponent() {
        return null;
    }

    @NotNull
    public SummarySnapshotPanel<T, I> createCenterComponent() {
        return this;
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    public SummarySnapshotPanel(@NotNull MuiSnapshot<T, I> snapshot, @NotNull Project project, @NotNull Disposable disposable) {
        StringBuilder text;
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.snapshot = snapshot;
        this.project = project;
        this.disposable = disposable;
        final ConsoleViewImpl panel2 = new ConsoleViewImpl(this.project, true);
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)panel2));
        this.add(panel2.getComponent());
        StringBuilder stringBuilder = text = new StringBuilder();
        String string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.bytes", new Object[0]) + ": %,d";
        Object[] objectArray = new Object[]{this.snapshot.getTotalBytes()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        string = string2;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        stringBuilder = text;
        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.classes", new Object[0]) + ": %,d";
        Object[] objectArray2 = new Object[]{this.snapshot.getTypeCount()};
        bl = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        string = string3;
        boolean bl3 = false;
        StringBuilder stringBuilder3 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        stringBuilder = text;
        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.instances", new Object[0]) + ": %,d";
        Object[] objectArray3 = new Object[]{this.snapshot.getTotalInstances() - this.snapshot.getTypeCount()};
        bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(this, *args)");
        string = string4;
        boolean bl4 = false;
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        stringBuilder = text;
        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.classloaders", new Object[0]) + ": %,d";
        Object[] objectArray4 = new Object[]{this.snapshot.getClassLoaderCount()};
        bl = false;
        String string5 = String.format(string, Arrays.copyOf(objectArray4, objectArray4.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
        string = string5;
        boolean bl5 = false;
        StringBuilder stringBuilder5 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        stringBuilder = text;
        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.roots", new Object[0]) + ": %,d";
        Object[] objectArray5 = new Object[]{this.snapshot.getRootCount()};
        bl = false;
        String string6 = String.format(string, Arrays.copyOf(objectArray5, objectArray5.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(this, *args)");
        string = string6;
        boolean bl6 = false;
        StringBuilder stringBuilder6 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        StringsKt.appendln((StringBuilder)text);
        panel2.print(text.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        panel2.print(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.thread.loading", new Object[0]), ConsoleViewContentType.NORMAL_OUTPUT);
        panel2.scrollTo(0);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public final void run() {
                Iterable $this$forEach$iv = this.getSnapshot().getThreads();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl;
                    String string;
                    MuiThread it = (MuiThread)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = it.getName();
                    boolean bl3 = false;
                    if (charSequence.length() == 0) {
                        charSequence = text;
                        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.thread", it.getTid());
                        bl = false;
                        StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                        StringsKt.appendln((StringBuilder)stringBuilder);
                    } else {
                        charSequence = text;
                        string = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.threadWithName", it.getName(), it.getTid());
                        bl = false;
                        StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                        StringsKt.appendln((StringBuilder)stringBuilder);
                    }
                    Iterable $this$forEach$iv2 = it.getFrames();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        StringBuilder stringBuilder;
                        String frame = (String)element$iv2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)text.append("\t"), (String)"text.append(\"\\t\")");
                        boolean bl5 = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(frame);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        StringsKt.appendln((StringBuilder)stringBuilder2);
                    }
                    StringsKt.appendln((StringBuilder)text);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            this.this$0.panel2.clear();
                            this.this$0.panel2.print(this.this$0.text.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                            this.this$0.panel2.scrollTo(0);
                        }
                    });
                }
            }
        });
    }
}

