/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiArray;
import com.intellij.profiler.ultimate.hprof.api.MuiField;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiPage;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiTypes;
import com.intellij.profiler.ultimate.hprof.api.MuiValue;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a(\u0010\u0007\u001a\u00020\u00012\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a.\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\tH\u0003\u001a\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001a\u0010\u0015\u001a\u00020\t2\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u001a\"\u0010\u0018\u001a\u00020\t2\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0001\u001a\f\u0010\u001b\u001a\u00020\t*\u00020\u001cH\u0003\u00a8\u0006\u001d"}, d2={"appendFieldValue", "", "value", "", "fragments", "", "Lcom/intellij/profiler/ultimate/hprof/ui/TextFragment;", "appendFragment", "text", "", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "appendObjectValue", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "createTextFragments", "", "formatHexValue", "isIntegerValue", "", "repeat", "times", "", "substring", "from", "to", "typeString", "Lcom/intellij/diagnostic/hprof/parser/Type;", "intellij.profiler.ultimate"})
public final class RenderUtilsKt {
    @NotNull
    public static final List<TextFragment> createTextFragments(@Nullable Object value, @NotNull MuiSnapshot<?, ?> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        if (value instanceof MuiType) {
            String string = ((MuiType)value).getName();
            if (string == null) {
                string = "";
            }
            String prettyName = string;
            int index = StringUtil.lastIndexOf((CharSequence)prettyName, (char)'.', (int)0, (int)prettyName.length());
            if (index > 0) {
                String packageName = RenderUtilsKt.substring(prettyName, 0, index + 1);
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, $this$apply);
            }
            String className = RenderUtilsKt.substring(prettyName, index + 1, prettyName.length());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES");
            RenderUtilsKt.appendFragment(className, simpleTextAttributes, $this$apply);
        } else if (value instanceof MuiInstance && ((MuiInstance)value).getId() < 0L && ((MuiInstance)value).getPrettyName() != null) {
            String string = ((MuiInstance)value).getPrettyName();
            Intrinsics.checkNotNull((Object)string);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
        } else if (value instanceof MuiInstance) {
            RenderUtilsKt.appendObjectValue((MuiInstance)value, snapshot, $this$apply);
        } else if (value instanceof MuiValue && RenderUtilsKt.isIntegerValue(((MuiValue)value).getValue())) {
            RenderUtilsKt.appendFieldValue(((MuiValue)value).getValue(), $this$apply);
        } else if (value instanceof MuiValue && ((MuiValue)value).getValue() instanceof Character) {
            String string = "" + '\'' + ((MuiValue)value).getValue() + '\'';
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
        } else if (value instanceof MuiValue) {
            String string = String.valueOf(((MuiValue)value).getValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
        } else if (value instanceof MuiField) {
            if (((MuiField)value).isStatic()) {
                String string = UltimateProfilerBundleKt.profilerMessage("hprof.render.utils.modificators.static", new Object[0]) + " ";
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
            }
            String string = ((MuiField)value).getName() + " = ";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
            if (((MuiField)value).getValue() instanceof MuiInstance) {
                Object object = ((MuiField)value).getValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.api.MuiInstance");
                }
                RenderUtilsKt.appendObjectValue((MuiInstance)object, snapshot, $this$apply);
            } else if (((MuiField)value).getType() != Type.OBJECT && RenderUtilsKt.isIntegerValue(((MuiField)value).getValue())) {
                RenderUtilsKt.appendFieldValue(((MuiField)value).getValue(), $this$apply);
                String string2 = ' ' + RenderUtilsKt.typeString(((MuiField)value).getType());
                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string2, simpleTextAttributes2, $this$apply);
            } else {
                Object object = ((MuiField)value).getValue();
                if (object == null) {
                    object = "null";
                }
                String string3 = String.valueOf(object);
                SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string3, simpleTextAttributes3, $this$apply);
                String string4 = ' ' + RenderUtilsKt.typeString(((MuiField)value).getType());
                SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string4, simpleTextAttributes4, $this$apply);
            }
        } else if (value instanceof MuiPage) {
            String string = ((MuiPage)value).getText();
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
        } else {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$apply);
        }
        return list;
    }

    @NlsSafe
    private static final String typeString(Type $this$typeString) {
        String string = $this$typeString.name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return string3;
    }

    public static final void appendObjectValue(@NotNull MuiInstance value, @NotNull MuiSnapshot<?, ?> snapshot, @NotNull List<TextFragment> fragments) {
        block21: {
            Unit unit;
            block16: {
                String prettyName;
                MuiType type;
                block18: {
                    String string;
                    block20: {
                        block19: {
                            String stringValue;
                            String string2;
                            String it;
                            boolean bl;
                            boolean className2;
                            String index2;
                            block17: {
                                block15: {
                                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                    Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
                                    Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
                                    type = value.getType();
                                    if (value.getPrettyName() == null) break block15;
                                    String string3 = value.getPrettyName();
                                    Intrinsics.checkNotNull((Object)string3);
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment(string3, simpleTextAttributes, fragments);
                                    unit = Unit.INSTANCE;
                                    break block16;
                                }
                                if (type.getId() != snapshot.getIdOfType(MuiTypes.CLASS)) break block17;
                                Object obj = snapshot.getTypeById(value.getId());
                                String string4 = prettyName = obj != null ? obj.getName() : null;
                                if (prettyName == null) {
                                    Object object;
                                    MuiInstance muiInstance = value;
                                    if (!(muiInstance instanceof MuiRecord)) {
                                        muiInstance = null;
                                    }
                                    MuiRecord muiRecord = (MuiRecord)muiInstance;
                                    Object object2 = muiRecord != null ? muiRecord.getFieldValue("name") : null;
                                    if (!(object2 instanceof MuiRecord)) {
                                        object2 = null;
                                    }
                                    if ((object = (MuiRecord)object2) == null || (object = ((MuiRecord)object).getStringValue("value")) == null) {
                                        object = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.type", new Object[0]);
                                    }
                                    Object t = object;
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment((String)t, simpleTextAttributes, fragments);
                                    unit = Unit.INSTANCE;
                                } else {
                                    int index2 = StringUtil.lastIndexOf((CharSequence)prettyName, (char)'.', (int)0, (int)prettyName.length());
                                    if (index2 > 0) {
                                        String packageName = RenderUtilsKt.substring(prettyName, 0, index2 + 1);
                                        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                                        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                                        RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, fragments);
                                    }
                                    String className2 = RenderUtilsKt.substring(prettyName, index2 + 1, prettyName.length());
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment(className2, simpleTextAttributes, fragments);
                                    unit = Unit.INSTANCE;
                                }
                                break block16;
                            }
                            if (type.getId() != snapshot.getIdOfType(MuiTypes.STRING)) break block18;
                            String string5 = ((MuiRecord)value).getStringValue("value");
                            if (string5 != null) {
                                index2 = string5;
                                className2 = false;
                                bl = false;
                                it = index2;
                                boolean bl2 = false;
                                string2 = StringUtil.first((String)it, (int)250, (boolean)true);
                            } else {
                                string2 = null;
                            }
                            if ((string = (stringValue = string2)) == null) break block19;
                            index2 = string;
                            className2 = false;
                            bl = false;
                            it = index2;
                            boolean bl3 = false;
                            string = '\'' + it + '\'';
                            if (string != null) break block20;
                        }
                        string = "";
                    }
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
                    String string6 = ' ' + type.getName();
                    SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(string6, simpleTextAttributes2, fragments);
                    unit = Unit.INSTANCE;
                    break block16;
                }
                String string = type.getName();
                if (string == null) {
                    string = "";
                }
                prettyName = string;
                int index = StringUtil.lastIndexOf((CharSequence)prettyName, (char)'.', (int)0, (int)prettyName.length());
                if (index > 0) {
                    String packageName = RenderUtilsKt.substring(prettyName, 0, index + 1);
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, fragments);
                }
                if (value instanceof MuiArray) {
                    int bracketStartIndex = StringsKt.indexOf$default((CharSequence)prettyName, (char)'[', (int)0, (boolean)false, (int)6, null);
                    String prettyNameWithCount = RenderUtilsKt.substring(prettyName, index + 1, bracketStartIndex);
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(prettyNameWithCount, simpleTextAttributes, fragments);
                    int arrayDimension = (prettyName.length() - bracketStartIndex) / 2;
                    String brackets = RenderUtilsKt.repeat("[]", arrayDimension - 1);
                    String string7 = "" + '[' + ((MuiArray)value).getValueCount() + ']' + brackets;
                    SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(string7, simpleTextAttributes3, fragments);
                    unit = Unit.INSTANCE;
                } else {
                    String className = RenderUtilsKt.substring(prettyName, index + 1, prettyName.length());
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(className, simpleTextAttributes, fragments);
                    unit = Unit.INSTANCE;
                }
            }
            Unit unit2 = unit;
            boolean bl = false;
            boolean bl4 = false;
            Unit $this$apply = unit2;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder().append(", ");
            String string = Long.toHexString(value.getId());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toHexString(value.id)");
            String string8 = stringBuilder.append(RenderUtilsKt.formatHexValue(string)).toString();
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string8, simpleTextAttributes, fragments);
            String string9 = snapshot.getRootReason(value.getId());
            if (string9 == null) break block21;
            String string10 = string9;
            boolean bl6 = false;
            boolean bl7 = false;
            String it = string10;
            boolean bl8 = false;
            String string11 = ", " + UltimateProfilerBundleKt.profilerMessage("hprof.render.utils.modificators.gcroot", it);
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string11, simpleTextAttributes4, fragments);
        }
    }

    public static final void appendFieldValue(@Nullable Object value, @NotNull List<TextFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Object object = value;
        if (object instanceof Byte) {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            String string2 = "%02X";
            Object[] objectArray = new Object[]{value};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
            String string4 = stringBuilder.append(RenderUtilsKt.formatHexValue(string3)).toString();
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string4, simpleTextAttributes2, fragments);
            String string5 = " '" + (char)((Number)value).byteValue() + '\'';
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string5, simpleTextAttributes3, fragments);
        } else if (object instanceof Short) {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            String string6 = "%04X";
            Object[] objectArray = new Object[]{value};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(this, *args)");
            String string8 = stringBuilder.append(RenderUtilsKt.formatHexValue(string7)).append(" ").toString();
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string8, simpleTextAttributes4, fragments);
        } else if (object instanceof Integer) {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            String string9 = "%08X";
            Object[] objectArray = new Object[]{value};
            boolean bl = false;
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"java.lang.String.format(this, *args)");
            String string11 = stringBuilder.append(RenderUtilsKt.formatHexValue(string10)).append(" ").toString();
            SimpleTextAttributes simpleTextAttributes5 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes5, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string11, simpleTextAttributes5, fragments);
        } else if (object instanceof Long) {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            String string12 = "%016X";
            Object[] objectArray = new Object[]{value};
            boolean bl = false;
            String string13 = String.format(string12, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"java.lang.String.format(this, *args)");
            String string14 = stringBuilder.append(RenderUtilsKt.formatHexValue(string13)).append(" ").toString();
            SimpleTextAttributes simpleTextAttributes6 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes6, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string14, simpleTextAttributes6, fragments);
        } else {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
        }
    }

    @NlsSafe
    @NotNull
    public static final String substring(@NlsSafe @NotNull String text, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text;
        boolean bl = false;
        String string2 = string.substring(from, to);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @NlsSafe
    @NotNull
    public static final String repeat(@NlsSafe @NotNull String text, int times) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.repeat((CharSequence)text, (int)times);
    }

    @NlsSafe
    private static final String formatHexValue(String value) {
        return "0x" + value;
    }

    private static final boolean isIntegerValue(Object value) {
        Object object = value;
        return object instanceof Byte ? true : (object instanceof Short ? true : (object instanceof Integer ? true : object instanceof Long));
    }

    private static final void appendFragment(@Nls String text, SimpleTextAttributes attributes, List<TextFragment> fragments) {
        Collection collection = fragments;
        TextFragment textFragment = new TextFragment(text, attributes);
        boolean bl = false;
        collection.add(textFragment);
    }
}

