/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.PathKt;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J_\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001fJ(\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J0\u0010*\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ProgressBarWatcherVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "path", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "multiplier", "", "(Ljava/nio/file/Path;Lcom/intellij/openapi/progress/ProgressIndicator;I)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "lastPosition", "", "size", "doUpdate", "", "postVisit", "preVisit", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "intellij.profiler.ultimate"})
public final class ProgressBarWatcherVisitor
extends HProfVisitor {
    private final long size;
    private long lastPosition;
    @NotNull
    private final ProgressIndicator indicator;

    public void preVisit() {
        this.indicator.setIndeterminate(false);
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
    }

    private final void doUpdate() {
        int newValue;
        int oldValue = (int)(this.indicator.getFraction() * (double)100);
        if (oldValue != (newValue = (int)((long)100 * (this.lastPosition + this.getVisitorContext().getCurrentHeapRecordOffset()) / this.size))) {
            this.indicator.setFraction((double)newValue / 100.0);
            this.indicator.checkCanceled();
        }
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
        this.doUpdate();
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        this.doUpdate();
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.doUpdate();
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.doUpdate();
    }

    public void postVisit() {
        this.lastPosition = this.getVisitorContext().getCurrentHeapRecordOffset();
    }

    @NotNull
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public ProgressBarWatcherVisitor(@NotNull Path path, @NotNull ProgressIndicator indicator, int multiplier) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.indicator = indicator;
        this.size = PathKt.size((Path)path) * (long)multiplier;
    }

    public /* synthetic */ ProgressBarWatcherVisitor(Path path, ProgressIndicator progressIndicator, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(path, progressIndicator, n);
    }
}

