/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ui.JBRunnerClosableTabs;
import com.intellij.profiler.ui.treetable.MouseAwareTreeCellRendererPanel;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiTree;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.ui.ActionsKt;
import com.intellij.profiler.ultimate.hprof.ui.LazyPanel;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanelKt;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.ReverseReferencePanel;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006:\u0002;<B[\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u001a\b\u0002\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eJ\u001c\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020)0.J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\b\u00105\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001607J\n\u00108\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u00109\u001a\u00020\fH\u0017J\u0006\u0010:\u001a\u00020)Rn\u0010\u0014\u001ab\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0018 \u0017*\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u000e0\u000e \u0017*/\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0018 \u0017*\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u000e0\u000e0\u001a\u00a2\u0006\u0002\b\u00190\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab;", "project", "Lcom/intellij/openapi/project/Project;", "view", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;", "tabName", "", "objects", "", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "classToObject", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;Ljava/lang/String;Ljava/util/List;Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lkotlin/jvm/functions/Function1;)V", "cache", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/profiler/ultimate/hprof/ui/TextFragment;", "Lorg/jetbrains/annotations/NotNull;", "", "emptyText", "Lcom/intellij/util/ui/StatusText;", "getEmptyText", "()Lcom/intellij/util/ui/StatusText;", "getObjects", "()Ljava/util/List;", "parentDisposable", "getParentDisposable", "()Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "table", "Lcom/intellij/ui/components/JBTreeTable;", "addResults", "", "list", "addTrailingLink", "text", "action", "Lkotlin/Function0;", "count", "", "createCenterComponent", "Ljavax/swing/JComponent;", "createRightComponent", "createTextFragments", "value", "elements", "", "getSelectedValue", "getTabName", "removeTrailingLink", "Listener", "MyLink", "intellij.profiler.ultimate"})
public final class ObjectViewPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab {
    private final JBTreeTable table;
    private final Map<Object, List<TextFragment>> cache;
    private final Project project;
    private final MemoryViewTopLevelComponent view;
    private final String tabName;
    @NotNull
    private final List<?> objects;
    @NotNull
    private final MuiSnapshot<T, I> snapshot;

    private final MemoryViewTopLevelComponent getParentDisposable() {
        return this.view;
    }

    @NotNull
    public final StatusText getEmptyText() {
        Tree tree2 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"table.tree");
        StatusText statusText = tree2.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"table.tree.emptyText");
        return statusText;
    }

    public final void addResults(@NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        TreeTableModel treeTableModel = this.table.getModel();
        if (treeTableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        }
        ObjectTreeTableModel model = (ObjectTreeTableModel)treeTableModel;
        boolean isEmptyModel = model.getSize() == 0;
        model.addAll(list);
        if (isEmptyModel) {
            Tree tree2 = this.table.getTree();
            TreeTableModel treeTableModel2 = this.table.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeTableModel2, (String)"table.model");
            tree2.expandPath(new TreePath(treeTableModel2.getRoot()));
        }
    }

    public final void addTrailingLink(@NotNull String text, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.removeTrailingLink();
        this.addResults(CollectionsKt.listOf((Object)new MyLink(text, action)));
    }

    public final void removeTrailingLink() {
        TreeTableModel treeTableModel = this.table.getModel();
        if (treeTableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        }
        ObjectTreeTableModel model = (ObjectTreeTableModel)treeTableModel;
        model.removeLastIf((Function1<Object, Boolean>)((Function1)removeTrailingLink.1.INSTANCE));
    }

    public final int count() {
        TreeTableModel treeTableModel = this.table.getModel();
        if (treeTableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        }
        return ((ObjectTreeTableModel)treeTableModel).getSize();
    }

    @NotNull
    public final Iterator<Object> elements() {
        TreeTableModel treeTableModel = this.table.getModel();
        if (treeTableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        }
        ObjectTreeTableModel model = (ObjectTreeTableModel)treeTableModel;
        return new Iterator<Object>(model){
            @NotNull
            private final Iterator<ObjectTreeTableModel.Wrapper> delegate;
            final /* synthetic */ ObjectTreeTableModel $model;

            @NotNull
            public final Iterator<ObjectTreeTableModel.Wrapper> getDelegate() {
                return this.delegate;
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Nullable
            public Object next() {
                return this.delegate.next().getValue();
            }
            {
                this.$model = $captured_local_variable$0;
                this.delegate = $captured_local_variable$0.getObjects().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private final List<TextFragment> createTextFragments(Object value) {
        Object v = value instanceof ObjectTreeTableModel.Wrapper ? ((ObjectTreeTableModel.Wrapper)value).getValue() : value;
        List<TextFragment> list = this.cache.computeIfAbsent(v, (Function<Object, List<TextFragment>>)new Function<Object, List<? extends TextFragment>>(this, v){
            final /* synthetic */ ObjectViewPanel this$0;
            final /* synthetic */ Object $v;

            public final List<TextFragment> apply(Object it) {
                return RenderUtilsKt.createTextFragments(this.$v, this.this$0.getSnapshot());
            }
            {
                this.this$0 = objectViewPanel;
                this.$v = object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(list, (String)"cache.computeIfAbsent(v)\u2026tFragments(v, snapshot) }");
        return list;
    }

    private final MuiInstance getSelectedValue() {
        MuiInstance muiInstance;
        Tree tree2 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"table.tree");
        Object object = tree2.getSelectionPath();
        if (object != null && (object = ((TreePath)object).getLastPathComponent()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            muiInstance = ActionsKt.getMuiInstanceOrNull(ObjectViewPanelKt.access$tryUnwrapOrSelf(it));
        } else {
            muiInstance = null;
        }
        return muiInstance;
    }

    @Override
    @Nls
    @NotNull
    public String getTabName() {
        return this.tabName;
    }

    @Override
    @NotNull
    public JComponent createRightComponent() {
        LazyPanel $this$apply;
        JBRunnerClosableTabs tabs = new JBRunnerClosableTabs(this.project, (Disposable)this.view);
        LazyPanel lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.shortest.paths", new Object[0]), false, null, new Function1<ProgressIndicator, ReverseReferencePanel.ShortestPaths<I>>(this){
            final /* synthetic */ ObjectViewPanel this$0;

            @NotNull
            public final ReverseReferencePanel.ShortestPaths<I> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                MuiSnapshot<T, I> muiSnapshot = this.this$0.getSnapshot();
                MuiInstance muiInstance = ObjectViewPanel.access$getSelectedValue(this.this$0);
                Intrinsics.checkNotNull((Object)muiInstance);
                MuiTree<I> paths = muiSnapshot.getShortestPaths(muiInstance.getId(), indicator);
                return new ReverseReferencePanel.ShortestPaths<I>(ObjectViewPanel.access$getView$p(this.this$0), this.this$0.getSnapshot(), paths, ObjectViewPanel.access$getParentDisposable$p(this.this$0));
            }
            {
                this.this$0 = objectViewPanel;
                super(1);
            }
        }, 12, null);
        boolean bl = false;
        boolean bl2 = false;
        LazyPanel lazyPanel3 = lazyPanel2;
        JBRunnerClosableTabs jBRunnerClosableTabs = tabs;
        boolean bl3 = false;
        $this$apply.setEnabled(false);
        Tree tree2 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"table.tree");
        tree2.getSelectionModel().addTreeSelectionListener(new Listener($this$apply));
        Unit unit = Unit.INSTANCE;
        JComponent jComponent = (JComponent)((Object)lazyPanel2);
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.shortest.paths", new Object[0])));
        lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.references", new Object[0]), false, null, new Function1<ProgressIndicator, ReverseReferencePanel.Simple<I>>(this){
            final /* synthetic */ ObjectViewPanel this$0;

            @NotNull
            public final ReverseReferencePanel.Simple<I> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                MuiInstance muiInstance = ObjectViewPanel.access$getSelectedValue(this.this$0);
                if (muiInstance == null) {
                    throw (Throwable)new IllegalStateException("selected null value");
                }
                this.this$0.getSnapshot().getReverseReferences(muiInstance.getId(), indicator);
                return new ReverseReferencePanel.Simple<I>(ObjectViewPanel.access$getView$p(this.this$0), this.this$0.getSnapshot(), ObjectViewPanel.access$getSelectedValue(this.this$0), ObjectViewPanel.access$getParentDisposable$p(this.this$0));
            }
            {
                this.this$0 = objectViewPanel;
                super(1);
            }
        }, 12, null);
        bl = false;
        bl2 = false;
        $this$apply = lazyPanel2;
        jBRunnerClosableTabs = tabs;
        boolean bl4 = false;
        $this$apply.setEnabled(false);
        Tree tree3 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"table.tree");
        tree3.getSelectionModel().addTreeSelectionListener(new Listener($this$apply));
        unit = Unit.INSTANCE;
        JComponent jComponent2 = (JComponent)((Object)lazyPanel2);
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent2).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.references", new Object[0])));
        lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.dominators", new Object[0]), false, null, new Function1<ProgressIndicator, ReverseReferencePanel.Dominators<I>>(this){
            final /* synthetic */ ObjectViewPanel this$0;

            @NotNull
            public final ReverseReferencePanel.Dominators<I> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                MuiInstance muiInstance = ObjectViewPanel.access$getSelectedValue(this.this$0);
                if (muiInstance == null) {
                    throw (Throwable)new IllegalStateException("selected null value");
                }
                this.this$0.getSnapshot().getDominator(muiInstance.getId(), indicator);
                return new ReverseReferencePanel.Dominators<I>(ObjectViewPanel.access$getView$p(this.this$0), this.this$0.getSnapshot(), ObjectViewPanel.access$getSelectedValue(this.this$0), ObjectViewPanel.access$getParentDisposable$p(this.this$0));
            }
            {
                this.this$0 = objectViewPanel;
                super(1);
            }
        }, 12, null);
        bl = false;
        bl2 = false;
        $this$apply = lazyPanel2;
        jBRunnerClosableTabs = tabs;
        boolean bl5 = false;
        $this$apply.setEnabled(false);
        Tree tree4 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree4, (String)"table.tree");
        tree4.getSelectionModel().addTreeSelectionListener(new Listener($this$apply));
        unit = Unit.INSTANCE;
        JComponent jComponent3 = (JComponent)((Object)lazyPanel2);
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent3).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.dominators", new Object[0])));
        lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.retained.objects", new Object[0]), false, null, new Function1<ProgressIndicator, ReverseReferencePanel.Retained<I>>(this){
            final /* synthetic */ ObjectViewPanel this$0;

            @NotNull
            public final ReverseReferencePanel.Retained<I> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.this$0.getSnapshot().doCalculateRetainedSize(indicator);
                return new ReverseReferencePanel.Retained<I>(ObjectViewPanel.access$getView$p(this.this$0), this.this$0.getSnapshot(), ObjectViewPanel.access$getSelectedValue(this.this$0), ObjectViewPanel.access$getParentDisposable$p(this.this$0));
            }
            {
                this.this$0 = objectViewPanel;
                super(1);
            }
        }, 12, null);
        bl = false;
        bl2 = false;
        $this$apply = lazyPanel2;
        jBRunnerClosableTabs = tabs;
        boolean bl6 = false;
        $this$apply.setEnabled(false);
        Tree tree5 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree5, (String)"table.tree");
        tree5.getSelectionModel().addTreeSelectionListener(new Listener($this$apply));
        unit = Unit.INSTANCE;
        JComponent jComponent4 = (JComponent)((Object)lazyPanel2);
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent4).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.retained.objects", new Object[0])));
        return (JComponent)tabs;
    }

    @Override
    @NotNull
    public JComponent createCenterComponent() {
        return (JComponent)((Object)this);
    }

    @NotNull
    public final List<?> getObjects() {
        return this.objects;
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    public ObjectViewPanel(@NotNull Project project, @NotNull MemoryViewTopLevelComponent view, @Nls @NotNull String tabName, @NotNull List<?> objects, @NotNull MuiSnapshot<T, I> snapshot, @NotNull Function1<? super MuiType, ? extends List<? extends MuiInstance>> classToObject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter(classToObject, (String)"classToObject");
        this.project = project;
        this.view = view;
        this.tabName = tabName;
        this.objects = objects;
        this.snapshot = snapshot;
        this.table = new JBTreeTable((TreeTableModel)new ObjectTreeTableModel(this.snapshot, this.objects, classToObject));
        Map map = ContainerUtil.createWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"ContainerUtil.createWeak\u2026y?, List<TextFragment>>()");
        this.cache = map;
        int columnPreferredWidth = this.view.getFontMetrics(this.view.getFont()).stringWidth("999,999,999,999");
        float f = (float)columnPreferredWidth / ((float)this.view.getWidth() / 2.0f);
        float f2 = 0.1f;
        boolean bl = false;
        f = Math.max(f, f2);
        f2 = 0.4f;
        bl = false;
        this.table.setColumnProportion(Math.min(f, f2));
        this.table.getTree().putClientProperty((Object)DefaultTreeUI.LARGE_MODEL_ALLOWED, (Object)true);
        Tree tree2 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"table.tree");
        tree2.setLargeModel(true);
        JBTable jBTable = this.table.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"table.table");
        jBTable.setFocusable(false);
        JBTable jBTable2 = this.table.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)jBTable2, (String)"table.table");
        ExpandableItemsHandler expandableItemsHandler = jBTable2.getExpandableItemsHandler();
        Intrinsics.checkNotNullExpressionValue((Object)expandableItemsHandler, (String)"table.table.expandableItemsHandler");
        expandableItemsHandler.setEnabled(false);
        JBTable jBTable3 = this.table.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)jBTable3, (String)"table.table");
        jBTable3.getEmptyText().clear();
        Tree tree3 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"table.tree");
        tree3.setCellRenderer((TreeCellRenderer)new MouseAwareTreeCellRendererPanel((JTree)this.table.getTree()){
            private final SimpleColoredComponent coloredComponent;
            private final ActionLink actionLink;
            private final ActionLink[] highlighters;
            private final SimpleTextAttributes WHITE_PLAIN;

            @NotNull
            public Component getTreeCellRendererComponent(@Nullable JTree tree2, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                boolean selectedAndFocused;
                this.coloredComponent.clear();
                this.actionLink.setText("");
                this.setBackground(UIUtil.getTableBackground((boolean)selected, (boolean)hasFocus));
                boolean bl = selectedAndFocused = selected && table.hasFocus();
                if (value instanceof ObjectTreeTableModel.Wrapper && ((ObjectTreeTableModel.Wrapper)value).getValue() instanceof MyLink) {
                    this.actionLink.setText(((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getText());
                    this.actionLink.setForeground(!((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getActive() && !selectedAndFocused ? UIUtil.getLabelDisabledForeground() : (selectedAndFocused ? UIUtil.getTableForeground((boolean)selected, (boolean)hasFocus) : JBUI.CurrentTheme.Link.linkColor()));
                    ButtonModel buttonModel = this.actionLink.getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)buttonModel, (String)"actionLink.model");
                    buttonModel.setRollover(this.getHighlightedComponent() == this.actionLink && this.getHighlightedRow() == row);
                } else {
                    try {
                        Iterable $this$forEach$iv = this.createTextFragments(value);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            TextFragment it = (TextFragment)element$iv;
                            boolean bl2 = false;
                            this.coloredComponent.append(it.getText(), selectedAndFocused ? this.WHITE_PLAIN : it.getAttributes());
                        }
                        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((JComponent)table.getTree()), (SimpleColoredComponent)this.coloredComponent, (boolean)false, (boolean)selected);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return (Component)((Object)this);
            }

            @NotNull
            protected ActionLink[] getHighlightables() {
                return this.highlighters;
            }

            public boolean isHighlightEnabled(int row, @Nullable Object value) {
                return value instanceof ObjectTreeTableModel.Wrapper && ((ObjectTreeTableModel.Wrapper)value).getValue() instanceof MyLink && ((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getActive();
            }

            protected void mouseClicked(@Nullable MouseEvent event) {
                Object object = this.getHighlightedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel.Wrapper");
                }
                Object object2 = ((ObjectTreeTableModel.Wrapper)object).getValue();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel.MyLink");
                }
                MyLink myLink = (MyLink)object2;
                boolean bl = false;
                boolean bl2 = false;
                MyLink $this$with = myLink;
                boolean bl3 = false;
                boolean bl4 = $this$with.getActive();
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "Disabled link clicked";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                $this$with.setActive(false);
                $this$with.getAction().invoke();
            }
            {
                super($super_call_param$1);
                this.coloredComponent = new SimpleColoredComponent();
                this.actionLink = new ActionLink();
                this.highlighters = new ActionLink[]{this.actionLink};
                this.WHITE_PLAIN = new SimpleTextAttributes(0, Color.WHITE);
                this.setLayout((LayoutManager)new HorizontalLayout(0));
                this.add((Component)this.coloredComponent);
                this.add((Component)this.actionLink);
            }
        });
        this.table.getTable().setDefaultRenderer(Long.TYPE, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@Nullable JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component;
                Component component2 = component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                component2.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)table.hasFocus()));
                component.setForeground(UIUtil.getTableForeground((boolean)isSelected, (boolean)table.hasFocus()));
                return component;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void setValue(@Nullable Object value) {
                Object object;
                3 v0;
                block3: {
                    block2: {
                        void it;
                        v0 = this;
                        object = value;
                        if (object == null) break block2;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object object3 = object2;
                        3 var10_6 = v0;
                        boolean bl3 = false;
                        String string = "%,d";
                        Object[] objectArray = new Object[]{it};
                        boolean bl4 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                        String string3 = string2;
                        v0 = var10_6;
                        object = string3;
                        if (object != null) break block3;
                    }
                    object = "";
                }
                v0.setText((String)object);
            }
            {
                this.setHorizontalAlignment(4);
            }
        });
        new TreeSpeedSearch(this.table.getTree(), (Convertor)new Convertor<TreePath, String>(){

            /*
             * WARNING - void declaration
             */
            public final String convert(TreePath it) {
                void $this$mapTo$iv$iv;
                TreePath treePath = it;
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"it");
                Iterable $this$map$iv = this.createTextFragments(treePath.getLastPathComponent());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void receiver;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = ((TextFragment)receiver).getText();
                    collection.add(string);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }
        });
        Tree tree4 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree4, (String)"table.tree");
        ActionsKt.installActions(tree4, this.view, this.snapshot, (Function1<? super TreePath, ? extends Object>)((Function1)5.INSTANCE));
        this.addToCenter((Component)this.table);
    }

    public /* synthetic */ ObjectViewPanel(Project project, MemoryViewTopLevelComponent memoryViewTopLevelComponent, String string, List list, MuiSnapshot muiSnapshot, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        this(project, memoryViewTopLevelComponent, string, list, muiSnapshot, (Function1<? super MuiType, ? extends List<? extends MuiInstance>>)function1);
    }

    public static final /* synthetic */ MuiInstance access$getSelectedValue(ObjectViewPanel $this) {
        return $this.getSelectedValue();
    }

    public static final /* synthetic */ MemoryViewTopLevelComponent access$getView$p(ObjectViewPanel $this) {
        return $this.view;
    }

    public static final /* synthetic */ MemoryViewTopLevelComponent access$getParentDisposable$p(ObjectViewPanel $this) {
        return $this.getParentDisposable();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel$Listener;", "Ljavax/swing/event/TreeSelectionListener;", "lazyPanel", "Lcom/intellij/profiler/ultimate/hprof/ui/LazyPanel;", "(Lcom/intellij/profiler/ultimate/hprof/ui/LazyPanel;)V", "getLazyPanel", "()Lcom/intellij/profiler/ultimate/hprof/ui/LazyPanel;", "valueChanged", "", "e", "Ljavax/swing/event/TreeSelectionEvent;", "intellij.profiler.ultimate"})
    private static final class Listener
    implements TreeSelectionListener {
        @NotNull
        private final LazyPanel<?> lazyPanel;

        @Override
        public void valueChanged(@Nullable TreeSelectionEvent e) {
            MuiInstance muiInstance;
            Object object = e;
            if (object != null && (object = ((TreeSelectionEvent)object).getPath()) != null && (object = ((TreePath)object).getLastPathComponent()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                muiInstance = ActionsKt.getMuiInstanceOrNull(ObjectViewPanelKt.access$tryUnwrapOrSelf(it));
            } else {
                muiInstance = null;
            }
            MuiInstance value = muiInstance;
            this.lazyPanel.clear();
            this.lazyPanel.setEnabled(value != null);
        }

        @NotNull
        public final LazyPanel<?> getLazyPanel() {
            return this.lazyPanel;
        }

        public Listener(@NotNull LazyPanel<?> lazyPanel2) {
            Intrinsics.checkNotNullParameter(lazyPanel2, (String)"lazyPanel");
            this.lazyPanel = lazyPanel2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel$MyLink;", "", "text", "", "action", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "active", "", "getActive", "()Z", "setActive", "(Z)V", "getText", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
    private static final class MyLink {
        private boolean active;
        @NotNull
        private final String text;
        @NotNull
        private final Function0<Unit> action;

        public final boolean getActive() {
            return this.active;
        }

        public final void setActive(boolean bl) {
            this.active = bl;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public MyLink(@NotNull String text, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.text = text;
            this.action = action;
            this.active = true;
        }
    }
}

